/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.grpc.internal.config;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.application.lifecycle.ApplicationRecycleComponent;
import com.ibm.wsspi.application.lifecycle.ApplicationRecycleContext;
import com.ibm.wsspi.application.lifecycle.ApplicationRecycleCoordinator;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import io.openliberty.grpc.internal.config.GrpcServiceConfig;
import io.openliberty.grpc.internal.config.GrpcServiceConfigHolder;
import io.openliberty.grpc.internal.config.GrpcServiceConfigValidation;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(immediate=true, service={GrpcServiceConfig.class, ApplicationRecycleComponent.class}, configurationPid={"io.openliberty.grpc.serverConfig"}, configurationPolicy=ConfigurationPolicy.REQUIRE, property={"service.vendor=IBM"})
public class GrpcServiceConfigImpl
implements GrpcServiceConfig,
ApplicationRecycleComponent {
    private static final TraceComponent tc = Tr.register(GrpcServiceConfigImpl.class, (String)"GRPC", (String)"io.openliberty.grpc.internal.resources.grpcmessages");
    @Reference(name="appRecycleService")
    private ApplicationRecycleCoordinator appRecycleSvcRef;
    private static final Set<String> applications = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final HashSet<String> propertiesToRemove = new HashSet();
    static final long serialVersionUID = 8466235308105479799L;

    private Map<String, String> filterProps(Map<String, Object> props) {
        boolean debug;
        HashMap<String, String> filteredProps = new HashMap<String, String>();
        Iterator<String> it = props.keySet().iterator();
        boolean bl = debug = tc.isDebugEnabled() && TraceComponent.isAnyTracingEnabled();
        while (it.hasNext()) {
            String key = it.next();
            if (debug) {
                Tr.debug((TraceComponent)tc, (String)("key: " + key + " value: " + props.get(key)), (Object[])new Object[0]);
            }
            if (propertiesToRemove.contains(key) || key.compareTo("maxInboundMessageSize") == 0 && !GrpcServiceConfigValidation.validateMaxInboundMessageSize(props.get(key).toString())) continue;
            filteredProps.put(key, props.get(key).toString());
        }
        return filteredProps;
    }

    private String getServiceName(Map<String, Object> props) {
        if (props == null) {
            return null;
        }
        if (props.keySet().contains("target")) {
            return props.get("target").toString();
        }
        return null;
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        if (properties == null) {
            return;
        }
        String serviceName = this.getServiceName(properties);
        if (serviceName == null) {
            return;
        }
        GrpcServiceConfigHolder.addConfig(this.toString(), serviceName, this.filterProps(properties));
        this.recycleDependentApps();
    }

    @Modified
    protected void modified(Map<String, Object> properties) {
        if (properties == null) {
            return;
        }
        GrpcServiceConfigHolder.removeConfig(this.toString());
        String serviceName = this.getServiceName(properties);
        if (serviceName == null) {
            return;
        }
        GrpcServiceConfigHolder.addConfig(this.toString(), serviceName, this.filterProps(properties));
        this.recycleDependentApps();
    }

    @Deactivate
    protected void deactivate() {
        GrpcServiceConfigHolder.removeConfig(this.toString());
        this.recycleDependentApps();
    }

    private void recycleDependentApps() {
        Set<String> members = this.getDependentApplications();
        if (!members.isEmpty() && !FrameworkState.isStopping()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("recycling applications: " + members), (Object[])new Object[0]);
            }
            this.appRecycleSvcRef.recycleApplications(members);
        }
    }

    public ApplicationRecycleContext getContext() {
        return null;
    }

    public Set<String> getDependentApplications() {
        HashSet<String> members = new HashSet<String>();
        members.addAll(applications);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("getDependentApplications: " + members), (Object[])new Object[0]);
        }
        return members;
    }

    public static void addApplication(String name) {
        applications.add(name);
    }

    public static void removeApplication(String name) {
        applications.remove(name);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        propertiesToRemove.add("defaultSSHPublicKeyPath");
        propertiesToRemove.add("defaultSSHPrivateKeyPath");
        propertiesToRemove.add("config.overrides");
        propertiesToRemove.add("config.id");
        propertiesToRemove.add("component.id");
        propertiesToRemove.add("config.displayId");
        propertiesToRemove.add("component.name");
        propertiesToRemove.add("config.source");
        propertiesToRemove.add("service.pid");
        propertiesToRemove.add("service.vendor");
        propertiesToRemove.add("service.factoryPid");
        propertiesToRemove.add("target");
    }
}

