/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.grpc.internal.config;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class GrpcServiceConfigHolder {
    private static final TraceComponent tc = Tr.register(GrpcServiceConfigHolder.class, (String)"GRPC", (String)"io.openliberty.grpc.internal.resources.grpcmessages");
    private static volatile Map<String, Map<String, String>> configInfo = new TreeMap<String, Map<String, String>>();
    private static volatile Map<String, String> serviceMap = new HashMap<String, String>();
    private static volatile Map<String, Map<String, String>> resolvedConfigInfoCache = new HashMap<String, Map<String, String>>();
    private static boolean wildcardsPresentInConfigInfo = false;
    static final long serialVersionUID = -1408235694071486412L;

    public static synchronized void addConfig(String id, String uri, Map<String, String> params) {
        serviceMap.put(id, uri);
        configInfo.put(uri, params);
        resolvedConfigInfoCache.clear();
        if (uri.endsWith("*")) {
            wildcardsPresentInConfigInfo = true;
        }
    }

    public static synchronized void removeConfig(String objectId) {
        String uri = serviceMap.get(objectId);
        if (uri != null) {
            configInfo.remove(uri);
        }
        serviceMap.remove(objectId);
        resolvedConfigInfoCache.clear();
    }

    public static String getServiceInterceptors(String uri) {
        Map<String, String> props = GrpcServiceConfigHolder.getURIProps(uri);
        if (props != null) {
            return props.get("serverInterceptors");
        }
        return null;
    }

    public static int getMaxInboundMessageSize(String uri) {
        String prop;
        Map<String, String> props = GrpcServiceConfigHolder.getURIProps(uri);
        if (props != null && (prop = props.get("maxInboundMessageSize")) != null && prop != "") {
            return Integer.parseInt(prop);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getURIProps(String uri) {
        boolean debug;
        boolean bl = debug = tc.isDebugEnabled() && TraceComponent.isAnyTracingEnabled();
        if (configInfo.isEmpty()) {
            if (debug) {
                Tr.debug((TraceComponent)tc, (String)"getUriprops is empty, return null", (Object[])new Object[0]);
            }
            return null;
        }
        Map<String, Map<String, String>> map = resolvedConfigInfoCache;
        synchronized (map) {
            Map<String, String> props = resolvedConfigInfoCache.get(uri);
            if (props != null) {
                if (debug) {
                    Tr.debug((TraceComponent)tc, (String)("getUriprops cache hit, uri: " + uri + "props: " + props), (Object[])new Object[0]);
                }
                return props.isEmpty() ? null : props;
            }
        }
        HashMap<String, String> mergedProps = new HashMap<String, String>();
        Class<GrpcServiceConfigHolder> clazz = GrpcServiceConfigHolder.class;
        synchronized (GrpcServiceConfigHolder.class) {
            Map<String, String> props = configInfo.get(uri);
            if (props != null) {
                if (debug) {
                    Tr.debug((TraceComponent)tc, (String)("getUriprops exact match: " + uri), (Object[])new Object[0]);
                }
                mergedProps.putAll(props);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (!wildcardsPresentInConfigInfo) {
                if (debug) {
                    Tr.debug((TraceComponent)tc, (String)("getUriprops no wildcards, cache and return what we've got: " + mergedProps), (Object[])new Object[0]);
                }
                clazz = GrpcServiceConfigHolder.class;
                synchronized (GrpcServiceConfigHolder.class) {
                    resolvedConfigInfoCache.put(uri, mergedProps);
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return mergedProps.isEmpty() ? null : mergedProps;
                }
            }
            if (debug) {
                Tr.debug((TraceComponent)tc, (String)"begin wildcard search", (Object[])new Object[0]);
            }
            clazz = GrpcServiceConfigHolder.class;
            synchronized (GrpcServiceConfigHolder.class) {
                Iterator<String> it = configInfo.keySet().iterator();
                String trimmedKey = null;
                while (it.hasNext()) {
                    String key = it.next();
                    if (!key.endsWith("*") || !uri.startsWith(trimmedKey = key.substring(0, key.length() - 1))) continue;
                    if (debug) {
                        Tr.debug((TraceComponent)tc, (String)("getUriprops match = " + key + ", will merge these props: " + configInfo.get(key)), (Object[])new Object[0]);
                    }
                    mergedProps.putAll(configInfo.get(key));
                }
                resolvedConfigInfoCache.put(uri, mergedProps);
                if (debug) {
                    Tr.debug((TraceComponent)tc, (String)("getUriprops final result for uri: " + uri + "values: " + mergedProps), (Object[])new Object[0]);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return mergedProps.isEmpty() ? null : mergedProps;
            }
        }
    }
}

