/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.impl;

import com.ibm.ejs.cm.logger.TraceWriter;
import com.ibm.ejs.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.impl.DatabaseHelper;
import com.ibm.ws.rsadapter.impl.WSManagedConnectionFactoryImpl;
import com.ibm.ws.rsadapter.impl.WSRdbManagedConnectionImpl;
import com.ibm.ws.rsadapter.jdbc.WSJdbcTracer;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.resource.ResourceException;

public class DataDirectConnectSQLServerHelper
extends DatabaseHelper {
    private static final TraceComponent tc = com.ibm.websphere.ras.Tr.register(DataDirectConnectSQLServerHelper.class, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    private static final String LONG_DATA_CACHE_SIZE = "longDataCacheSize";
    private final AtomicReference<Method> getNetworkTimeout = new AtomicReference();
    private int longDataCacheSize = 2048;
    private final AtomicReference<Method> setLongDataCacheSize = new AtomicReference();
    private final AtomicReference<Method> setNetworkTimeout = new AtomicReference();
    private transient com.ibm.ejs.ras.TraceComponent sqlserverTc = Tr.register((String)"com.ibm.ws.sqlserver.logwriter", (String)"WAS.database", null);
    final Set<Integer> staleDDErrorCodes = new HashSet<Integer>();
    final Set<String> staleDDSQLStates = new HashSet<String>();
    final Set<Integer> staleMSErrorCodes = new HashSet<Integer>();
    private final AtomicBoolean supportsSetLongDataCacheSize = new AtomicBoolean(true);
    private final AtomicBoolean supportsNetworkTimeout = new AtomicBoolean(true);

    DataDirectConnectSQLServerHelper(WSManagedConnectionFactoryImpl mcf) {
        super(mcf);
        mcf.defaultIsolationLevel = 4;
        Properties props = mcf.dsConfig.get().vendorProps;
        Object value = props.get(LONG_DATA_CACHE_SIZE);
        try {
            this.longDataCacheSize = value instanceof Number ? ((Number)value).intValue() : (value instanceof String ? Integer.parseInt((String)value) : this.longDataCacheSize);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)("Default longDataCacheSize = " + this.longDataCacheSize), (Object[])new Object[0]);
        }
    }

    @Override
    void customizeStaleStates() {
        super.customizeStaleStates();
        Collections.addAll(this.staleDDErrorCodes, 2217, 2251, 2306, 2310, 2311);
        Collections.addAll(this.staleDDSQLStates, "08000", "08002", "08004", "08007");
        this.staleSQLStates.remove("40003");
        this.staleSQLStates.remove("S1000");
        Collections.addAll(this.staleMSErrorCodes, 230, 6001, 6002, 6005, 6006);
    }

    @Override
    public boolean doConnectionCleanup(Connection conn) throws SQLException {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            com.ibm.websphere.ras.Tr.entry((Object)this, (TraceComponent)tc, (String)"doConnectionCleanup", (Object[])new Object[]{AdapterUtil.toString(conn)});
        }
        boolean updated = false;
        Method method = this.getNetworkTimeout.get();
        if (method == null && this.supportsNetworkTimeout.get()) {
            try {
                method = conn.getClass().getMethod("getNetworkTimeout", new Class[0]);
                this.getNetworkTimeout.set(method);
            }
            catch (NoSuchMethodException x) {
                if (trace && tc.isDebugEnabled()) {
                    com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"getNetworkTimeout not supported.", (Object[])new Object[0]);
                }
                this.supportsNetworkTimeout.set(false);
            }
        }
        if (method != null) {
            try {
                int networkTimeout = (Integer)method.invoke((Object)conn, new Object[0]);
                if (networkTimeout != 0) {
                    method = this.setNetworkTimeout.get();
                    if (method == null) {
                        method = conn.getClass().getMethod("setNetworkTimeout", Integer.TYPE);
                        this.setNetworkTimeout.set(method);
                    }
                    method.invoke((Object)conn, 0);
                    updated = true;
                }
            }
            catch (InvocationTargetException x) {
                if (trace && tc.isDebugEnabled()) {
                    com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"doConnectionCleanup", (Object[])new Object[]{x.getCause()});
                }
                this.supportsNetworkTimeout.set(false);
                this.getNetworkTimeout.set(null);
                this.setNetworkTimeout.set(null);
            }
            catch (IllegalAccessException x) {
                if (trace && tc.isDebugEnabled()) {
                    com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"NetworkTimeout not supported.", (Object[])new Object[0]);
                }
                this.supportsNetworkTimeout.set(false);
                this.getNetworkTimeout.set(null);
                this.setNetworkTimeout.set(null);
            }
            catch (NoSuchMethodException x) {
                FFDCFilter.processException((Throwable)x, (String)this.getClass().getName(), (String)"237", (Object)this);
                throw new SQLFeatureNotSupportedException(x);
            }
        }
        if (trace && tc.isEntryEnabled()) {
            com.ibm.websphere.ras.Tr.exit((Object)this, (TraceComponent)tc, (String)"doConnectionCleanup");
        }
        return updated;
    }

    @Override
    public void doStatementCleanup(PreparedStatement stmt) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            com.ibm.websphere.ras.Tr.entry((Object)this, (TraceComponent)tc, (String)"doStatementCleanup", (Object[])new Object[]{AdapterUtil.toString(stmt)});
        }
        stmt.setFetchDirection(1000);
        stmt.setMaxFieldSize(0);
        stmt.setMaxRows(0);
        Integer queryTimeout = this.mcf.dsConfig.get().queryTimeout;
        if (queryTimeout == null) {
            queryTimeout = this.defaultQueryTimeout;
        }
        stmt.setQueryTimeout(queryTimeout);
        stmt = (PreparedStatement)WSJdbcTracer.getImpl(stmt);
        Method method = this.setLongDataCacheSize.get();
        if (method == null && this.supportsSetLongDataCacheSize.get()) {
            try {
                method = stmt.getClass().getMethod("setLongDataCacheSize", Integer.TYPE);
                this.setLongDataCacheSize.set(method);
            }
            catch (NoSuchMethodException x) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"LongDataCacheSize not supported.", (Object[])new Object[0]);
                }
                this.supportsSetLongDataCacheSize.set(false);
            }
        }
        if (method != null) {
            try {
                method.invoke((Object)stmt, this.longDataCacheSize);
            }
            catch (InvocationTargetException x) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    com.ibm.websphere.ras.Tr.exit((Object)this, (TraceComponent)tc, (String)"doStatementCleanup", (Object)x.getCause());
                }
                throw (SQLException)x.getCause();
            }
            catch (IllegalAccessException x) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"LongDataCacheSize not supported.", (Object[])new Object[0]);
                }
                this.supportsSetLongDataCacheSize.set(false);
                this.setLongDataCacheSize.set(null);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            com.ibm.websphere.ras.Tr.exit((Object)this, (TraceComponent)tc, (String)"doStatementCleanup");
        }
    }

    @Override
    public com.ibm.ejs.ras.TraceComponent getTracer() {
        return null;
    }

    @Override
    boolean isAuthException(SQLException x) {
        int ec = x.getErrorCode();
        return x instanceof SQLInvalidAuthorizationSpecException || x.getSQLState() != null && x.getSQLState().startsWith("28") || ec >= 18450 && ec <= 18452 || ec >= 18456 && ec <= 18461 || ec == 18470 || ec == 18483 || ec >= 18485 && ec <= 18488;
    }

    @Override
    public PrintWriter getPrintWriter() throws ResourceException {
        if (this.genPw == null) {
            this.genPw = new PrintWriter((Writer)new TraceWriter(this.sqlserverTc), true);
        }
        com.ibm.websphere.ras.Tr.debug((TraceComponent)this.sqlserverTc, (String)"returning", (Object[])new Object[]{this.genPw});
        return this.genPw;
    }

    @Override
    public boolean isConnectionError(SQLException ex) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            com.ibm.websphere.ras.Tr.entry((Object)this, (TraceComponent)tc, (String)"isConnectionError", (Object[])new Object[]{ex});
        }
        HashSet<SQLException> chain = new HashSet<SQLException>();
        boolean stale = super.isConnectionError(ex);
        for (Throwable t = ex; t != null && !stale && chain.add((SQLException)t); t = t.getCause()) {
            SQLException sqlX;
            Throwable throwable = sqlX = t instanceof SQLException ? t : null;
            if (isTraceOn && tc.isDebugEnabled()) {
                com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)("checking " + t), (Object[])new Object[]{sqlX == null ? null : sqlX.getSQLState(), sqlX == null ? null : Integer.valueOf(sqlX.getErrorCode())});
            }
            if (sqlX == null) continue;
            stale |= this.isDataDirectExp(ex) ? this.staleDDErrorCodes.contains(sqlX.getErrorCode()) || this.staleDDSQLStates.contains(sqlX.getSQLState()) : this.staleMSErrorCodes.contains(sqlX.getErrorCode());
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            com.ibm.websphere.ras.Tr.exit((Object)this, (TraceComponent)tc, (String)"isConnectionError", (Object)stale);
        }
        return stale;
    }

    private boolean isDataDirectExp(SQLException e) {
        String message = e.getMessage();
        int ind = message.indexOf(91, 2);
        if ((ind = message.indexOf("][", ind + 10)) != -1) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"The exception is NOT a DataDirect exception ", (Object[])new Object[0]);
            }
            return false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"the exception is a DataDirect exception  ", (Object[])new Object[0]);
        }
        return true;
    }

    @Override
    public boolean shouldTraceBeEnabled(WSManagedConnectionFactoryImpl mcf) {
        return TraceComponent.isAnyTracingEnabled() && this.sqlserverTc.isDebugEnabled() && !mcf.loggingEnabled;
    }

    @Override
    public boolean shouldTraceBeEnabled(WSRdbManagedConnectionImpl mc) {
        return this.shouldTraceBeEnabled(mc.mcf);
    }

    @Override
    public boolean shouldTraceBeDisabled(WSRdbManagedConnectionImpl mc) {
        return TraceComponent.isAnyTracingEnabled() && !this.sqlserverTc.isDebugEnabled() && mc.mcf.loggingEnabled;
    }

    @Override
    public boolean supportsSubjectDoAsForKerberos() {
        return true;
    }
}

