/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.ws.impl;

import com.ibm.jbatch.container.ws.BatchJobNotLocalException;
import com.ibm.jbatch.container.ws.BatchLocationService;
import com.ibm.jbatch.container.ws.WSJobExecution;
import com.ibm.jbatch.container.ws.WSRemotablePartitionExecution;
import com.ibm.websphere.kernel.server.ServerInfoMBean;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.batch.operations.BatchRuntimeException;
import javax.batch.runtime.BatchRuntime;
import javax.batch.runtime.JobExecution;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPolicy=ConfigurationPolicy.IGNORE)
public class BatchLocationServiceImpl
implements BatchLocationService {
    protected static final String BatchRestUrlUnavailable = "SSL-ENDPOINT-UNAVAILABLE";
    private DynamicMBean endpointInfoMBean;
    private ServerInfoMBean serverInfoMBean;
    static final long serialVersionUID = 2578415400433756319L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Reference(target="(jmx.objectname=WebSphere:feature=channelfw,type=endpoint,name=defaultHttpEndpoint-ssl)", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setEndPointInfoMBean(DynamicMBean endpointInfoMBean) {
        this.endpointInfoMBean = endpointInfoMBean;
    }

    protected void unsetEndPointInfoMBean(DynamicMBean endpointInfoMBean) {
        if (this.endpointInfoMBean == endpointInfoMBean) {
            this.endpointInfoMBean = null;
        }
    }

    @Reference
    protected void setServerInfoMBean(ServerInfoMBean serverInfoMBean) {
        this.serverInfoMBean = serverInfoMBean;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getBatchRestUrl() {
        if (this.endpointInfoMBean == null) {
            return BatchRestUrlUnavailable;
        }
        try {
            String host = this.resolveHost((String)this.endpointInfoMBean.getAttribute("Host"));
            int port = (Integer)this.endpointInfoMBean.getAttribute("Port");
            return "https://" + host + ":" + port + "/ibm/api/batch";
        }
        catch (MBeanException host) {
            void mbe;
            FFDCFilter.processException((Throwable)host, (String)"com.ibm.jbatch.container.ws.impl.BatchLocationServiceImpl", (String)"107", (Object)this, (Object[])new Object[0]);
            throw new BatchRuntimeException((Throwable)mbe);
        }
        catch (ReflectionException mbe) {
            void re;
            FFDCFilter.processException((Throwable)mbe, (String)"com.ibm.jbatch.container.ws.impl.BatchLocationServiceImpl", (String)"109", (Object)this, (Object[])new Object[0]);
            throw new BatchRuntimeException((Throwable)re);
        }
        catch (AttributeNotFoundException re) {
            void anfe;
            FFDCFilter.processException((Throwable)re, (String)"com.ibm.jbatch.container.ws.impl.BatchLocationServiceImpl", (String)"111", (Object)this, (Object[])new Object[0]);
            throw new BatchRuntimeException((Throwable)anfe);
        }
    }

    protected String resolveHost(String host) {
        if ("*".equals(host) && ((host = this.serverInfoMBean.getDefaultHostname()) == null || host.equals("localhost"))) {
            host = this.getLocalHostIpAddress();
        }
        return host == null || host.trim().isEmpty() ? "localhost" : host;
    }

    protected String getLocalHostIpAddress() {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){
                static final long serialVersionUID = 8567465869807687530L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public String run() throws UnknownHostException {
                    return InetAddress.getLocalHost().getHostAddress();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.ws.impl.BatchLocationServiceImpl$1", 1.class, null, null);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.jbatch.container.ws.impl.BatchLocationServiceImpl", (String)"147", (Object)this, (Object[])new Object[0]);
            return null;
        }
    }

    @Override
    public String getServerId() {
        String fixedUserDir = this.stripFileSeparateAtTheEnd(this.serverInfoMBean.getUserDirectory().trim());
        return this.serverInfoMBean.getDefaultHostname() + "/" + fixedUserDir + "/" + this.serverInfoMBean.getName();
    }

    protected String stripFileSeparateAtTheEnd(String path) {
        return path != null && (path.endsWith("/") || path.endsWith("\\")) ? path.substring(0, path.length() - 1) : path;
    }

    @Override
    public boolean isLocalJobExecution(WSJobExecution jobExecution) {
        return jobExecution.getServerId() == null || jobExecution.getRestUrl() == null || this.getBatchRestUrl().equals(jobExecution.getRestUrl()) || BatchRestUrlUnavailable.equals(jobExecution.getRestUrl()) && this.getServerId().equals(jobExecution.getServerId());
    }

    @Override
    public boolean isLocalJobExecution(long executionId) {
        JobExecution jobExecution = BatchRuntime.getJobOperator().getJobExecution(executionId);
        return jobExecution instanceof WSJobExecution ? this.isLocalJobExecution((WSJobExecution)jobExecution) : true;
    }

    @Override
    public boolean isLocalRemotablePartition(WSRemotablePartitionExecution partition) {
        return this.getBatchRestUrl().equals(partition.getRestUrl());
    }

    @Override
    public JobExecution assertIsLocalJobExecution(long executionId) throws BatchJobNotLocalException {
        JobExecution jobExecution = BatchRuntime.getJobOperator().getJobExecution(executionId);
        if (jobExecution instanceof WSJobExecution && !this.isLocalJobExecution((WSJobExecution)jobExecution)) {
            throw new BatchJobNotLocalException((WSJobExecution)jobExecution, this.getBatchRestUrl(), this.getServerId());
        }
        return jobExecution;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.ws.impl.BatchLocationServiceImpl", BatchLocationServiceImpl.class, null, null);
    }
}

