/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.server.plugins;

import com.ibm.oauth.core.api.error.OAuthConfigurationException;
import com.ibm.oauth.core.internal.oauth20.OAuth20ComponentInternal;
import com.ibm.oauth.core.internal.oauth20.config.OAuth20ConfigProvider;
import com.ibm.oauth.core.internal.oauth20.tokentype.OAuth20TokenTypeHandler;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.HashMap;
import java.util.Map;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OIDCTokenTypeHandlerFactory {
    private static Map<String, OAuth20TokenTypeHandler> handlerMap;
    static final long serialVersionUID = 4600569226800522852L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static synchronized OAuth20TokenTypeHandler getHandler(OAuth20ComponentInternal component) throws OAuthConfigurationException {
        OAuth20TokenTypeHandler result = null;
        String componentId = component.getParentComponentInstance().getInstanceId();
        result = handlerMap.get(componentId);
        if (result == null) {
            OAuth20ConfigProvider config = component.get20Configuration();
            result = config.getTokenTypeHandler();
            handlerMap.put(componentId, result);
        }
        return result;
    }

    public static synchronized OAuth20TokenTypeHandler getIDTokenHandler(OAuth20ComponentInternal component) throws OAuthConfigurationException {
        OAuth20TokenTypeHandler result = null;
        String componentId = component.getParentComponentInstance().getInstanceId();
        String componentIdToken = componentId + "_IDTOKEN";
        result = handlerMap.get(componentIdToken);
        if (result == null) {
            OAuth20ConfigProvider config = component.get20Configuration();
            result = config.getIDTokenTypeHandler();
            handlerMap.put(componentIdToken, result);
        }
        return result;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.openidconnect.server.plugins.OIDCTokenTypeHandlerFactory", OIDCTokenTypeHandlerFactory.class, (String)"OpenIdConnect", (String)"com.ibm.ws.security.openidconnect.server.internal.resources.OidcServerMessages");
        handlerMap = new HashMap<String, OAuth20TokenTypeHandler>();
    }
}

