/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.server.plugins;

import com.ibm.oauth.core.api.error.OAuthConfigurationException;
import com.ibm.oauth.core.api.error.OAuthException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20Exception;
import com.ibm.oauth.core.api.error.oauth20.OAuth20InvalidGrantTypeException;
import com.ibm.oauth.core.internal.oauth20.OAuth20Constants;
import com.ibm.oauth.core.internal.oauth20.config.OAuth20ConfigProvider;
import com.ibm.oauth.core.internal.oauth20.granttype.OAuth20GrantTypeHandler;
import com.ibm.oauth.core.internal.oauth20.granttype.OAuth20GrantTypeHandlerFactory;
import com.ibm.oauth.core.internal.oauth20.granttype.impl.OAuth20GrantTypeHandlerAppTokenAndPasswordImpl;
import com.ibm.oauth.core.internal.oauth20.granttype.impl.OAuth20GrantTypeHandlerClientCredentialsImpl;
import com.ibm.oauth.core.internal.oauth20.granttype.impl.OAuth20GrantTypeHandlerResourceOwnerCredentialsImpl;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.api.OAuth20Provider;
import com.ibm.ws.security.oauth20.plugins.JwtGrantTypeHandlerFactory;
import com.ibm.ws.security.openidconnect.server.internal.Utils;
import com.ibm.ws.security.openidconnect.server.plugins.OIDCGrantTypeHandlerCodeImpl;
import com.ibm.ws.security.openidconnect.server.plugins.OIDCGrantTypeHandlerRefreshImpl;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class OIDCGrantTypeHandlerFactoryImpl
implements OAuth20GrantTypeHandlerFactory {
    private static final TraceComponent tc = Tr.register(OIDCGrantTypeHandlerFactoryImpl.class, (String)"OpenIdConnect", (String)"com.ibm.ws.security.openidconnect.server.internal.resources.OidcServerMessages");
    static final long serialVersionUID = -34953805311888415L;

    protected void activate(ComponentContext cc, Map<String, Object> properties) {
    }

    protected void deactivate(ComponentContext cc, Map<String, Object> properties) {
    }

    protected void modified(ComponentContext cc, Map<String, Object> properties) {
    }

    public String toStringHelper(Set<String> s) {
        StringBuilder sb = new StringBuilder("{");
        String sep = "";
        for (String str : s) {
            sb.append(sep).append(str);
            sep = ",";
        }
        return sb.append("}").toString();
    }

    public synchronized OAuth20GrantTypeHandler getHandler(String providerId, String grantType, OAuth20ConfigProvider config) throws OAuthException {
        Object result = null;
        if (grantType != null) {
            if (!OAuth20Constants.ALL_GRANT_TYPES_SET.contains(grantType)) {
                String validGrantTypesAsString = this.toStringHelper(OAuth20Constants.ALL_GRANT_TYPES_SET);
                Tr.error((TraceComponent)tc, (String)"OIDC_SERVER_INVALID_GRANT_TYPE_ERR", (Object[])new Object[]{grantType, validGrantTypesAsString});
                throw new OAuth20InvalidGrantTypeException("security.oauth20.error.invalid.granttype", grantType);
            }
            if (grantType.equals("app_token") || grantType.equals("app_password")) {
                result = this.getCustomGTHandlerInstance(providerId, config, grantType);
            } else {
                if (!config.isGrantTypeAllowed(grantType)) {
                    String allowedGrantTypesAsString = "";
                    if (config instanceof OAuth20Provider) {
                        allowedGrantTypesAsString = Utils.toString(((OAuth20Provider)config).getGrantTypesAllowed());
                    }
                    Tr.error((TraceComponent)tc, (String)"OIDC_SERVER_GRANT_TYPE_NOT_ALLOWED_ERR", (Object[])new Object[]{grantType, allowedGrantTypesAsString});
                    throw new OAuthConfigurationException("oauth20.grant.types.allowed", grantType, null);
                }
                if (grantType.equals("authorization_code")) {
                    result = new OIDCGrantTypeHandlerCodeImpl();
                } else if (grantType.equals("client_credentials")) {
                    result = new OAuth20GrantTypeHandlerClientCredentialsImpl();
                } else if (grantType.equals("password")) {
                    result = new OAuth20GrantTypeHandlerResourceOwnerCredentialsImpl();
                } else if (grantType.equals("refresh_token")) {
                    result = new OIDCGrantTypeHandlerRefreshImpl(config);
                } else if (grantType.equals("urn:ietf:params:oauth:grant-type:jwt-bearer")) {
                    result = this.getJwtHandlerInstance(providerId, config);
                }
            }
        }
        if (result == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Cannot get handler to process the grant type : ", (Object[])new Object[]{grantType});
            }
            throw new OAuth20InvalidGrantTypeException("security.oauth20.error.invalid.granttype", grantType);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized OAuth20GrantTypeHandler getJwtHandlerInstance(String providerId, OAuth20ConfigProvider config) throws OAuth20Exception {
        OAuth20GrantTypeHandler instance;
        block5: {
            String handlerClassName = "com.ibm.ws.security.oauth20.jwt.GrantTypeCustomizedHandlerJwtImpl";
            instance = null;
            JwtGrantTypeHandlerFactory jwtHandler = null;
            try {
                Class<?> handlerClass = Class.forName(handlerClassName);
                try {
                    jwtHandler = (JwtGrantTypeHandlerFactory)handlerClass.newInstance();
                    jwtHandler.setHandlerInfo(providerId, (OAuth20Provider)config);
                    instance = jwtHandler.getHandlerInstance();
                }
                catch (Exception exception) {
                    void e;
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.openidconnect.server.plugins.OIDCGrantTypeHandlerFactoryImpl", (String)"128", (Object)this, (Object[])new Object[]{providerId, config});
                    Tr.error((TraceComponent)tc, (String)"JWT_UNEXPECTED_EXCEPTION_ERR", (Object[])new Object[]{e.toString()});
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Get an unexpected exception ", (Object[])new Object[]{e});
                    }
                }
            }
            catch (ClassNotFoundException handlerClass) {
                void e;
                FFDCFilter.processException((Throwable)handlerClass, (String)"com.ibm.ws.security.openidconnect.server.plugins.OIDCGrantTypeHandlerFactoryImpl", (String)"135", (Object)this, (Object[])new Object[]{providerId, config});
                Tr.error((TraceComponent)tc, (String)"JWT_UNEXPECTED_EXCEPTION_ERR", (Object[])new Object[]{e.toString()});
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug((TraceComponent)tc, (String)"Get an unexpected exception ", (Object[])new Object[]{e});
            }
        }
        return instance;
    }

    public synchronized OAuth20GrantTypeHandler getCustomGTHandlerInstance(String providerId, OAuth20ConfigProvider config, String gt) throws OAuth20Exception {
        String methodName = "getCustomGTHandlerInstance";
        return new OAuth20GrantTypeHandlerAppTokenAndPasswordImpl(gt, (OAuth20Provider)config);
    }
}

