/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.product.utility;

import com.ibm.ws.product.utility.CommandTask;
import com.ibm.ws.product.utility.CommandUtils;
import java.util.HashMap;
import java.util.Map;

public class CommandTaskRegistry {
    private final Map<String, Class<? extends CommandTask>> nameCommandTaskClassMap = new HashMap<String, Class<? extends CommandTask>>();
    private final Map<String, CommandTask> nameCommandTaskInstanceMap = new HashMap<String, CommandTask>();

    public void registerCommandTask(String taskName, CommandTask commandTask) {
        if (this.nameCommandTaskClassMap.containsKey(taskName = taskName.toLowerCase())) {
            return;
        }
        this.nameCommandTaskClassMap.put(taskName, commandTask.getClass());
        this.nameCommandTaskInstanceMap.put(taskName, commandTask);
    }

    public void registerCommandTask(String taskName, Class<? extends CommandTask> taskClass) {
        if (this.nameCommandTaskClassMap.containsKey(taskName = taskName.toLowerCase())) {
            return;
        }
        this.nameCommandTaskClassMap.put(taskName, taskClass);
    }

    public void unRegisterCommandTask(String taskName) {
        taskName = taskName.toLowerCase();
        this.nameCommandTaskClassMap.remove(taskName);
        this.nameCommandTaskInstanceMap.remove(taskName);
    }

    public CommandTask getCommandTask(String taskName) {
        CommandTask commandTask = this.nameCommandTaskInstanceMap.get(taskName = taskName.toLowerCase());
        if (commandTask != null) {
            return commandTask;
        }
        try {
            Class<? extends CommandTask> commandTaskClass = this.nameCommandTaskClassMap.get(taskName);
            if (commandTaskClass == null) {
                return null;
            }
            commandTask = commandTaskClass.newInstance();
            this.nameCommandTaskInstanceMap.put(taskName, commandTask);
            return commandTask;
        }
        catch (InstantiationException e) {
            System.err.print(CommandUtils.getMessage("ERROR_UNABLE_INITIALIZE_TASK_INSTANCE", taskName, e.getMessage()));
            return null;
        }
        catch (IllegalAccessException e) {
            System.err.print(CommandUtils.getMessage("ERROR_UNABLE_INITIALIZE_TASK_INSTANCE", taskName, e.getMessage()));
            return null;
        }
    }

    public CommandTask[] getCommandTasks() {
        if (this.nameCommandTaskInstanceMap.size() == this.nameCommandTaskClassMap.size()) {
            return this.nameCommandTaskInstanceMap.values().toArray(new CommandTask[this.nameCommandTaskInstanceMap.size()]);
        }
        for (Map.Entry<String, Class<? extends CommandTask>> entry : this.nameCommandTaskClassMap.entrySet()) {
            String taskName = entry.getKey();
            if (this.nameCommandTaskInstanceMap.containsKey(taskName)) continue;
            Class<? extends CommandTask> commandTaskClass = entry.getValue();
            try {
                this.nameCommandTaskInstanceMap.put(taskName, commandTaskClass.newInstance());
            }
            catch (InstantiationException e) {
                System.err.print(CommandUtils.getMessage("ERROR_UNABLE_INITIALIZE_TASK_INSTANCE", taskName, e.getMessage()));
            }
            catch (IllegalAccessException e) {
                System.err.print(CommandUtils.getMessage("ERROR_UNABLE_INITIALIZE_TASK_INSTANCE", taskName, e.getMessage()));
            }
        }
        return this.nameCommandTaskInstanceMap.values().toArray(new CommandTask[this.nameCommandTaskInstanceMap.size()]);
    }

    public void clear() {
        this.nameCommandTaskClassMap.clear();
        this.nameCommandTaskInstanceMap.clear();
    }
}

