/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.audit.logutils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TrConfigurator;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.security.thread.ThreadIdentityManager;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.audit.logutils.CountingOutputStream;
import com.ibm.ws.security.audit.logutils.FileLogSet;
import com.ibm.ws.security.audit.logutils.FileLogUtils;
import com.ibm.wsspi.logging.TextFileOutputStreamFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.AccessController;
import java.security.PrivilegedAction;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class FileLog {
    private static final TraceComponent tc = Tr.register(FileLog.class, (String)"audit", (String)"com.ibm.ws.security.audit.file.internal.resources.AuditMessages");
    protected FileOutputStream currentFileStream;
    protected CountingOutputStream currentCountingStream;
    private PrintStream currentPrintStream;
    protected StreamStatus currentStatus;
    protected static final String nl = AccessController.doPrivileged(new PrivilegedAction<String>(){
        static final long serialVersionUID = 3328601130020857979L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        public String run() {
            return System.getProperty("line.separator");
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.audit.logutils.FileLog$1", 1.class, (String)"audit", (String)"com.ibm.ws.security.audit.file.internal.resources.AuditMessages");
        }
    });
    int nlen = nl.length();
    protected static final boolean isWindows = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
        static final long serialVersionUID = 4569031709880707961L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        public Boolean run() {
            return System.getProperty("os.name").toLowerCase().contains("windows");
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.audit.logutils.FileLog$2", 2.class, (String)"audit", (String)"com.ibm.ws.security.audit.file.internal.resources.AuditMessages");
        }
    });
    protected final FileLogSet fileLogSet = new FileLogSet(true);
    protected long maxFileSizeBytes;
    static final long serialVersionUID = -2005959749603828706L;

    public static FileLog createFileLogHolder(FileLog oldLog, File logDirectory, String newFileName, int maxFiles, long maxSizeBytes) {
        FileLog logHolder;
        String fileExtension;
        String fileName;
        int dio;
        int lio = newFileName.lastIndexOf("/");
        if (lio > 0) {
            newFileName = newFileName.substring(lio + 1);
        }
        if (File.separatorChar != '/' && (lio = newFileName.lastIndexOf(File.separatorChar)) > 0) {
            newFileName = newFileName.substring(lio + 1);
        }
        if ((dio = newFileName.lastIndexOf(".")) > 0) {
            fileName = newFileName.substring(0, dio);
            fileExtension = newFileName.substring(dio);
        } else {
            fileName = newFileName;
            fileExtension = "";
        }
        if (oldLog != null) {
            logHolder = oldLog;
            logHolder.update(logDirectory, fileName, fileExtension, maxFiles, maxSizeBytes);
        } else {
            logHolder = new FileLog(logDirectory, fileName, fileExtension, maxFiles, maxSizeBytes);
        }
        return logHolder;
    }

    private FileLog(File directory, String fileName, String fileExtension, int maxNumFiles, long maxFileSizeBytes) {
        this.currentPrintStream = DummyOutputStream.psInstance;
        this.update(directory, fileName, fileExtension, maxNumFiles, maxFileSizeBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void update(File newDirectory, String newFileName, String newFileExtension, int newMaxFiles, long newMaxSizeBytes) {
        boolean updateLocation;
        Object token = ThreadIdentityManager.runAsServer();
        try {
            updateLocation = this.fileLogSet.update(newDirectory, newFileName, newFileExtension, newMaxFiles);
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
        if (updateLocation) {
            this.setStreamStatus(StreamStatus.INIT, this.currentFileStream, this.currentCountingStream, this.currentPrintStream);
        }
        this.maxFileSizeBytes = newMaxSizeBytes;
    }

    public synchronized void close() {
        if (this.currentStatus != StreamStatus.CLOSED) {
            this.currentPrintStream.flush();
            if (!FileLogUtils.tryToClose(this.currentPrintStream)) {
                FileLogUtils.tryToClose(this.currentFileStream);
            }
            this.setStreamStatus(StreamStatus.CLOSED, null, null, DummyOutputStream.psInstance);
        }
    }

    public synchronized void writeRecord(String record) {
        long length = record.length() + this.nlen;
        PrintStream ps = this.getPrintStream(length, null);
        ps.println(record);
    }

    public synchronized void writeRecord(byte[] record, String header) {
        long length = record.length + this.nlen;
        PrintStream ps = this.getPrintStream(length, header);
        if (isWindows) {
            ps.write(record, 0, (int)length - 2);
        } else {
            ps.write(record, 0, (int)length - 1);
        }
        ps.println();
    }

    private synchronized PrintStream getPrintStream(long numNewChars, String header) {
        switch (this.currentStatus) {
            case INIT: {
                return this.createStream(header);
            }
            case ACTIVE: {
                long bytesWritten;
                if (this.maxFileSizeBytes <= 0L || (bytesWritten = this.currentCountingStream.count()) + numNewChars <= this.maxFileSizeBytes) break;
                return this.createStream(header);
            }
        }
        return this.currentPrintStream;
    }

    public synchronized long getCurrentCountStream() {
        if (this.currentCountingStream != null) {
            return this.currentCountingStream.count();
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized PrintStream createStream(String header) {
        block10: {
            FileOutputStream newFileStream = null;
            CountingOutputStream newCountingStream = null;
            PrintStream newPrintStream = null;
            File targetLogFile = null;
            long realMaxFileSizeBytes = this.maxFileSizeBytes;
            this.maxFileSizeBytes = 0L;
            Object token = ThreadIdentityManager.runAsServer();
            try {
                this.currentPrintStream.flush();
                if (this.currentFileStream != null) {
                    FileLogUtils.tryToClose(this.currentFileStream);
                }
                if ((targetLogFile = FileLogUtils.createNewFile(this.fileLogSet)) != null) {
                    try {
                        TextFileOutputStreamFactory fileStreamFactory = TrConfigurator.getFileOutputStreamFactory();
                        newFileStream = fileStreamFactory.createOutputStream(targetLogFile, true);
                        newCountingStream = new CountingOutputStream(newFileStream);
                        newPrintStream = new PrintStream(newCountingStream);
                    }
                    catch (IOException iOException) {
                        FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.audit.logutils.FileLog", (String)"315", (Object)this, (Object[])new Object[]{header});
                    }
                    if (newFileStream != null && newCountingStream != null && newPrintStream != null) {
                        this.setStreamStatus(StreamStatus.ACTIVE, newFileStream, newCountingStream, newPrintStream);
                    } else {
                        this.setStreamStatus(StreamStatus.CLOSED, null, null, DummyOutputStream.psInstance);
                    }
                    break block10;
                }
                this.setStreamStatus(StreamStatus.CLOSED, null, null, DummyOutputStream.psInstance);
            }
            finally {
                ThreadIdentityManager.reset((Object)token);
                this.maxFileSizeBytes = realMaxFileSizeBytes;
                if (this.currentStatus == StreamStatus.ACTIVE && header != null) {
                    this.currentPrintStream.println(header);
                }
            }
        }
        return this.currentPrintStream;
    }

    private synchronized void setStreamStatus(StreamStatus newStatus, FileOutputStream newFileStream, CountingOutputStream newCountingStream, PrintStream newPrintStream) {
        this.currentStatus = newStatus;
        this.currentFileStream = newFileStream;
        this.currentCountingStream = newCountingStream;
        this.currentPrintStream = newPrintStream;
    }

    public synchronized void releaseFile() {
        if (this.currentStatus == StreamStatus.ACTIVE) {
            this.currentPrintStream.flush();
            if (!FileLogUtils.tryToClose(this.currentPrintStream)) {
                FileLogUtils.tryToClose(this.currentFileStream);
            }
            this.setStreamStatus(StreamStatus.INIT, null, null, DummyOutputStream.psInstance);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static class DummyOutputStream
    extends OutputStream {
        static final DummyOutputStream instance;
        static final PrintStream psInstance;
        static final long serialVersionUID = -3561563358290082708L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        DummyOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.audit.logutils.FileLog$DummyOutputStream", DummyOutputStream.class, (String)"audit", (String)"com.ibm.ws.security.audit.file.internal.resources.AuditMessages");
            instance = new DummyOutputStream();
            psInstance = new PrintStream(instance);
        }
    }

    static enum StreamStatus {
        INIT,
        ACTIVE,
        CLOSED;

    }
}

