/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.reactive.streams.operators.spi.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.microprofile.reactive.streams.operators.spi.impl.StreamRunner;
import com.ibm.ws.microprofile.reactive.streams.operators.spi.impl.StreamTask;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.threadcontext.WSContextService;
import io.smallrye.reactive.streams.Engine;
import java.security.PrivilegedAction;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreamsFactory;
import org.eclipse.microprofile.reactive.streams.operators.core.ReactiveStreamsEngineResolver;
import org.eclipse.microprofile.reactive.streams.operators.core.ReactiveStreamsFactoryImpl;
import org.eclipse.microprofile.reactive.streams.operators.spi.Graph;
import org.eclipse.microprofile.reactive.streams.operators.spi.ReactiveStreamsEngine;
import org.eclipse.microprofile.reactive.streams.operators.spi.ReactiveStreamsFactoryResolver;
import org.eclipse.microprofile.reactive.streams.operators.spi.SubscriberWithCompletionStage;
import org.eclipse.microprofile.reactive.streams.operators.spi.UnsupportedStageException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(name="com.ibm.ws.microprofile.reactive.streams.operators.spi.impl.WASReactiveStreamsEngineImpl", service={ReactiveStreamsEngine.class}, property={"service.vendor=IBM"}, immediate=true, configurationPolicy=ConfigurationPolicy.IGNORE)
public class WASReactiveStreamsEngineImpl
extends Engine
implements ReactiveStreamsEngine {
    private static final TraceComponent tc = Tr.register(WASReactiveStreamsEngineImpl.class, null, null);
    private static ReactiveStreamsEngine singleton = null;
    private final AtomicServiceReference<ExecutorService> executorServiceRef = new AtomicServiceReference("executorService");
    private final AtomicServiceReference<WSContextService> contextServiceRef = new AtomicServiceReference("contextService");
    static final long serialVersionUID = -208984544303978944L;

    public void activate(ComponentContext cc) {
        this.executorServiceRef.activate(cc);
        this.contextServiceRef.activate(cc);
        ReactiveStreamsFactoryResolver.setInstance((ReactiveStreamsFactory)new ReactiveStreamsFactoryImpl());
        ReactiveStreamsEngineResolver.setInstance((ReactiveStreamsEngine)this);
        singleton = this;
    }

    public void deactivate(ComponentContext cc) {
        singleton = null;
        ReactiveStreamsEngineResolver.setInstance(null);
        ReactiveStreamsFactoryResolver.setInstance(null);
        this.executorServiceRef.deactivate(cc);
        this.contextServiceRef.deactivate(cc);
    }

    @Reference(name="executorService", service=ExecutorService.class)
    protected void setExecutorService(ServiceReference<ExecutorService> ref) {
        this.executorServiceRef.setReference(ref);
    }

    @Reference(name="contextService", service=WSContextService.class)
    protected void setContextService(ServiceReference<WSContextService> ref) {
        this.contextServiceRef.setReference(ref);
    }

    public static ReactiveStreamsEngine getEngine() {
        if (singleton == null) {
            singleton = new WASReactiveStreamsEngineImpl();
        }
        return singleton;
    }

    public ExecutorService getExecutor() {
        ExecutorService executor;
        ExecutorService executorService = executor = this.executorServiceRef != null ? (ExecutorService)this.executorServiceRef.getService() : null;
        if (executor != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The Liberty ExecutorService is being used to run asynch reactive work", (Object[])new Object[0]);
            }
            return executor;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"The ForkJoinPool.commonPool is being used to run asynch reactive work", (Object[])new Object[0]);
        }
        return ForkJoinPool.commonPool();
    }

    public <T> CompletionStage<T> buildCompletion(final Graph graph) throws UnsupportedStageException {
        PrivilegedAction action = new PrivilegedAction<CompletionStage<T>>(){
            static final long serialVersionUID = 7200097341400369243L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public CompletionStage<T> run() {
                return WASReactiveStreamsEngineImpl.super.buildCompletion(graph);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.microprofile.reactive.streams.operators.spi.impl.WASReactiveStreamsEngineImpl$1", 1.class, null, null);
            }
        };
        WSContextService contextService = this.contextServiceRef != null ? (WSContextService)this.contextServiceRef.getService() : null;
        StreamRunner runner = new StreamRunner(this.getExecutor(), contextService, action);
        StreamTask streamTask = runner.startStream();
        CompletableFuture wrapper = streamTask.getWrapperCompletableFuture();
        return wrapper;
    }

    public <T, R> Processor<T, R> buildProcessor(Graph graph) throws UnsupportedStageException {
        return super.buildProcessor(graph);
    }

    public <T> Publisher<T> buildPublisher(Graph graph) throws UnsupportedStageException {
        return super.buildPublisher(graph);
    }

    public <T, R> SubscriberWithCompletionStage<T, R> buildSubscriber(Graph graph) throws UnsupportedStageException {
        return super.buildSubscriber(graph);
    }
}

