/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oauth.core.api.error.oauth20;

import com.ibm.oauth.core.api.error.oauth20.OAuth20Exception;
import com.ibm.oauth.core.api.error.oauth20.OAuth20ExceptionUtil;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.security.oauth20.web.WebUtils;
import java.text.MessageFormat;
import java.util.Locale;

public class OAuth20PublicClientCredentialsException
extends OAuth20Exception {
    private static final TraceComponent tc = Tr.register(OAuth20PublicClientCredentialsException.class, (String)"OAUTH20", (String)"com.ibm.ws.security.oauth20.resources.ProviderMsgs");
    private static final long serialVersionUID = 1L;
    private String _clientId;

    public OAuth20PublicClientCredentialsException(String clientId) {
        super("invalid_client", "A public client attempted to access the token endpoint using the client_credentials grant type. The client_id is: " + clientId, null);
        this._clientId = clientId;
    }

    public OAuth20PublicClientCredentialsException(String msgKey, String clientId) {
        super("invalid_client", Tr.formatMessage((TraceComponent)tc, (String)msgKey, (Object[])new Object[]{clientId}), null);
        this._msgKey = msgKey;
        this._clientId = clientId;
    }

    @Override
    public String formatSelf(Locale locale, String encoding) {
        return MessageFormat.format(OAuth20ExceptionUtil.getResourceBundle(locale).getString(this._msgKey), WebUtils.encode((String)this._clientId, (Locale)locale, (String)encoding));
    }

    public String getClientId() {
        return this._clientId;
    }
}

