/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oauth.core.api.error.oauth20;

import com.ibm.oauth.core.api.error.oauth20.OAuth20Exception;
import com.ibm.oauth.core.api.error.oauth20.OAuth20ExceptionUtil;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.security.oauth20.web.WebUtils;
import java.text.MessageFormat;
import java.util.Locale;

public class OAuth20DuplicateParameterException
extends OAuth20Exception {
    private static final TraceComponent tc = Tr.register(OAuth20DuplicateParameterException.class, (String)"OAUTH20", (String)"com.ibm.ws.security.oauth20.resources.ProviderMsgs");
    private static final long serialVersionUID = 1L;
    private String _paramName;

    public OAuth20DuplicateParameterException(String paramName) {
        super("invalid_request", "The following OAuth parameter was provided more than once in the request: " + paramName, null);
        this._paramName = paramName;
    }

    public OAuth20DuplicateParameterException(String msgKey, String paramName) {
        super("invalid_request", Tr.formatMessage((TraceComponent)tc, (String)msgKey, (Object[])new Object[]{paramName}), null);
        this._msgKey = msgKey;
        this._paramName = paramName;
    }

    @Override
    public String formatSelf(Locale locale, String encoding) {
        return MessageFormat.format(OAuth20ExceptionUtil.getResourceBundle(locale).getString(this._msgKey), WebUtils.encode((String)this._paramName, (Locale)locale, (String)encoding));
    }

    public String getParamName() {
        return this._paramName;
    }
}

