/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oauth.core.api.config;

import com.ibm.oauth.core.api.config.OAuthComponentConfiguration;
import java.util.HashMap;
import java.util.Map;

public abstract class SampleComponentConfiguration
implements OAuthComponentConfiguration {
    public static final String[] MAX_AUTHORIZATION_GRANT_LIFEIMTE_SECONDS = new String[]{"604800"};
    public static final String[] CODE_LIFETIME_SECONDS = new String[]{"60"};
    public static final String[] CODE_LENGTH = new String[]{"30"};
    public static final String[] TOKEN_LIFETIME_SECONDS = new String[]{"7200"};
    public static final String[] ACCESS_TOKEN_LENGTH = new String[]{"40"};
    public static final String[] ISSUE_REFRESH_TOKEN = new String[]{"true"};
    public static final String[] REFRESH_TOKEN_LENGTH = new String[]{"50"};
    public static final String[] ACCESS_TOKENTYPEHANDLER_CLASSNAME = new String[]{"com.ibm.oauth.core.internal.oauth20.tokentype.impl.OAuth20TokenTypeHandlerBearerImpl"};
    public static final String[] MEDIATOR_CLASSNAMES = null;
    public static final String[] ALLOW_PUBLIC_CLIENTS = new String[]{"false"};
    public static final String[] GRANT_TYPES_ALLOWED = new String[]{"authorization_code", "implicit", "client_credentials", "password", "refresh_token"};
    protected Map<String, String[]> _config = new HashMap<String, String[]>();

    public SampleComponentConfiguration() {
        this._config.put("oauth20.max.authorization.grant.lifetime.seconds", MAX_AUTHORIZATION_GRANT_LIFEIMTE_SECONDS);
        this._config.put("oauth20.code.lifetime.seconds", CODE_LIFETIME_SECONDS);
        this._config.put("oauth20.code.length", CODE_LENGTH);
        this._config.put("oauth20.token.lifetime.seconds", TOKEN_LIFETIME_SECONDS);
        this._config.put("oauth20.access.token.length", ACCESS_TOKEN_LENGTH);
        this._config.put("oauth20.issue.refresh.token", ISSUE_REFRESH_TOKEN);
        this._config.put("oauth20.refresh.token.length", REFRESH_TOKEN_LENGTH);
        this._config.put("oauth20.access.tokentypehandler.classname", ACCESS_TOKENTYPEHANDLER_CLASSNAME);
        this._config.put("oauth20.mediator.classnames", MEDIATOR_CLASSNAMES);
        this._config.put("oauth20.allow.public.clients", ALLOW_PUBLIC_CLIENTS);
        this._config.put("oauth20.grant.types.allowed", GRANT_TYPES_ALLOWED);
    }

    public void putConfigPropertyValues(String property, String[] values) {
        this._config.put(property, values);
    }

    @Override
    public ClassLoader getPluginClassLoader() {
        return this.getClass().getClassLoader();
    }

    @Override
    public String getConfigPropertyValue(String name) {
        String result = null;
        String[] vals = this.getConfigPropertyValues(name);
        if (vals != null && vals.length > 0) {
            result = vals[0];
        }
        return result;
    }

    @Override
    public String[] getConfigPropertyValues(String name) {
        return this._config.get(name);
    }

    @Override
    public int getConfigPropertyIntValue(String name) {
        return Integer.parseInt(this.getConfigPropertyValue(name));
    }

    @Override
    public boolean getConfigPropertyBooleanValue(String name) {
        return Boolean.parseBoolean(this.getConfigPropertyValue(name));
    }

    @Override
    public abstract String getUniqueId();
}

