/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.signature.impl;

import java.util.Set;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.SecurityHelper;
import org.opensaml.xml.security.SigningUtil;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xml.security.x509.BasicX509CredentialNameEvaluator;
import org.opensaml.xml.security.x509.CertPathPKIXTrustEvaluator;
import org.opensaml.xml.security.x509.PKIXTrustEngine;
import org.opensaml.xml.security.x509.PKIXTrustEvaluator;
import org.opensaml.xml.security.x509.PKIXValidationInformation;
import org.opensaml.xml.security.x509.PKIXValidationInformationResolver;
import org.opensaml.xml.security.x509.X509Credential;
import org.opensaml.xml.security.x509.X509CredentialNameEvaluator;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.impl.BaseSignatureTrustEngine;
import org.opensaml.xml.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKIXSignatureTrustEngine
extends BaseSignatureTrustEngine<Pair<Set<String>, Iterable<PKIXValidationInformation>>>
implements PKIXTrustEngine<Signature> {
    private final Logger log = LoggerFactory.getLogger(PKIXSignatureTrustEngine.class);
    private PKIXValidationInformationResolver pkixResolver;
    private PKIXTrustEvaluator pkixTrustEvaluator;
    private X509CredentialNameEvaluator credNameEvaluator;

    public PKIXSignatureTrustEngine(PKIXValidationInformationResolver resolver, KeyInfoCredentialResolver keyInfoResolver) {
        super(keyInfoResolver);
        if (resolver == null) {
            throw new IllegalArgumentException("PKIX trust information resolver may not be null");
        }
        this.pkixResolver = resolver;
        this.pkixTrustEvaluator = new CertPathPKIXTrustEvaluator();
        this.credNameEvaluator = new BasicX509CredentialNameEvaluator();
    }

    public PKIXSignatureTrustEngine(PKIXValidationInformationResolver resolver, KeyInfoCredentialResolver keyInfoResolver, PKIXTrustEvaluator pkixEvaluator, X509CredentialNameEvaluator nameEvaluator) {
        super(keyInfoResolver);
        if (resolver == null) {
            throw new IllegalArgumentException("PKIX trust information resolver may not be null");
        }
        this.pkixResolver = resolver;
        if (pkixEvaluator == null) {
            throw new IllegalArgumentException("PKIX trust evaluator may not be null");
        }
        this.pkixTrustEvaluator = pkixEvaluator;
        this.credNameEvaluator = nameEvaluator;
    }

    public PKIXTrustEvaluator getPKIXTrustEvaluator() {
        return this.pkixTrustEvaluator;
    }

    public X509CredentialNameEvaluator getX509CredentialNameEvaluator() {
        return this.credNameEvaluator;
    }

    @Override
    public PKIXValidationInformationResolver getPKIXResolver() {
        return this.pkixResolver;
    }

    @Override
    public boolean validate(Signature signature, CriteriaSet trustBasisCriteria) throws SecurityException {
        this.checkParams(signature, trustBasisCriteria);
        Pair<Set<String>, Iterable<PKIXValidationInformation>> validationPair = this.resolveValidationInfo(trustBasisCriteria);
        if (this.validate(signature, validationPair)) {
            return true;
        }
        this.log.debug("PKIX validation of signature failed, unable to resolve valid and trusted signing key");
        return false;
    }

    @Override
    public boolean validate(byte[] signature, byte[] content, String algorithmURI, CriteriaSet trustBasisCriteria, Credential candidateCredential) throws SecurityException {
        if (candidateCredential == null || SecurityHelper.extractVerificationKey(candidateCredential) == null) {
            this.log.debug("Candidate credential was either not supplied or did not contain verification key");
            this.log.debug("PKIX trust engine requires supplied key, skipping PKIX trust evaluation");
            return false;
        }
        this.checkParamsRaw(signature, content, algorithmURI, trustBasisCriteria);
        Pair<Set<String>, Iterable<PKIXValidationInformation>> validationPair = this.resolveValidationInfo(trustBasisCriteria);
        try {
            if (SigningUtil.verifyWithURI(candidateCredential, algorithmURI, signature, content)) {
                this.log.debug("Successfully verified raw signature using supplied candidate credential");
                this.log.debug("Attempting to establish trust of supplied candidate credential");
                if (this.evaluateTrust(candidateCredential, validationPair)) {
                    this.log.debug("Successfully established trust of supplied candidate credential");
                    return true;
                }
                this.log.debug("Failed to establish trust of supplied candidate credential");
            } else {
                this.log.debug("Cryptographic verification of raw signature failed with candidate credential");
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.log.debug("PKIX validation of raw signature failed, unable to establish trust of supplied verification credential");
        return false;
    }

    @Override
    protected boolean evaluateTrust(Credential untrustedCredential, Pair<Set<String>, Iterable<PKIXValidationInformation>> validationPair) throws SecurityException {
        if (!(untrustedCredential instanceof X509Credential)) {
            this.log.debug("Can not evaluate trust of non-X509Credential");
            return false;
        }
        X509Credential untrustedX509Credential = (X509Credential)untrustedCredential;
        Set<String> trustedNames = validationPair.getFirst();
        Iterable<PKIXValidationInformation> validationInfoSet = validationPair.getSecond();
        if (!this.checkNames(trustedNames, untrustedX509Credential)) {
            this.log.debug("Evaluation of credential against trusted names failed. Aborting PKIX validation");
            return false;
        }
        for (PKIXValidationInformation validationInfo : validationInfoSet) {
            try {
                if (!this.pkixTrustEvaluator.validate(validationInfo, untrustedX509Credential)) continue;
                this.log.debug("Signature trust established via PKIX validation of signing credential");
                return true;
            }
            catch (SecurityException e) {
                this.log.debug("Error performing PKIX validation on untrusted credential", (Throwable)e);
            }
        }
        this.log.debug("Signature trust could not be established via PKIX validation of signing credential");
        return false;
    }

    protected Pair<Set<String>, Iterable<PKIXValidationInformation>> resolveValidationInfo(CriteriaSet trustBasisCriteria) throws SecurityException {
        Set<String> trustedNames = null;
        if (this.pkixResolver.supportsTrustedNameResolution()) {
            trustedNames = this.pkixResolver.resolveTrustedNames(trustBasisCriteria);
        } else {
            this.log.debug("PKIX resolver does not support resolution of trusted names, skipping name checking");
        }
        Iterable validationInfoSet = this.pkixResolver.resolve(trustBasisCriteria);
        Pair<Set<String>, Iterable<PKIXValidationInformation>> validationPair = new Pair<Set<String>, Iterable<PKIXValidationInformation>>(trustedNames, validationInfoSet);
        return validationPair;
    }

    protected boolean checkNames(Set<String> trustedNames, X509Credential untrustedCredential) throws SecurityException {
        if (this.credNameEvaluator == null) {
            this.log.debug("No credential name evaluator was available, skipping trusted name evaluation");
            return true;
        }
        return this.credNameEvaluator.evaluate(untrustedCredential, trustedNames);
    }
}

