/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.security.x509;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.SecurityHelper;
import org.opensaml.xml.security.x509.InternalX500DNHandler;
import org.opensaml.xml.security.x509.X500DNHandler;
import org.opensaml.xml.security.x509.X509Credential;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.IPAddressHelper;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class X509Util {
    private static TraceComponent tc = Tr.register(X509Util.class, (String)"SAML20", (String)"com.ibm.ws.security.saml.sso20.internal.resources.SamlSso20Messages");
    public static final String CN_OID = "2.5.4.3";
    static final String OID_SUBJECTKEYIDENTIFIER = "2.5.29.14";
    public static final Integer OTHER_ALT_NAME = 0;
    public static final Integer RFC822_ALT_NAME = 1;
    public static final Integer DNS_ALT_NAME = 2;
    public static final Integer X400ADDRESS_ALT_NAME = 3;
    public static final Integer DIRECTORY_ALT_NAME = 4;
    public static final Integer EDI_PARTY_ALT_NAME = 5;
    public static final Integer URI_ALT_NAME = 6;
    public static final Integer IP_ADDRESS_ALT_NAME = 7;
    public static final Integer REGISTERED_ID_ALT_NAME = 8;
    static final long serialVersionUID = 3753372079444564139L;

    protected X509Util() {
    }

    public static X509Certificate determineEntityCertificate(Collection<X509Certificate> certs, PrivateKey privateKey) throws SecurityException {
        if (certs == null || privateKey == null) {
            return null;
        }
        for (X509Certificate certificate : certs) {
            if (!SecurityHelper.matchKeyPair(certificate.getPublicKey(), privateKey)) continue;
            return certificate;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static List<String> getCommonNames(X500Principal dn) {
        if (dn == null) {
            return null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Extracting CNs from the following DN: {}", (Object[])new Object[]{dn.toString()});
        }
        List<String> commonNames = null;
        try {
            Tr.error((TraceComponent)tc, (String)"SAML20_SERVER_INTERNAL_ERROR", (Object[])new Object[]{"org.opensaml.xml.security.x509.X509Util->getCommonNames is not implemented yet"});
            throw new Exception("TracingOnly");
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"org.opensaml.xml.security.x509.X509Util", (String)"144", null, (Object[])new Object[]{dn});
            if (tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)("Unable to extract common names from DN: ASN.1 parsing failed: " + e), (Object[])new Object[0]);
            }
            return commonNames;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static List getAltNames(X509Certificate certificate, Integer[] nameTypes) {
        if (certificate == null) {
            return null;
        }
        LinkedList<Object> names = new LinkedList<Object>();
        Collection<List<?>> altNames = null;
        try {
            altNames = certificate.getSubjectAlternativeNames();
        }
        catch (CertificateParsingException certificateParsingException) {
            FFDCFilter.processException((Throwable)certificateParsingException, (String)"org.opensaml.xml.security.x509.X509Util", (String)"170", null, (Object[])new Object[]{certificate, nameTypes});
            if (tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)("Encountered an problem trying to extract Subject Alternate Name from supplied certificate: " + e), (Object[])new Object[0]);
            }
            return names;
        }
        if (altNames != null) {
            block2: for (List<?> altName : altNames) {
                for (Integer nameType : nameTypes) {
                    if (!altName.get(0).equals(nameType)) continue;
                    names.add(X509Util.convertAltNameType(nameType, altName.get(1)));
                    continue block2;
                }
            }
        }
        return names;
    }

    public static List getSubjectNames(X509Certificate certificate, Integer[] altNameTypes) {
        LinkedList<String> issuerNames = new LinkedList<String>();
        List<String> entityCertCNs = X509Util.getCommonNames(certificate.getSubjectX500Principal());
        issuerNames.add(entityCertCNs.get(0));
        issuerNames.addAll(X509Util.getAltNames(certificate, altNameTypes));
        return issuerNames;
    }

    public static byte[] getSubjectKeyIdentifier(X509Certificate cert) {
        byte[] ki = null;
        byte[] der = cert.getExtensionValue(OID_SUBJECTKEYIDENTIFIER);
        if (der != null) {
            ki = new byte[der.length - 4];
            System.arraycopy(der, 4, ki, 0, der.length - 4);
        }
        return ki;
    }

    /*
     * WARNING - void declaration
     */
    public static Collection<X509Certificate> decodeCertificate(File certs) throws CertificateException {
        if (!certs.exists()) {
            throw new CertificateException("Certificate file " + certs.getAbsolutePath() + " does not exist");
        }
        if (!certs.canRead()) {
            throw new CertificateException("Certificate file " + certs.getAbsolutePath() + " is not readable");
        }
        try {
            return X509Util.decodeCertificate(DatatypeHelper.fileToByteArray(certs));
        }
        catch (IOException iOException) {
            void e;
            FFDCFilter.processException((Throwable)iOException, (String)"org.opensaml.xml.security.x509.X509Util", (String)"256", null, (Object[])new Object[]{certs});
            throw new CertificateException("Error reading certificate file " + certs.getAbsolutePath(), (Throwable)e);
        }
    }

    public static Collection<X509Certificate> decodeCertificate(byte[] certs) throws CertificateException {
        if (certs == null || certs.length == 0) {
            return null;
        }
        CertificateFactory cf = CertificateFactory.getInstance("X509");
        ByteArrayInputStream inStream = new ByteArrayInputStream(certs);
        Collection<? extends Certificate> x509Certs = cf.generateCertificates(inStream);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getX509Certificate", (Object[])new Object[]{x509Certs});
        }
        return x509Certs;
    }

    /*
     * WARNING - void declaration
     */
    public static Collection<X509CRL> decodeCRLs(File crls) throws CRLException {
        if (!crls.exists()) {
            throw new CRLException("CRL file " + crls.getAbsolutePath() + " does not exist");
        }
        if (!crls.canRead()) {
            throw new CRLException("CRL file " + crls.getAbsolutePath() + " is not readable");
        }
        try {
            return X509Util.decodeCRLs(DatatypeHelper.fileToByteArray(crls));
        }
        catch (IOException iOException) {
            void e;
            FFDCFilter.processException((Throwable)iOException, (String)"org.opensaml.xml.security.x509.X509Util", (String)"307", null, (Object[])new Object[]{crls});
            throw new CRLException("Error reading CRL file " + crls.getAbsolutePath(), (Throwable)e);
        }
    }

    public static Collection<X509CRL> decodeCRLs(byte[] crls) throws CRLException {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            return cf.generateCRLs(new ByteArrayInputStream(crls));
        }
        catch (GeneralSecurityException cf) {
            FFDCFilter.processException((Throwable)cf, (String)"org.opensaml.xml.security.x509.X509Util", (String)"327", null, (Object[])new Object[]{crls});
            throw new CRLException("Unable to decode X.509 certificates");
        }
    }

    public static String getIdentifiersToken(X509Credential credential, X500DNHandler handler) {
        X500DNHandler x500DNHandler = handler != null ? handler : new InternalX500DNHandler();
        X500Principal x500Principal = credential.getEntityCertificate().getSubjectX500Principal();
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        builder.append(String.format("subjectName='%s'", x500DNHandler.getName(x500Principal)));
        if (!DatatypeHelper.isEmpty(credential.getEntityId())) {
            builder.append(String.format(" |credential entityID='%s'", DatatypeHelper.safeTrimOrNullString(credential.getEntityId())));
        }
        builder.append(']');
        return builder.toString();
    }

    private static Object convertAltNameType(Integer nameType, Object nameValue) {
        if (DIRECTORY_ALT_NAME.equals(nameType) || DNS_ALT_NAME.equals(nameType) || RFC822_ALT_NAME.equals(nameType) || URI_ALT_NAME.equals(nameType) || REGISTERED_ID_ALT_NAME.equals(nameType)) {
            return nameValue;
        }
        if (IP_ADDRESS_ALT_NAME.equals(nameType)) {
            return IPAddressHelper.addressToString((byte[])nameValue);
        }
        if (EDI_PARTY_ALT_NAME.equals(nameType) || X400ADDRESS_ALT_NAME.equals(nameType) || OTHER_ALT_NAME.equals(nameType)) {
            Tr.error((TraceComponent)tc, (String)"SAML20_SERVER_INTERNAL_ERROR", (Object[])new Object[]{"org.opensaml.xml.security.x509.X509Util->convertAltNameType(392) is not implemented yet"});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Encountered unknown alt name type '{}', adding as-is", (Object[])new Object[]{nameType});
        }
        return nameValue;
    }

    public static enum ENCODING_FORMAT {
        PEM,
        DER;

    }
}

