/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.acme4j;

import java.net.URL;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import org.shredzone.acme4j.AcmeResource;
import org.shredzone.acme4j.Login;
import org.shredzone.acme4j.connector.Connection;
import org.shredzone.acme4j.exception.AcmeException;
import org.shredzone.acme4j.exception.AcmeLazyLoadingException;
import org.shredzone.acme4j.exception.AcmeRetryAfterException;
import org.shredzone.acme4j.toolbox.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public abstract class AcmeJsonResource
extends AcmeResource {
    private static final long serialVersionUID = -5060364275766082345L;
    private static final Logger LOG = LoggerFactory.getLogger(AcmeJsonResource.class);
    private JSON data = null;

    protected AcmeJsonResource(Login login, URL location) {
        super(login, location);
    }

    public JSON getJSON() {
        if (this.data == null) {
            try {
                this.update();
            }
            catch (AcmeRetryAfterException ex) {
                LOG.debug("Retry-After", (Throwable)ex);
            }
            catch (AcmeException ex) {
                throw new AcmeLazyLoadingException(this, ex);
            }
        }
        return this.data;
    }

    protected void setJSON(JSON data) {
        this.data = Objects.requireNonNull(data, "data");
    }

    protected boolean isValid() {
        return this.data != null;
    }

    protected void invalidate() {
        this.data = null;
    }

    public void update() throws AcmeException {
        String resourceType = this.getClass().getSimpleName();
        LOG.debug("update {}", (Object)resourceType);
        try (Connection conn = this.getSession().connect();){
            conn.sendSignedPostAsGetRequest(this.getLocation(), this.getLogin());
            JSON json = conn.readJsonResponse();
            if (json != null) {
                this.setJSON(json);
            }
            conn.handleRetryAfter(resourceType + " is not completed yet");
        }
    }
}

