/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.acme.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.state.ApplicationStateListener;
import com.ibm.ws.container.service.state.StateChangeException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.feature.ServerStartedPhase2;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.acme.AcmeCaException;
import com.ibm.ws.security.acme.internal.AcmeConfig;
import java.util.Calendar;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(immediate=true, configurationPolicy=ConfigurationPolicy.IGNORE, service={AcmeApplicationStateListener.class, ApplicationStateListener.class}, property={"service.vendor=IBM", "includeAppsWithoutConfig=true"})
public class AcmeApplicationStateListener
implements ApplicationStateListener {
    private static final TraceComponent tc = Tr.register(AcmeApplicationStateListener.class, (String)"ACMECA", (String)"com.ibm.ws.security.acme.resources.AcmeMessages");
    private boolean isAppStarted = false;
    private boolean isHttpStarted;
    private final Lock appLock = new ReentrantLock();
    private final Lock httpLock = new ReentrantLock();
    private final Condition appStartedCondition = this.appLock.newCondition();
    private final Condition httpStartedCondition = this.httpLock.newCondition();
    static final long serialVersionUID = -46878684089013053L;

    @Trivial
    public void applicationStarting(ApplicationInfo appInfo) {
    }

    @Trivial
    public void applicationStarted(ApplicationInfo appInfo) throws StateChangeException {
        String methodName = "applicationStarted(ApplicationInfo)";
        if ("com.ibm.ws.security.acme".equals(appInfo.getName())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.event((TraceComponent)tc, (String)"applicationStarted(ApplicationInfo): ACME authorization web application has started and is available for requests.", (Object[])new Object[0]);
            }
            this.appLock.lock();
            try {
                this.isAppStarted = true;
                this.appStartedCondition.signalAll();
            }
            finally {
                this.appLock.unlock();
            }
        }
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL)
    protected synchronized void setServerStartedPhase2(ServerStartedPhase2 serverStartedPhase2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.event((TraceComponent)tc, (String)": HTTP is open.", (Object[])new Object[0]);
        }
        this.httpLock.lock();
        try {
            this.isHttpStarted = true;
            this.httpStartedCondition.signalAll();
        }
        finally {
            this.httpLock.unlock();
        }
    }

    @Trivial
    protected void unsetServerStartedPhase2(ServerStartedPhase2 serverStartedPhase2) {
        this.isHttpStarted = false;
    }

    @Trivial
    public void applicationStopping(ApplicationInfo appInfo) {
    }

    @Trivial
    public void applicationStopped(ApplicationInfo appInfo) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilResourcesAvailable(AcmeConfig acmeConfig) throws AcmeCaException {
        boolean keepWaiting;
        boolean signaled;
        String methodName = "waitUntilWebAppAvailable()";
        Calendar cal = Calendar.getInstance();
        try {
            this.appLock.lock();
            cal.setTimeInMillis(System.currentTimeMillis() + acmeConfig.getStartReadyTimeout());
            if (!this.isAppStarted) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && !this.isAppStarted) {
                    Tr.debug((TraceComponent)tc, (String)"waitUntilWebAppAvailable(): ACME authorization web application has not started - waiting.", (Object[])new Object[0]);
                }
                signaled = false;
                keepWaiting = true;
                while (keepWaiting) {
                    try {
                        keepWaiting = false;
                        signaled = this.appStartedCondition.awaitUntil(cal.getTime());
                    }
                    catch (InterruptedException interruptedException) {
                        FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.security.acme.internal.AcmeApplicationStateListener", (String)"187", (Object)this, (Object[])new Object[]{acmeConfig});
                        keepWaiting = true;
                    }
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"waitUntilWebAppAvailable(): Finished waiting on ACME authorization web application.", (Object[])new Object[0]);
                }
                if (!signaled || !this.isAppStarted) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("waitUntilWebAppAvailable(): Not signalled that acme application is ready, letting ACME flow happen anyway : signaled: " + signaled + " isHttpStarted: " + this.isAppStarted), (Object[])new Object[0]);
                    }
                    Tr.warning((TraceComponent)tc, (String)"CWPKI2036W", (Object[])new Object[]{acmeConfig.getStartReadyTimeout() + "ms"});
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"waitUntilWebAppAvailable(): ACME authorization web application already started - not waiting.", (Object[])new Object[0]);
            }
        }
        finally {
            this.appLock.unlock();
        }
        try {
            this.httpLock.lock();
            if (!this.isHttpStarted) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("waitUntilWebAppAvailable(): HTTP has not started - waiting. Time left: " + (cal.getTimeInMillis() - System.currentTimeMillis()) + "ms"), (Object[])new Object[0]);
                }
                signaled = false;
                keepWaiting = true;
                while (keepWaiting) {
                    try {
                        keepWaiting = false;
                        signaled = this.httpStartedCondition.awaitUntil(cal.getTime());
                    }
                    catch (InterruptedException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.acme.internal.AcmeApplicationStateListener", (String)"234", (Object)this, (Object[])new Object[]{acmeConfig});
                        keepWaiting = true;
                    }
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"waitUntilWebAppAvailable(): Finished waiting on HTTP.", (Object[])new Object[0]);
                }
                if (!signaled || !this.isHttpStarted) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("waitUntilWebAppAvailable(): Not signalled that HTTP is ready, letting ACME flow happen anyway : signaled: " + signaled + " isHttpStarted: " + this.isHttpStarted), (Object[])new Object[0]);
                    }
                    Tr.warning((TraceComponent)tc, (String)"CWPKI2074W", (Object[])new Object[]{acmeConfig.getStartReadyTimeout() + "ms"});
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"waitUntilWebAppAvailable(): HTTP is already opened - not waiting.", (Object[])new Object[0]);
            }
        }
        finally {
            this.httpLock.unlock();
        }
    }
}

