/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jms.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.api.jms.impl.JmsErrorUtils;
import com.ibm.ws.sib.api.jms.impl.MsgDestEncodingUtilsImpl;
import com.ibm.ws.sib.api.jms.impl.PropertyCoder;
import com.ibm.ws.sib.jms.util.ArrayUtil;
import com.ibm.ws.sib.jms.util.Utf8Codec;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.ByteArrayOutputStream;
import javax.jms.JMSException;

class ShortStringPropertyCoder
extends PropertyCoder {
    private static TraceComponent tc = SibTr.register(ShortStringPropertyCoder.class, (String)"SIBJms_Internal", (String)"com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");

    ShortStringPropertyCoder(String longName, String shortName) {
        super(longName, shortName);
    }

    @Override
    void encodeProperty(ByteArrayOutputStream baos, Object value) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"encodeProperty", (Object)new Object[]{baos, value});
        }
        if (!(value instanceof String)) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INTERNAL_ERROR_CWSIA0362", new Object[]{"ShortStringPropertyCoder.encodeProperty#1", this.longName, value}, null, "ShortStringPropertyCoder.encodeProperty#1", null, tc);
        }
        baos.write(this.encodedName, 0, this.encodedName.length);
        String strVal = (String)value;
        int len = Utf8Codec.getEncodedLength((String)strVal);
        byte[] buffer = new byte[len + 2];
        ArrayUtil.writeShort((byte[])buffer, (int)0, (short)((short)len));
        Utf8Codec.encode((byte[])buffer, (int)2, (String)strVal);
        baos.write(buffer, 0, buffer.length);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"encodeProperty");
        }
    }

    @Override
    Object decodeProperty(MsgDestEncodingUtilsImpl.PropertyInputStream stream) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"decodeProperty", (Object)stream);
        }
        String value = stream.readStringValue();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"decodeProperty", (Object)value);
        }
        return value;
    }
}

