/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jms.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.api.jms.ApiJmsConstants;
import com.ibm.websphere.sib.api.jms.JmsMsgProducer;
import com.ibm.websphere.sib.api.jms.JmsQueue;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.ws.sib.api.jms.EncodingLevel;
import com.ibm.ws.sib.api.jms.JmsInternalConstants;
import com.ibm.ws.sib.api.jms.impl.JmsDestinationImpl;
import com.ibm.ws.sib.api.jms.impl.JmsErrorUtils;
import com.ibm.ws.sib.api.jms.impl.JmsMessageImpl;
import com.ibm.ws.sib.api.jms.impl.JmsSessionImpl;
import com.ibm.ws.sib.api.jms.impl.MessageProxyInvocationHandler;
import com.ibm.ws.sib.api.jms.impl.ProducerProperties;
import com.ibm.ws.sib.mfp.JsDestinationAddress;
import com.ibm.ws.sib.mfp.JsJmsMessage;
import com.ibm.ws.sib.mfp.MfpConstants;
import com.ibm.ws.sib.mfp.PersistenceType;
import com.ibm.ws.sib.utils.HexString;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.DestinationType;
import com.ibm.wsspi.sib.core.OrderingContext;
import com.ibm.wsspi.sib.core.ProducerSession;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;
import com.ibm.wsspi.sib.core.exception.SITemporaryDestinationNotFoundException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.jms.CompletionListener;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import javax.jms.Queue;
import javax.jms.Topic;

public class JmsMsgProducerImpl
implements JmsMsgProducer,
ApiJmsConstants,
JmsInternalConstants {
    private static TraceComponent tc = SibTr.register(JmsMsgProducerImpl.class, (String)"SIBJms_External", (String)"com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
    private SICoreConnection coreConnection;
    private ProducerSession prod;
    private int defaultDeliveryMode = 2;
    private int defaultPriority = 4;
    private long defaultTimeToLive = 0L;
    private long defaultDeliveryDelay = 0L;
    private JmsDestinationImpl dest = null;
    private JmsSessionImpl session = null;
    private boolean closed = false;
    private final Object closedLock = new Object();
    private boolean disableTimestamp = false;
    private boolean disableMessageID = false;
    private Object sessionSyncLock;
    private ProducerProperties producerProperties = null;
    private Reliability nonPersistentReliability;
    private Reliability persistentReliability;
    private boolean propsOverriden = false;
    private String resolvedUserID;
    private OrderingContext orderingContext;
    private String busName;
    private final AtomicLong _inProgressAysncSends = new AtomicLong(0L);
    private static final int PRODUCER_SEND_WITH_ONLY_MESSAGE = 1;
    private static final int PRODUCER_SEND_MESSAGE_WITH_PARAMETERS = 3;
    private static final int CONNECTION_SEND_MESSAGE_WITH_PARAMETERS = 4;

    private JmsMsgProducerImpl() {
    }

    JmsMsgProducerImpl(Destination theDest, SICoreConnection coreConnection, JmsSessionImpl newSession) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"JmsMsgProducerImpl", (Object)new Object[]{theDest, coreConnection, newSession});
        }
        if (theDest != null) {
            this.dest = JmsDestinationImpl.checkNativeInstance(theDest);
            JmsDestinationImpl.checkBlockedStatus(this.dest);
        }
        this.coreConnection = coreConnection;
        this.prod = null;
        this.session = newSession;
        this.sessionSyncLock = this.session.getSessionSyncLock();
        try {
            this.resolvedUserID = coreConnection.getResolvedUserid();
        }
        catch (SIException sice) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0067", new Object[]{sice, "JmsMsgProducerImpl.<constructor>"}, sice, null, this, tc);
        }
        this.orderingContext = this.session.getOrderingContext();
        Map passThruProps = this.session.getPassThruProps();
        this.busName = (String)passThruProps.get("busName");
        String connPropVal = (String)passThruProps.get("nonPersistentMapping");
        if (connPropVal != null) {
            this.nonPersistentReliability = ProducerProperties.lookupReliability(connPropVal);
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"WARNING: no non-persistent mapping in passThruProps");
            }
            this.nonPersistentReliability = Reliability.EXPRESS_NONPERSISTENT;
        }
        connPropVal = (String)passThruProps.get("persistentMapping");
        if (connPropVal != null) {
            this.persistentReliability = ProducerProperties.lookupReliability(connPropVal);
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"WARNING: no persistent mapping in passThruProps");
            }
            this.persistentReliability = Reliability.RELIABLE_PERSISTENT;
        }
        if (this.dest != null) {
            this.producerProperties = new ProducerProperties(this.dest, this, passThruProps, this.persistentReliability, this.nonPersistentReliability);
            try {
                DestinationType dt = null;
                boolean producerBind = false;
                boolean preferLocalQP = true;
                if (this.dest.isProducerTypeCheck()) {
                    if (theDest instanceof Queue) {
                        String preferLocalQPStr;
                        dt = DestinationType.QUEUE;
                        String producerBindStr = ((JmsQueue)((Object)this.dest)).getProducerBind();
                        if (producerBindStr != null && "On".equals(producerBindStr)) {
                            producerBind = true;
                        }
                        if ((preferLocalQPStr = ((JmsQueue)((Object)this.dest)).getProducerPreferLocal()) != null && "Off".equals(preferLocalQPStr)) {
                            preferLocalQP = false;
                        }
                    } else {
                        dt = DestinationType.TOPICSPACE;
                    }
                }
                SIDestinationAddress sida = this.dest.getProducerSIDestinationAddress();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Creating producer session - destAddr: " + sida + " type: " + dt + " bind: " + producerBind + " preferLocl: " + preferLocalQP));
                }
                String destDiscrim = this.dest.getDestDiscrim();
                this.prod = coreConnection.createProducerSession(sida, destDiscrim, dt, this.orderingContext, null, producerBind, preferLocalQP);
            }
            catch (SINotAuthorizedException sinae) {
                throw (JMSSecurityException)JmsErrorUtils.newThrowable(JMSSecurityException.class, "PRODUCER_AUTH_ERROR_CWSIA0069", null, sinae, null, this, tc);
            }
            catch (SINotPossibleInCurrentConfigurationException dwte) {
                String msgKey = "MP_CREATE_FAILED_CWSIA0062";
                throw (InvalidDestinationException)JmsErrorUtils.newThrowable(InvalidDestinationException.class, msgKey, new Object[]{theDest}, dwte, null, this, tc);
            }
            catch (SITemporaryDestinationNotFoundException tdnf) {
                String msgKey = "MP_CREATE_FAILED_CWSIA0062";
                throw (InvalidDestinationException)JmsErrorUtils.newThrowable(InvalidDestinationException.class, msgKey, new Object[]{theDest}, tdnf, null, this, tc);
            }
            catch (SIIncorrectCallException e) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0067", new Object[]{e, "JmsMsgProducerImpl.<constructor>"}, e, "JmsMsgProducerImpl#4", this, tc);
            }
            catch (SIException sice) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0067", new Object[]{sice, "JmsMsgProducerImpl.<constructor>"}, sice, null, this, tc);
            }
            catch (Exception e) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0067", new Object[]{e, "JmsMsgProducerImpl.<constructor>"}, e, "JmsMsgProducerImpl#5", this, tc);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"JmsMsgProducerImpl");
        }
    }

    public void setDisableMessageID(boolean value) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setDisableMessageID", (Object)value);
        }
        this.checkClosed();
        this.disableMessageID = value;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setDisableMessageID");
        }
    }

    public boolean getDisableMessageID() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getDisableMessageID");
        }
        this.checkClosed();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getDisableMessageID", (Object)this.disableMessageID);
        }
        return this.disableMessageID;
    }

    public void setDisableMessageTimestamp(boolean value) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setDisableMessageTimestamp", (Object)value);
        }
        this.checkClosed();
        this.disableTimestamp = value;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setDisableMessageTimestamp");
        }
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getDisableMessageTimestamp");
        }
        this.checkClosed();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getDisableMessageTimestamp", (Object)this.disableTimestamp);
        }
        return this.disableTimestamp;
    }

    public void setDeliveryMode(int deliveryMode) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setDeliveryMode", (Object)deliveryMode);
        }
        this.checkClosed();
        this.validateDeliveryMode(deliveryMode);
        this.defaultDeliveryMode = deliveryMode;
        if (this.producerProperties != null) {
            this.producerProperties.setInDeliveryMode(deliveryMode);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setDeliveryMode");
        }
    }

    public int getDeliveryMode() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getDeliveryMode");
        }
        this.checkClosed();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getDeliveryMode", (Object)this.defaultDeliveryMode);
        }
        return this.defaultDeliveryMode;
    }

    public void setPriority(int x) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setPriority", (Object)x);
        }
        this.checkClosed();
        this.validatePriority(x);
        this.defaultPriority = x;
        if (this.producerProperties != null) {
            this.producerProperties.setInPriority(x);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setPriority");
        }
    }

    public int getPriority() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getPriority");
        }
        this.checkClosed();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getPriority", (Object)this.defaultPriority);
        }
        return this.defaultPriority;
    }

    @Override
    public void setTimeToLive(long timeToLive) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setTimeToLive", (Object)timeToLive);
        }
        this.checkClosed();
        this.validateTimeToLive(timeToLive);
        this.defaultTimeToLive = timeToLive;
        if (this.producerProperties != null) {
            this.producerProperties.setInTTL(timeToLive);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setTimeToLive");
        }
    }

    public long getTimeToLive() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getTimeToLive");
        }
        this.checkClosed();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setTimeToLive", (Object)this.defaultTimeToLive);
        }
        return this.defaultTimeToLive;
    }

    public Destination getDestination() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getDestination");
        }
        this.checkClosed();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getDestination", (Object)this.dest);
        }
        return this.dest;
    }

    public void close() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"close");
        }
        this.close(false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"close");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(boolean tidyUp) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"close", (Object)new Object[]{tidyUp});
        }
        boolean originallyClosed = false;
        if (!this.session.isManaged()) {
            this.session.validateCloseCommitRollback("close");
            this.waitForAsyncSendsResolution();
        }
        Object object = this.closedLock;
        synchronized (object) {
            originallyClosed = this.closed;
            this.closed = true;
        }
        if (!originallyClosed) {
            if (this.prod != null) {
                try {
                    if (!tidyUp) {
                        this.prod.close();
                    }
                }
                catch (SIException sice) {
                    throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0067", new Object[]{sice, "JmsMsgProducerImpl.close"}, sice, null, this, tc);
                }
            }
            this.session.removeProducer(this);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"already closed");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"close");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send_internal(Message message, CompletionListener cListner) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"send_internal", (Object)new Object[]{message, cListner});
        }
        Object object = this.sessionSyncLock;
        synchronized (object) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"got lock");
            }
            this.validateMessageForNull(message);
            if (this.dest == null) {
                throw (UnsupportedOperationException)JmsErrorUtils.newThrowable(UnsupportedOperationException.class, "NO_DEST_SPECIFIED_ON_SEND_CWSIA0065", null, tc);
            }
            if (!this.session.isManaged()) {
                message = this.getMessageFromProxy(message);
            }
            if (cListner != null) {
                if (this.session.isManaged()) {
                    throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "MGD_ENV_CWSIA0084", new Object[]{"MessageProducer.send"}, tc);
                }
                this._inProgressAysncSends.incrementAndGet();
                this.session.addtoAsysncSendQueue(this, cListner, message, 1, null);
                return;
            }
            this.waitForAsyncSendsResolution();
            this.sendUsingProducerSession(message);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"send_internal");
        }
    }

    private Message getMessageFromProxy(Message msg) {
        block5: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"getMessageFromProxy", (Object)msg);
            }
            try {
                InvocationHandler handler;
                if (msg instanceof Proxy && (handler = Proxy.getInvocationHandler(msg)) instanceof MessageProxyInvocationHandler) {
                    msg = ((MessageProxyInvocationHandler)handler).getMessage();
                }
            }
            catch (Exception e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block5;
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Exception in getMessageFromProxy .. returning msg as it is", (Object)e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getMessageFromProxy", (Object)msg);
        }
        return msg;
    }

    private void sendUsingProducerSession(Message message) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"sendUsingProducerSession", (Object)new Object[]{message});
        }
        this.checkClosed();
        this.session.checkSynchronousUsage("send");
        if (message == null) {
            throw (MessageFormatException)JmsErrorUtils.newThrowable(MessageFormatException.class, "INVALID_VALUE_CWSIA0068", new Object[]{"message", null}, tc);
        }
        if (this.propsOverriden) {
            this.producerProperties.setInDeliveryMode(this.defaultDeliveryMode);
            this.producerProperties.setInPriority(this.defaultPriority);
            this.producerProperties.setInTTL(this.defaultTimeToLive);
            this.propsOverriden = false;
        }
        this.sendMessage(this.producerProperties, message, this.dest);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"sendUsingProducerSession");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send_internal(Message message, int deliveryMode, int priority, long timeToLive, CompletionListener cListner) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"send_internal", (Object)new Object[]{message, deliveryMode, priority, timeToLive, cListner});
        }
        Object object = this.sessionSyncLock;
        synchronized (object) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"got lock");
            }
            this.validateMessageForNull(message);
            this.validatePriority(priority);
            this.validateDeliveryMode(deliveryMode);
            this.validateTimeToLive(timeToLive);
            if (this.dest == null) {
                throw (UnsupportedOperationException)JmsErrorUtils.newThrowable(UnsupportedOperationException.class, "NO_DEST_SPECIFIED_ON_SEND_CWSIA0065", null, tc);
            }
            if (!this.session.isManaged()) {
                message = this.getMessageFromProxy(message);
            }
            if (cListner != null) {
                if (this.session.isManaged()) {
                    throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "MGD_ENV_CWSIA0084", new Object[]{"MessageProducer.send"}, tc);
                }
                this._inProgressAysncSends.incrementAndGet();
                this.session.addtoAsysncSendQueue(this, cListner, message, 3, new Object[]{deliveryMode, priority, timeToLive});
                return;
            }
            this.waitForAsyncSendsResolution();
            this.sendUsingProducerSession(message, deliveryMode, priority, timeToLive);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"send_internal");
        }
    }

    private void sendUsingProducerSession(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"sendUsingProducerSession", (Object)new Object[]{message, deliveryMode, priority, timeToLive});
        }
        this.checkClosed();
        this.session.checkSynchronousUsage("send");
        if (message == null) {
            throw (MessageFormatException)JmsErrorUtils.newThrowable(MessageFormatException.class, "INVALID_VALUE_CWSIA0068", new Object[]{"message", null}, tc);
        }
        this.propsOverriden = true;
        this.producerProperties.setInDeliveryMode(deliveryMode);
        this.producerProperties.setInPriority(priority);
        this.producerProperties.setInTTL(timeToLive);
        this.sendMessage(this.producerProperties, message, this.dest);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"sendUsingProducerSession");
        }
    }

    void send_internal(Destination destination, Message message, CompletionListener cListner) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"send", (Object)new Object[]{destination, message, cListner});
        }
        this.send_internal(destination, message, this.defaultDeliveryMode, this.defaultPriority, this.defaultTimeToLive, cListner);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"send");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send_internal(Destination destination, Message message, int deliveryMode, int priority, long timeToLive, CompletionListener cListner) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"send", (Object)new Object[]{destination, message, deliveryMode, priority, timeToLive, cListner});
        }
        Object object = this.sessionSyncLock;
        synchronized (object) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"got lock");
            }
            this.validateMessageForNull(message);
            this.validatePriority(priority);
            this.validateDeliveryMode(deliveryMode);
            this.validateTimeToLive(timeToLive);
            this.validateDestination(destination);
            if (!this.session.isManaged()) {
                message = this.getMessageFromProxy(message);
            }
            if (cListner != null) {
                if (this.session.isManaged()) {
                    throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "MGD_ENV_CWSIA0084", new Object[]{"MessageProducer.send"}, tc);
                }
                this._inProgressAysncSends.incrementAndGet();
                this.session.addtoAsysncSendQueue(this, cListner, message, 4, new Object[]{deliveryMode, priority, timeToLive, destination});
                return;
            }
            this.waitForAsyncSendsResolution();
            this.sendUsingConnection(destination, message, deliveryMode, priority, timeToLive);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"send");
        }
    }

    private void sendUsingConnection(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"sendUsingConnection", (Object)new Object[]{destination, message, deliveryMode, priority, timeToLive});
        }
        this.checkClosed();
        this.session.checkSynchronousUsage("send");
        if (message == null) {
            throw (MessageFormatException)JmsErrorUtils.newThrowable(MessageFormatException.class, "INVALID_VALUE_CWSIA0068", new Object[]{"message", null}, tc);
        }
        JmsDestinationImpl nativeDest = this.validateDestination(destination);
        ProducerProperties pp = new ProducerProperties(nativeDest, this, this.session.getPassThruProps(), null, null);
        pp.setInDeliveryMode(deliveryMode);
        pp.setInPriority(priority);
        pp.setInTTL(timeToLive);
        this.sendMessage(pp, message, nativeDest);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"sendUsingConnection");
        }
    }

    private JmsDestinationImpl validateDestination(Destination destination) throws JMSException {
        if (this.dest != null) {
            if (destination == null) {
                throw (InvalidDestinationException)JmsErrorUtils.newThrowable(InvalidDestinationException.class, "INVALID_VALUE_CWSIA0281", new Object[]{"Destination", null}, tc);
            }
            throw (UnsupportedOperationException)JmsErrorUtils.newThrowable(UnsupportedOperationException.class, "DEST_SPECIFIED_ON_SEND_CWSIA0066", null, tc);
        }
        JmsDestinationImpl nativeDest = JmsDestinationImpl.checkNativeInstance(destination);
        if (this.dest == null) {
            JmsDestinationImpl.checkBlockedStatus(nativeDest);
        }
        return nativeDest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendCalledFromAsynsSendRunThread(Message message, int SendMethodType, Object[] params, CompletionListener cListener) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendCalledFromAsynsSendRunThread", (Object)new Object[]{message, SendMethodType, params, cListener});
        }
        try {
            if (SendMethodType == 1) {
                this.sendUsingProducerSession(message);
            } else if (SendMethodType == 3) {
                this.sendUsingProducerSession(message, (Integer)params[0], (Integer)params[1], (Long)params[2]);
            } else if (SendMethodType == 4) {
                this.sendUsingConnection((Destination)params[3], message, (Integer)params[0], (Integer)params[1], (Long)params[2]);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"calling onCompletion ", (Object)new Object[]{message, cListener, message});
            }
            try {
                if (message instanceof JmsMessageImpl) {
                    ((JmsMessageImpl)message).setAsyncSendInProgress(false);
                }
                cListener.onCompletion(message);
            }
            catch (Throwable e) {
                SibTr.debug((TraceComponent)tc, (String)"Caught exception in onCompletion method", (Object)new Object[]{message, cListener, message, e});
            }
        }
        catch (Exception e) {
            block33: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Caught exception in executing send method .. calling onException", (Object)new Object[]{message, cListener, message, e});
                }
                try {
                    if (message instanceof JmsMessageImpl) {
                        ((JmsMessageImpl)message).setAsyncSendInProgress(false);
                    }
                    cListener.onException(message, e);
                }
                catch (Throwable ex) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block33;
                    SibTr.debug((TraceComponent)tc, (String)"Caught exception in onException method", (Object)new Object[]{message, cListener, message, ex});
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"sendCalledFromAsynsSendRunThread");
            }
            return;
        }
        finally {
            AtomicLong atomicLong = this._inProgressAysncSends;
            synchronized (atomicLong) {
                if (this._inProgressAysncSends.get() > 0L) {
                    this._inProgressAysncSends.decrementAndGet();
                }
                if (this._inProgressAysncSends.get() <= 0L) {
                    this._inProgressAysncSends.notifyAll();
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendCalledFromAsynsSendRunThread");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkClosed() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"checkClosed");
        }
        Object object = this.closedLock;
        synchronized (object) {
            if (this.closed) {
                throw (JMSException)JmsErrorUtils.newThrowable(IllegalStateException.class, "PRODUCER_CLOSED_CWSIA0061", null, tc);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"checkClosed");
        }
    }

    void sendMessage(ProducerProperties props, Message message, JmsDestinationImpl destRef) throws JMSException {
        SITransaction transaction;
        Object gID;
        Object gSeq;
        List rrpPath;
        JmsMessageImpl jmsMIref;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendMessage(ProducerProps, Message, Destination)");
        }
        JsJmsMessage jsJmsMessage = null;
        JmsMessageImpl foreignMsgHelper = null;
        if (message instanceof JmsMessageImpl) {
            jmsMIref = (JmsMessageImpl)message;
            jsJmsMessage = jmsMIref.getMsgReference();
            jmsMIref.clearLocalProperties();
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Create a JS message object for foreign message");
            }
            jmsMIref = foreignMsgHelper = JmsMessageImpl.messageToJmsMessageImpl(message);
            jsJmsMessage = foreignMsgHelper.getMsgReference();
        }
        PersistenceType deliveryMode = props.getEffectiveDeliveryMode();
        jsJmsMessage.setJmsDeliveryMode(deliveryMode);
        Integer priority = props.getEffectivePriority();
        jsJmsMessage.setPriority(priority.intValue());
        long timeToLive = props.getEffectiveTTL();
        this.validateTTLAndDD(timeToLive);
        List frpPath = props.getConvertedFRP();
        if (frpPath != null) {
            jsJmsMessage.uncheckedSetForwardRoutingPath(frpPath);
        }
        if ((rrpPath = props.getConvertedRRP_Part()) != null) {
            List existingRRP = jsJmsMessage.getReverseRoutingPath();
            if (existingRRP.size() > 0) {
                for (int i = 0; i < existingRRP.size(); ++i) {
                    rrpPath.add(existingRRP.get(i));
                }
            }
            jsJmsMessage.uncheckedSetReverseRoutingPath(rrpPath);
            String discrim = props.getDiscriminator();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Using discriminator from destination: " + discrim));
            }
            if (discrim != null && !discrim.equals(jsJmsMessage.getReplyDiscriminator())) {
                jsJmsMessage.setReplyDiscriminator(discrim);
            }
        }
        if (message instanceof JmsMessageImpl && ((JmsMessageImpl)message).isRrpBusNameNeedsUpdating()) {
            boolean changed = false;
            List rrp = jsJmsMessage.getReverseRoutingPath();
            if (rrp.size() > 0) {
                for (int i = 0; i < rrp.size(); ++i) {
                    JsDestinationAddress addr = (JsDestinationAddress)rrp.get(i);
                    if (addr.getBusName() != null) continue;
                    addr.setBusName(this.busName);
                    rrp.set(i, addr);
                    changed = true;
                }
            }
            if (changed) {
                jsJmsMessage.uncheckedSetReverseRoutingPath(rrp);
            }
            ((JmsMessageImpl)message).setRrpBusNameNeedsUpdating(false);
        }
        if (!destRef._getInhibitJMSDestination()) {
            byte[] destBytes = destRef.encodeToBytes(EncodingLevel.FULL);
            jsJmsMessage.setJmsDestination(destBytes);
            if (message instanceof JmsMessageImpl) {
                ((JmsMessageImpl)message).setDestReference(destRef);
            }
        }
        if (!this.disableMessageID) {
            jsJmsMessage.setApiMessageIdAsBytes(this.session.createMessageID());
        }
        jsJmsMessage.setJmsxAppId(MfpConstants.WPM_JMSXAPPID);
        jsJmsMessage.setApiUserId(this.resolvedUserID);
        if (!jsJmsMessage.alreadySent() && (gSeq = jsJmsMessage.getJMSXGroupSeq()) != null && (gID = jsJmsMessage.getObjectProperty("JMSXGroupID")) == null) {
            byte[] idBytes = this.session.createMessageID();
            StringBuffer sb = new StringBuffer("ID:");
            HexString.binToHex((byte[])idBytes, (int)0, (int)idBytes.length, (StringBuffer)sb);
            String newGroupID = sb.toString();
            jsJmsMessage.setObjectProperty("JMSXGroupID", (Object)newGroupID);
        }
        timeToLive = props.getEffectiveTTL();
        long timeNow = 0L;
        if (timeToLive != 0L || !this.disableTimestamp) {
            timeNow = System.currentTimeMillis();
        }
        if (timeToLive == 0L) {
            jsJmsMessage.setJmsExpiration(0L);
        } else {
            jsJmsMessage.setJmsExpiration(timeNow + timeToLive);
        }
        jsJmsMessage.uncheckedSetTimeToLive(timeToLive);
        if (timeNow == 0L) {
            timeNow = System.currentTimeMillis();
        }
        jsJmsMessage.setJmsDeliveryTime(timeNow + this.defaultDeliveryDelay);
        jsJmsMessage.uncheckedSetDeliveryDelay(this.defaultDeliveryDelay);
        if (!this.disableTimestamp) {
            jsJmsMessage.setTimestamp(timeNow);
        } else {
            jsJmsMessage.setTimestamp(0L);
        }
        Reliability rel = destRef.getReplyReliability();
        if (rel == null) {
            rel = props.getEffectiveReliability();
        }
        jsJmsMessage.setReliability(rel);
        jmsMIref.updateReplyReliability(this.nonPersistentReliability, this.persistentReliability);
        String discrim = props.getDiscriminator();
        try {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Setting discrim as '" + discrim + "'"));
            }
            if (this.prod != null) {
                jsJmsMessage.uncheckedSetDiscriminator(discrim);
            } else {
                jsJmsMessage.setDiscriminator(discrim);
            }
        }
        catch (IllegalArgumentException iae) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0068", new Object[]{"discriminator", discrim}, iae, null, this, tc);
        }
        jsJmsMessage.setRoutingDestination(null);
        switch (this.session.getAcknowledgeMode()) {
            case 0: {
                transaction = this.session.getTransaction();
                String acknowledgeMode = "SESSION_TRANSACTED";
                break;
            }
            case 2: {
                transaction = null;
                String acknowledgeMode = "CLIENT_ACKNOWLEDGE";
                break;
            }
            case 3: {
                transaction = null;
                String acknowledgeMode = "DUPS_OK_ACKNOWLEDGE";
                break;
            }
            case 1: {
                transaction = this.session.getTransaction();
                String acknowledgeMode = "AUTO_ACKNOWLEDGE";
                break;
            }
            default: {
                transaction = this.session.getTransaction();
                String acknowledgeMode = "NONE";
            }
        }
        jmsMIref.invalidateToStringCache();
        if (this.prod != null) {
            try {
                this.prod.send((SIBusMessage)jsJmsMessage, transaction);
            }
            catch (SINotAuthorizedException sinae) {
                throw (JMSSecurityException)JmsErrorUtils.newThrowable(JMSSecurityException.class, "PRODUCER_AUTH_ERROR_CWSIA0069", null, sinae, null, this, tc);
            }
            catch (SINotPossibleInCurrentConfigurationException dwte) {
                String msgKey = "SEND_FAILED_CWSIA0063";
                throw (InvalidDestinationException)JmsErrorUtils.newThrowable(InvalidDestinationException.class, msgKey, new Object[]{destRef}, dwte, null, this, tc);
            }
            catch (SIIncorrectCallException e) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0067", new Object[]{e, "JmsMsgProducerImpl.sendMessage (#4)"}, e, "JmsMsgProducerImpl.sendMessage#4", this, tc);
            }
            catch (SIException simpe) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0067", new Object[]{simpe, "JmsMsgProducerImpl.sendMessage (#4)"}, simpe, null, this, tc);
            }
        }
        try {
            DestinationType dt = null;
            if (destRef.isProducerTypeCheck()) {
                if (destRef instanceof Queue) {
                    dt = DestinationType.QUEUE;
                } else if (destRef instanceof Topic) {
                    dt = DestinationType.TOPICSPACE;
                }
            }
            SIDestinationAddress sida = destRef.getProducerSIDestinationAddress();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("About to do core unidentified send - transaction: " + transaction + " destAddr: " + sida + " destType: " + dt));
            }
            this.coreConnection.send((SIBusMessage)jsJmsMessage, transaction, sida, dt, this.orderingContext, null);
        }
        catch (SINotAuthorizedException sinae) {
            throw (JMSSecurityException)JmsErrorUtils.newThrowable(JMSSecurityException.class, "PRODUCER_AUTH_ERROR_CWSIA0069", null, sinae, null, this, tc);
        }
        catch (SINotPossibleInCurrentConfigurationException dwte) {
            String msgKey = "SEND_FAILED_CWSIA0063";
            throw (InvalidDestinationException)JmsErrorUtils.newThrowable(InvalidDestinationException.class, msgKey, new Object[]{destRef}, dwte, null, this, tc);
        }
        catch (SITemporaryDestinationNotFoundException tdnf) {
            String msgKey = "SEND_FAILED_CWSIA0063";
            throw (InvalidDestinationException)JmsErrorUtils.newThrowable(InvalidDestinationException.class, msgKey, new Object[]{destRef}, tdnf, null, this, tc);
        }
        catch (SIIncorrectCallException sice) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0067", new Object[]{sice, "JmsMsgProducerImpl.sendMessage (#7)"}, sice, "JmsMsgProducerImpl.sendMessage#7", this, tc);
        }
        catch (SIException sice) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0067", new Object[]{sice, "JmsMsgProducerImpl.sendMessage (#7)"}, sice, null, this, tc);
        }
        catch (Exception e) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0067", new Object[]{e, "JmsMsgProducerImpl.sendMessage (#8)"}, e, "JmsMsgProducerImpl.sendMessage#8", this, tc);
        }
        if (!(message instanceof JmsMessageImpl)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Setting properties back into foreign message");
            }
            message.setJMSDeliveryMode(foreignMsgHelper.getJMSDeliveryMode());
            message.setJMSDestination(foreignMsgHelper.getJMSDestination());
            message.setJMSExpiration(foreignMsgHelper.getJMSExpiration());
            message.setJMSMessageID(foreignMsgHelper.getJMSMessageID());
            message.setJMSPriority(foreignMsgHelper.getJMSPriority());
            message.setJMSTimestamp(foreignMsgHelper.getJMSTimestamp());
            Enumeration propertyNames = foreignMsgHelper.getPropertyNames();
            while (propertyNames.hasMoreElements()) {
                String name = (String)propertyNames.nextElement();
                if (!name.startsWith("JMSX") && !name.startsWith("JMS_IBM")) continue;
                Object value = foreignMsgHelper.getObjectProperty(name);
                try {
                    message.setObjectProperty(name, value);
                }
                catch (JMSException e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("foreign message refused setObjProperty(" + name + "): " + (Object)((Object)e)));
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendMessage(ProducerProps, Message, Destination)");
        }
    }

    private void validateDeliveryMode(int deliveryMode) throws JMSException {
        switch (deliveryMode) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0068", new Object[]{"JMSDeliveryMode", "" + deliveryMode}, tc);
            }
        }
    }

    private void validatePriority(int x) throws JMSException {
        if (x < 0 || x > 9) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0068", new Object[]{"JMSPriority", "" + x}, tc);
        }
    }

    private void validateTimeToLive(long timeToLive) throws JMSException {
        if (timeToLive < 0L || timeToLive > 9191815209357175807L) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0068", new Object[]{"timeToLive", "" + timeToLive}, tc);
        }
    }

    private void validateDeliveryDelayTime(long deliveryDelayTime) throws JMSException {
        if (deliveryDelayTime < 0L || deliveryDelayTime > 9191815209357175807L) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0068", new Object[]{"deliveryDelay", "" + deliveryDelayTime}, tc);
        }
    }

    private void validateTTLAndDD(long timeToLive) throws JMSException {
        if (this.getDeliveryDelay() > 0L && timeToLive > 0L && timeToLive <= this.getDeliveryDelay()) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0070", new Object[]{this.getDeliveryDelay(), timeToLive}, tc);
        }
    }

    public void send(Message msg) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"send", (Object)msg);
        }
        this.send_internal(msg, null);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"send");
        }
    }

    public void send(Destination dst, Message msg) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"send", (Object)new Object[]{msg, dst});
        }
        this.send_internal(dst, msg, null);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"send");
        }
    }

    @Override
    public void send(Message msg, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"send", (Object)new Object[]{msg, deliveryMode, priority, timeToLive});
        }
        this.send_internal(msg, deliveryMode, priority, timeToLive, null);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"send");
        }
    }

    @Override
    public void send(Destination dst, Message msg, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"send", (Object)new Object[]{dst, msg, deliveryMode, priority, timeToLive});
        }
        this.send_internal(dst, msg, deliveryMode, priority, timeToLive, null);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"send");
        }
    }

    private void validateCompletionListernerForNull(CompletionListener cListener) throws IllegalArgumentException {
        if (null == cListener) {
            throw (IllegalArgumentException)JmsErrorUtils.newThrowable(IllegalArgumentException.class, "INVALID_VALUE_CWSIA0068", new Object[]{"CompletionListener", null}, null, null, this, tc);
        }
    }

    private void validateMessageForNull(Message msg) throws MessageFormatException {
        if (msg == null) {
            throw (MessageFormatException)JmsErrorUtils.newThrowable(MessageFormatException.class, "INVALID_VALUE_CWSIA0068", new Object[]{"message", null}, tc);
        }
    }

    public void send(Message msg, CompletionListener cListener) throws JMSException, MessageFormatException, InvalidDestinationException, IllegalArgumentException, UnsupportedOperationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"send", (Object)new Object[]{msg, cListener});
        }
        this.validateCompletionListernerForNull(cListener);
        this.send_internal(msg, cListener);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"send");
        }
    }

    public void send(Destination dst, Message msg, CompletionListener cListener) throws JMSException, MessageFormatException, InvalidDestinationException, IllegalArgumentException, UnsupportedOperationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"send", (Object)new Object[]{dst, msg, cListener});
        }
        this.validateCompletionListernerForNull(cListener);
        this.send_internal(dst, msg, cListener);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"send");
        }
    }

    public void send(Message msg, int deliveryMode, int priority, long timeToLive, CompletionListener cListener) throws JMSException, MessageFormatException, InvalidDestinationException, IllegalArgumentException, UnsupportedOperationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"send", (Object)new Object[]{msg, deliveryMode, priority, timeToLive, cListener});
        }
        this.validateCompletionListernerForNull(cListener);
        this.send_internal(msg, deliveryMode, priority, timeToLive, cListener);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"send");
        }
    }

    public void send(Destination dst, Message msg, int deliveryMode, int priority, long timeToLive, CompletionListener cListener) throws JMSException, MessageFormatException, InvalidDestinationException, IllegalArgumentException, UnsupportedOperationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"send", (Object)new Object[]{dst, msg, deliveryMode, priority, timeToLive, cListener});
        }
        this.validateCompletionListernerForNull(cListener);
        this.send_internal(dst, msg, deliveryMode, priority, timeToLive, cListener);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"send");
        }
    }

    public void setDeliveryDelay(long deliveryDelayTime) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setDeliveryDelay", (Object)deliveryDelayTime);
        }
        this.checkClosed();
        this.validateDeliveryDelayTime(deliveryDelayTime);
        this.defaultDeliveryDelay = deliveryDelayTime;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setDeliveryDelay");
        }
    }

    public long getDeliveryDelay() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getDeliveryDelay");
        }
        this.checkClosed();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getDeliveryDelay", (Object)this.defaultDeliveryDelay);
        }
        return this.defaultDeliveryDelay;
    }

    boolean isManaged() {
        return this.session.isManaged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForAsyncSendsResolution() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"waitForAsyncSendsResolution");
        }
        if (!this.isManaged()) {
            AtomicLong atomicLong = this._inProgressAysncSends;
            synchronized (atomicLong) {
                while (this._inProgressAysncSends.get() > 0L) {
                    try {
                        this._inProgressAysncSends.wait(20000L);
                    }
                    catch (InterruptedException e) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                        SibTr.debug((TraceComponent)tc, (String)"waitForAsyncSendsResolution got interrupted", (Object)e);
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"waitForAsyncSendsResolution");
        }
    }
}

