/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi.impl.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.microprofile.openapi.impl.validation.OASValidationResult;
import com.ibm.ws.microprofile.openapi.impl.validation.TypeValidator;
import com.ibm.ws.microprofile.openapi.impl.validation.ValidationHelper;
import com.ibm.ws.microprofile.openapi.utils.OpenAPIModelWalker;
import org.eclipse.microprofile.openapi.models.responses.APIResponses;

public class ResponsesValidator
extends TypeValidator<APIResponses> {
    private static final TraceComponent tc = Tr.register(ResponsesValidator.class);
    private static final ResponsesValidator INSTANCE = new ResponsesValidator();

    public static ResponsesValidator getInstance() {
        return INSTANCE;
    }

    private ResponsesValidator() {
    }

    @Override
    public void validate(ValidationHelper helper, OpenAPIModelWalker.Context context, String key, APIResponses t) {
        if (t != null) {
            String message;
            if (t.size() == 0 && t.getDefault() == null) {
                message = Tr.formatMessage((TraceComponent)tc, (String)"responseMustContainOneCode", (Object[])new Object[0]);
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
            } else if (!t.keySet().stream().anyMatch(v -> this.isSuccessStatusCode((String)v))) {
                message = Tr.formatMessage((TraceComponent)tc, (String)"responseShouldContainSuccess", (Object[])new Object[0]);
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.WARNING, context.getLocation(), message));
            }
            for (String k : t.keySet()) {
                if (t.get((Object)k) != null) continue;
                String message2 = Tr.formatMessage((TraceComponent)tc, (String)"nullValueInMap", (Object[])new Object[]{k});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message2));
            }
        }
    }

    @FFDCIgnore(value={NumberFormatException.class})
    private boolean isSuccessStatusCode(String s) {
        if (s == null) {
            return false;
        }
        if ("2XX".equals(s) || "default".equals(s)) {
            return true;
        }
        if (s.length() != 3) {
            return false;
        }
        try {
            int i = Integer.parseInt(s);
            return i >= 200 && i <= 299;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }
}

