/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi.impl.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.microprofile.openapi.impl.validation.OASValidationResult;
import com.ibm.ws.microprofile.openapi.impl.validation.TypeValidator;
import com.ibm.ws.microprofile.openapi.impl.validation.ValidationHelper;
import com.ibm.ws.microprofile.openapi.impl.validation.ValidatorUtils;
import com.ibm.ws.microprofile.openapi.utils.OpenAPIModelWalker;
import org.eclipse.microprofile.openapi.models.ExternalDocumentation;

public class ExternalDocumentationValidator
extends TypeValidator<ExternalDocumentation> {
    private static final TraceComponent tc = Tr.register(ExternalDocumentationValidator.class);
    private static final ExternalDocumentationValidator INSTANCE = new ExternalDocumentationValidator();

    public static ExternalDocumentationValidator getInstance() {
        return INSTANCE;
    }

    private ExternalDocumentationValidator() {
    }

    @Override
    public void validate(ValidationHelper helper, OpenAPIModelWalker.Context context, String key, ExternalDocumentation t) {
        ValidatorUtils.validateRequiredField(t.getUrl(), context, "url").ifPresent(helper::addValidationEvent);
        if (t.getUrl() != null && !ValidatorUtils.isValidURI(t.getUrl())) {
            String message = Tr.formatMessage((TraceComponent)tc, (String)"externalDocumentationInvalidURL", (Object[])new Object[]{t.getUrl()});
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation("url"), message));
        }
    }
}

