/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi.impl.core.util;

import com.fasterxml.jackson.databind.introspect.Annotated;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.microprofile.openapi.impl.core.converter.ModelConverters;
import com.ibm.ws.microprofile.openapi.impl.core.converter.ResolvedSchema;
import com.ibm.ws.microprofile.openapi.impl.core.util.Json;
import com.ibm.ws.microprofile.openapi.impl.core.util.PrimitiveType;
import com.ibm.ws.microprofile.openapi.impl.jaxrs2.OperationParser;
import com.ibm.ws.microprofile.openapi.impl.model.ExternalDocumentationImpl;
import com.ibm.ws.microprofile.openapi.impl.model.examples.ExampleImpl;
import com.ibm.ws.microprofile.openapi.impl.model.headers.HeaderImpl;
import com.ibm.ws.microprofile.openapi.impl.model.info.ContactImpl;
import com.ibm.ws.microprofile.openapi.impl.model.info.InfoImpl;
import com.ibm.ws.microprofile.openapi.impl.model.info.LicenseImpl;
import com.ibm.ws.microprofile.openapi.impl.model.links.LinkImpl;
import com.ibm.ws.microprofile.openapi.impl.model.media.ContentImpl;
import com.ibm.ws.microprofile.openapi.impl.model.media.EncodingImpl;
import com.ibm.ws.microprofile.openapi.impl.model.media.MediaTypeImpl;
import com.ibm.ws.microprofile.openapi.impl.model.media.SchemaImpl;
import com.ibm.ws.microprofile.openapi.impl.model.responses.APIResponseImpl;
import com.ibm.ws.microprofile.openapi.impl.model.responses.APIResponsesImpl;
import com.ibm.ws.microprofile.openapi.impl.model.servers.ServerImpl;
import com.ibm.ws.microprofile.openapi.impl.model.servers.ServerVariableImpl;
import com.ibm.ws.microprofile.openapi.impl.model.servers.ServerVariablesImpl;
import com.ibm.ws.microprofile.openapi.impl.model.tags.TagImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.ws.rs.Produces;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.eclipse.microprofile.openapi.annotations.ExternalDocumentation;
import org.eclipse.microprofile.openapi.annotations.callbacks.Callback;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.info.License;
import org.eclipse.microprofile.openapi.annotations.links.Link;
import org.eclipse.microprofile.openapi.annotations.links.LinkParameter;
import org.eclipse.microprofile.openapi.annotations.media.Encoding;
import org.eclipse.microprofile.openapi.annotations.media.ExampleObject;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.servers.ServerVariable;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.eclipse.microprofile.openapi.models.Components;
import org.eclipse.microprofile.openapi.models.examples.Example;
import org.eclipse.microprofile.openapi.models.headers.Header;
import org.eclipse.microprofile.openapi.models.info.Contact;
import org.eclipse.microprofile.openapi.models.info.Info;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.Encoding;
import org.eclipse.microprofile.openapi.models.media.MediaType;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.responses.APIResponses;
import org.eclipse.microprofile.openapi.models.servers.Server;
import org.eclipse.microprofile.openapi.models.servers.ServerVariables;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class AnnotationsUtils {
    public static final String COMPONENTS_REF = "#/components/schemas/";
    static final long serialVersionUID = -6049006194330501775L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static boolean hasSchemaAnnotation(Schema schema) {
        if (schema == null) {
            return false;
        }
        return !StringUtils.isBlank((CharSequence)schema.type().toString()) || !StringUtils.isBlank((CharSequence)schema.format()) || !StringUtils.isBlank((CharSequence)schema.title()) || !StringUtils.isBlank((CharSequence)schema.description()) || !StringUtils.isBlank((CharSequence)schema.ref()) || !StringUtils.isBlank((CharSequence)schema.name()) || schema.multipleOf() != 0.0 || !StringUtils.isBlank((CharSequence)schema.maximum()) || !StringUtils.isBlank((CharSequence)schema.minimum()) || schema.exclusiveMinimum() || schema.exclusiveMaximum() || schema.maxLength() != Integer.MAX_VALUE || schema.minLength() != 0 || schema.minProperties() != 0 || schema.maxProperties() != 0 || schema.requiredProperties().length != 0 || schema.required() || schema.nullable() || schema.readOnly() || schema.writeOnly() || schema.deprecated() || schema.enumeration().length != 0 || !StringUtils.isBlank((CharSequence)schema.defaultValue()) || !schema.implementation().equals(Void.class) || !StringUtils.isBlank((CharSequence)schema.example()) || !StringUtils.isBlank((CharSequence)schema.pattern()) || !schema.not().equals(Void.class) || schema.allOf().length != 0 || schema.oneOf().length != 0 || schema.anyOf().length != 0 || AnnotationsUtils.getExternalDocumentation(schema.externalDocs()).isPresent() || !StringUtils.isBlank((CharSequence)schema.discriminatorProperty()) || schema.discriminatorMapping().length != 0 || schema.hidden();
    }

    @FFDCIgnore(value={IOException.class})
    public static Optional<Example> getExample(ExampleObject example) {
        if (example == null) {
            return Optional.empty();
        }
        ExampleImpl exampleObject = new ExampleImpl();
        boolean isEmpty = true;
        if (StringUtils.isNotBlank((CharSequence)example.ref())) {
            exampleObject.setRef(example.ref());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank((CharSequence)example.description())) {
            exampleObject.setDescription(example.description());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank((CharSequence)example.summary())) {
            exampleObject.setSummary(example.summary());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank((CharSequence)example.externalValue())) {
            exampleObject.setExternalValue(example.externalValue());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank((CharSequence)example.value())) {
            try {
                exampleObject.setValue((Object)Json.mapper().readTree(example.value()));
            }
            catch (IOException e) {
                exampleObject.setValue((Object)example.value());
            }
            isEmpty = false;
        }
        if (isEmpty) {
            return Optional.empty();
        }
        return Optional.of(exampleObject);
    }

    public static String getNameOfReferenceableItem(Object annotation) {
        if (annotation == null) {
            return "";
        }
        String name = "";
        String ref = "";
        if (annotation instanceof org.eclipse.microprofile.openapi.annotations.headers.Header) {
            name = ((org.eclipse.microprofile.openapi.annotations.headers.Header)annotation).name();
            ref = ((org.eclipse.microprofile.openapi.annotations.headers.Header)annotation).ref();
        } else if (annotation instanceof ExampleObject) {
            name = ((ExampleObject)annotation).name();
            ref = ((ExampleObject)annotation).ref();
        } else if (annotation instanceof Link) {
            name = ((Link)annotation).name();
            ref = ((Link)annotation).ref();
        } else if (annotation instanceof Callback) {
            name = ((Callback)annotation).name();
            ref = ((Callback)annotation).ref();
        }
        if (StringUtils.isBlank((CharSequence)name) && StringUtils.isNotBlank((CharSequence)ref)) {
            int index = ref.lastIndexOf(47);
            return index == -1 ? ref : ref.substring(index + 1);
        }
        return name;
    }

    @FFDCIgnore(value={IOException.class})
    public static Optional<org.eclipse.microprofile.openapi.models.media.Schema> getSchemaFromAnnotation(Schema schema, Components components) {
        Class[] schemaImplementations;
        if (schema == null || !AnnotationsUtils.hasSchemaAnnotation(schema)) {
            return Optional.empty();
        }
        SchemaImpl schemaObject = new SchemaImpl();
        if (StringUtils.isNotBlank((CharSequence)schema.description())) {
            schemaObject.setDescription(schema.description());
        }
        if (StringUtils.isNotBlank((CharSequence)schema.ref())) {
            schemaObject.setRef(schema.ref());
        }
        if (StringUtils.isNotBlank((CharSequence)schema.type().toString())) {
            schemaObject.setType(Schema.SchemaType.valueOf((String)schema.type().toString().toUpperCase()));
        }
        if (StringUtils.isNotBlank((CharSequence)schema.defaultValue())) {
            schemaObject.setDefaultValue((Object)schema.defaultValue());
        }
        if (StringUtils.isNotBlank((CharSequence)schema.example())) {
            try {
                schemaObject.setExample((Object)Json.mapper().readTree(schema.example()));
            }
            catch (IOException e) {
                schemaObject.setExample((Object)schema.example());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)schema.format())) {
            schemaObject.setFormat(schema.format());
        }
        if (StringUtils.isNotBlank((CharSequence)schema.pattern())) {
            schemaObject.setPattern(schema.pattern());
        }
        if (schema.readOnly()) {
            schemaObject.setReadOnly(Boolean.valueOf(schema.readOnly()));
        }
        if (schema.deprecated()) {
            schemaObject.setDeprecated(Boolean.valueOf(schema.deprecated()));
        }
        if (schema.exclusiveMaximum()) {
            schemaObject.setExclusiveMaximum(Boolean.valueOf(schema.exclusiveMaximum()));
        }
        if (schema.exclusiveMinimum()) {
            schemaObject.setExclusiveMinimum(Boolean.valueOf(schema.exclusiveMinimum()));
        }
        if (schema.maxProperties() > 0) {
            schemaObject.setMaxProperties(Integer.valueOf(schema.maxProperties()));
        }
        if (schema.maxLength() != Integer.MAX_VALUE && schema.maxLength() > 0) {
            schemaObject.setMaxLength(Integer.valueOf(schema.maxLength()));
        }
        if (schema.minProperties() > 0) {
            schemaObject.setMinProperties(Integer.valueOf(schema.minProperties()));
        }
        if (schema.minLength() > 0) {
            schemaObject.setMinLength(Integer.valueOf(schema.minLength()));
        }
        if (schema.multipleOf() != 0.0) {
            schemaObject.setMultipleOf(new BigDecimal(schema.multipleOf()));
        }
        if (NumberUtils.isNumber((String)schema.maximum())) {
            String filteredMaximum = schema.maximum().replaceAll(",", "");
            schemaObject.setMaximum(new BigDecimal(filteredMaximum));
        }
        if (NumberUtils.isNumber((String)schema.minimum())) {
            String filteredMinimum = schema.minimum().replaceAll(",", "");
            schemaObject.setMinimum(new BigDecimal(filteredMinimum));
        }
        if (schema.nullable()) {
            schemaObject.setNullable(Boolean.valueOf(schema.nullable()));
        }
        if (StringUtils.isNotBlank((CharSequence)schema.title())) {
            schemaObject.setTitle(schema.title());
        }
        if (schema.writeOnly()) {
            schemaObject.setWriteOnly(Boolean.valueOf(schema.writeOnly()));
        }
        if (schema.requiredProperties().length > 0) {
            schemaObject.setRequired(Arrays.asList(schema.requiredProperties()));
        }
        if (schema.enumeration().length > 0) {
            schemaObject.setEnumeration(Arrays.asList(schema.enumeration()));
        }
        if (schema.maxItems() != Integer.MIN_VALUE) {
            schemaObject.setMaxItems(Integer.valueOf(schema.maxItems()));
        }
        if (schema.minItems() != Integer.MAX_VALUE) {
            schemaObject.setMinItems(Integer.valueOf(schema.minItems()));
        }
        if (schema.uniqueItems()) {
            schemaObject.setUniqueItems(Boolean.valueOf(true));
        }
        if (!schema.not().equals(Void.class)) {
            Class schemaImplementation = schema.not();
            org.eclipse.microprofile.openapi.models.media.Schema notSchemaObject = AnnotationsUtils.resolveSchemaFromType(schemaImplementation, components);
            schemaObject.setNot(notSchemaObject);
        }
        if (schema.oneOf().length > 0) {
            for (Class schemaImplementation : schemaImplementations = schema.oneOf()) {
                org.eclipse.microprofile.openapi.models.media.Schema oneOfSchemaObject = AnnotationsUtils.resolveSchemaFromType(schemaImplementation, components);
                schemaObject.addOneOf(oneOfSchemaObject);
            }
        }
        if (schema.anyOf().length > 0) {
            for (Class schemaImplementation : schemaImplementations = schema.anyOf()) {
                org.eclipse.microprofile.openapi.models.media.Schema anyOfSchemaObject = AnnotationsUtils.resolveSchemaFromType(schemaImplementation, components);
                schemaObject.addAnyOf(anyOfSchemaObject);
            }
        }
        if (schema.allOf().length > 0) {
            for (Class schemaImplementation : schemaImplementations = schema.allOf()) {
                org.eclipse.microprofile.openapi.models.media.Schema allOfSchemaObject = AnnotationsUtils.resolveSchemaFromType(schemaImplementation, components);
                schemaObject.addAllOf(allOfSchemaObject);
            }
        }
        AnnotationsUtils.getExternalDocumentation(schema.externalDocs()).ifPresent(arg_0 -> ((org.eclipse.microprofile.openapi.models.media.Schema)schemaObject).setExternalDocs(arg_0));
        return Optional.of(schemaObject);
    }

    public static Optional<? extends org.eclipse.microprofile.openapi.models.media.Schema> getSchema(Schema annotationSchema, Components components) {
        Class schemaImplementation = annotationSchema.implementation();
        boolean isArray = false;
        if (annotationSchema.type() == SchemaType.ARRAY) {
            isArray = true;
        }
        if (schemaImplementation != Void.class) {
            SchemaImpl schemaObject = new SchemaImpl();
            PrimitiveType pt = PrimitiveType.fromType(schemaImplementation);
            if (pt != null) {
                schemaObject = pt.createProperty();
            } else {
                ResolvedSchema resolvedSchema = ModelConverters.getInstance().readAllAsResolvedSchema(schemaImplementation);
                if (resolvedSchema != null) {
                    Map<String, org.eclipse.microprofile.openapi.models.media.Schema> schemaMap = resolvedSchema.referencedSchemas;
                    schemaMap.forEach((key, schema) -> components.addSchema(key, schema));
                    SchemaImpl property = new SchemaImpl((SchemaImpl)resolvedSchema.schema);
                    boolean inline = false;
                    if (annotationSchema != null && annotationSchema.type() != SchemaType.ARRAY && AnnotationsUtils.hasSchemaAnnotation(annotationSchema)) {
                        inline = AnnotationsUtils.overrideSchemaFromAnnotation((org.eclipse.microprofile.openapi.models.media.Schema)property, annotationSchema);
                    }
                    if (!inline) {
                        schemaObject.setRef(COMPONENTS_REF + ((SchemaImpl)resolvedSchema.schema).getName());
                    } else {
                        schemaObject = property;
                    }
                }
            }
            if (StringUtils.isBlank((CharSequence)schemaObject.getRef()) && schemaObject.getType() == null) {
                schemaObject.setType(Schema.SchemaType.STRING);
            }
            if (isArray) {
                Optional<org.eclipse.microprofile.openapi.models.media.Schema> schema2 = AnnotationsUtils.getSchemaFromAnnotation(annotationSchema, components);
                Object arraySchema = schema2.isPresent() ? schema2.get() : new SchemaImpl();
                arraySchema.type(Schema.SchemaType.ARRAY);
                arraySchema.setItems((org.eclipse.microprofile.openapi.models.media.Schema)schemaObject);
                return Optional.of(arraySchema);
            }
            return Optional.of(schemaObject);
        }
        return AnnotationsUtils.getSchemaFromAnnotation(annotationSchema, components);
    }

    public static org.eclipse.microprofile.openapi.models.media.Schema resolveSchemaFromType(Class<?> schemaImplementation, Components components) {
        SchemaImpl schemaObject = new SchemaImpl();
        PrimitiveType pt = PrimitiveType.fromType(schemaImplementation);
        if (pt != null) {
            schemaObject = pt.createProperty();
        } else {
            ResolvedSchema resolvedSchema = ModelConverters.getInstance().readAllAsResolvedSchema(schemaImplementation);
            if (resolvedSchema != null) {
                Map<String, org.eclipse.microprofile.openapi.models.media.Schema> schemaMap = resolvedSchema.referencedSchemas;
                schemaMap.forEach((key, referencedSchema) -> {
                    if (components != null) {
                        components.addSchema(key, referencedSchema);
                    }
                });
                schemaObject.setRef(COMPONENTS_REF + ((SchemaImpl)resolvedSchema.schema).getName());
            }
        }
        return schemaObject;
    }

    public static Optional<Set<org.eclipse.microprofile.openapi.models.tags.Tag>> getTags(Tag[] tags, boolean skipOnlyName) {
        if (tags == null) {
            return Optional.empty();
        }
        LinkedHashSet<TagImpl> tagsList = new LinkedHashSet<TagImpl>();
        for (Tag tag : tags) {
            if (StringUtils.isBlank((CharSequence)tag.name()) && StringUtils.isBlank((CharSequence)tag.ref()) || skipOnlyName && StringUtils.isBlank((CharSequence)tag.description()) && StringUtils.isBlank((CharSequence)tag.externalDocs().description()) && StringUtils.isBlank((CharSequence)tag.externalDocs().url())) continue;
            TagImpl tagObject = new TagImpl();
            if (StringUtils.isNotBlank((CharSequence)tag.description())) {
                tagObject.setDescription(tag.description());
            }
            if (StringUtils.isNotBlank((CharSequence)tag.ref())) {
                tagObject.setName(tag.ref());
            } else {
                tagObject.setName(tag.name());
            }
            AnnotationsUtils.getExternalDocumentation(tag.externalDocs()).ifPresent(arg_0 -> ((org.eclipse.microprofile.openapi.models.tags.Tag)tagObject).setExternalDocs(arg_0));
            tagsList.add(tagObject);
        }
        if (tagsList.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(tagsList);
    }

    public static Optional<List<Server>> getServers(org.eclipse.microprofile.openapi.annotations.servers.Server[] servers) {
        if (servers == null) {
            return Optional.empty();
        }
        ArrayList serverObjects = new ArrayList();
        for (org.eclipse.microprofile.openapi.annotations.servers.Server server : servers) {
            AnnotationsUtils.getServer(server).ifPresent(serverObjects::add);
        }
        if (serverObjects.size() == 0) {
            return Optional.empty();
        }
        return Optional.of(serverObjects);
    }

    public static Optional<Server> getServer(org.eclipse.microprofile.openapi.annotations.servers.Server server) {
        Optional<ServerVariables> serverVariablesObject;
        if (server == null) {
            return Optional.empty();
        }
        ServerImpl serverObject = new ServerImpl();
        boolean isEmpty = true;
        if (StringUtils.isNotBlank((CharSequence)server.url())) {
            serverObject.setUrl(server.url());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank((CharSequence)server.description())) {
            serverObject.setDescription(server.description());
            isEmpty = false;
        }
        if ((serverVariablesObject = AnnotationsUtils.getServerVariables(server.variables())).isPresent()) {
            isEmpty = false;
            serverObject.setVariables(serverVariablesObject.get());
        }
        if (isEmpty) {
            return Optional.empty();
        }
        return Optional.of(serverObject);
    }

    public static Optional<ServerVariables> getServerVariables(ServerVariable[] serverVariables) {
        if (serverVariables == null) {
            return null;
        }
        boolean isEmpty = true;
        ServerVariablesImpl serverVariablesObject = new ServerVariablesImpl();
        for (ServerVariable serverVariable : serverVariables) {
            boolean isVariableEmpty = true;
            ServerVariableImpl serverVariableObject = new ServerVariableImpl();
            if (StringUtils.isNotBlank((CharSequence)serverVariable.description())) {
                serverVariableObject.setDescription(serverVariable.description());
                isVariableEmpty = false;
            }
            if (StringUtils.isNotBlank((CharSequence)serverVariable.defaultValue())) {
                serverVariableObject.setDefaultValue(serverVariable.defaultValue());
                isVariableEmpty = false;
            }
            if (serverVariable.enumeration() != null && serverVariable.enumeration().length > 0) {
                serverVariableObject.setEnumeration(Arrays.asList(serverVariable.enumeration()));
                isVariableEmpty = false;
            }
            if (isVariableEmpty) continue;
            serverVariablesObject.addServerVariable(serverVariable.name(), (org.eclipse.microprofile.openapi.models.servers.ServerVariable)serverVariableObject);
            isEmpty = false;
        }
        if (isEmpty) {
            return Optional.empty();
        }
        return Optional.of(serverVariablesObject);
    }

    public static Optional<org.eclipse.microprofile.openapi.models.ExternalDocumentation> getExternalDocumentation(ExternalDocumentation externalDocumentation) {
        if (externalDocumentation == null) {
            return Optional.empty();
        }
        boolean isEmpty = true;
        ExternalDocumentationImpl external = new ExternalDocumentationImpl();
        if (StringUtils.isNotBlank((CharSequence)externalDocumentation.description())) {
            isEmpty = false;
            external.setDescription(externalDocumentation.description());
        }
        if (StringUtils.isNotBlank((CharSequence)externalDocumentation.url())) {
            isEmpty = false;
            external.setUrl(externalDocumentation.url());
        }
        if (isEmpty) {
            return Optional.empty();
        }
        return Optional.of(external);
    }

    public static Optional<Info> getInfo(org.eclipse.microprofile.openapi.annotations.info.Info info) {
        if (info == null) {
            return Optional.empty();
        }
        boolean isEmpty = true;
        InfoImpl infoObject = new InfoImpl();
        if (StringUtils.isNotBlank((CharSequence)info.description())) {
            infoObject.setDescription(info.description());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank((CharSequence)info.termsOfService())) {
            infoObject.setTermsOfService(info.termsOfService());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank((CharSequence)info.title())) {
            infoObject.setTitle(info.title());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank((CharSequence)info.version())) {
            infoObject.setVersion(info.version());
            isEmpty = false;
        }
        AnnotationsUtils.getContact(info.contact()).ifPresent(arg_0 -> ((Info)infoObject).setContact(arg_0));
        isEmpty &= infoObject.getContact() == null;
        AnnotationsUtils.getLicense(info.license()).ifPresent(arg_0 -> ((Info)infoObject).setLicense(arg_0));
        if (isEmpty &= infoObject.getLicense() == null) {
            return Optional.empty();
        }
        return Optional.of(infoObject);
    }

    public static Optional<Contact> getContact(org.eclipse.microprofile.openapi.annotations.info.Contact contact) {
        if (contact == null) {
            return Optional.empty();
        }
        boolean isEmpty = true;
        ContactImpl contactObject = new ContactImpl();
        if (StringUtils.isNotBlank((CharSequence)contact.email())) {
            contactObject.setEmail(contact.email());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank((CharSequence)contact.name())) {
            contactObject.setName(contact.name());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank((CharSequence)contact.url())) {
            contactObject.setUrl(contact.url());
            isEmpty = false;
        }
        if (isEmpty) {
            return Optional.empty();
        }
        return Optional.of(contactObject);
    }

    public static Optional<org.eclipse.microprofile.openapi.models.info.License> getLicense(License license) {
        if (license == null) {
            return Optional.empty();
        }
        LicenseImpl licenseObject = new LicenseImpl();
        boolean isEmpty = true;
        if (StringUtils.isNotBlank((CharSequence)license.name())) {
            licenseObject.setName(license.name());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank((CharSequence)license.url())) {
            licenseObject.setUrl(license.url());
            isEmpty = false;
        }
        if (isEmpty) {
            return Optional.empty();
        }
        return Optional.of(licenseObject);
    }

    public static Map<String, org.eclipse.microprofile.openapi.models.links.Link> getLinks(Link[] links) {
        HashMap<String, org.eclipse.microprofile.openapi.models.links.Link> linkMap = new HashMap<String, org.eclipse.microprofile.openapi.models.links.Link>();
        if (links == null) {
            return linkMap;
        }
        for (Link link : links) {
            AnnotationsUtils.getLink(link).ifPresent(linkResult -> linkMap.put(AnnotationsUtils.getNameOfReferenceableItem(link), (org.eclipse.microprofile.openapi.models.links.Link)linkResult));
        }
        return linkMap;
    }

    @FFDCIgnore(value={IOException.class})
    public static Optional<org.eclipse.microprofile.openapi.models.links.Link> getLink(Link link) {
        Optional<Server> server;
        if (link == null) {
            return Optional.empty();
        }
        boolean isEmpty = true;
        LinkImpl linkObject = new LinkImpl();
        if (StringUtils.isNotBlank((CharSequence)link.ref())) {
            linkObject.setRef(link.ref());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank((CharSequence)link.description())) {
            linkObject.setDescription(link.description());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank((CharSequence)link.operationId())) {
            linkObject.setOperationId(link.operationId());
            isEmpty = false;
            if (StringUtils.isNotBlank((CharSequence)link.operationRef())) {
                // empty if block
            }
        } else if (StringUtils.isNotBlank((CharSequence)link.operationRef())) {
            linkObject.setOperationRef(link.operationRef());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank((CharSequence)link.requestBody())) {
            try {
                linkObject.setRequestBody((Object)Json.mapper().readTree(link.requestBody()));
            }
            catch (IOException e) {
                linkObject.setRequestBody((Object)link.requestBody());
            }
            isEmpty = false;
        }
        if ((server = AnnotationsUtils.getServer(link.server())).isPresent()) {
            linkObject.setServer(server.get());
            isEmpty = false;
        }
        if (isEmpty) {
            return Optional.empty();
        }
        Map<String, Object> linkParameters = AnnotationsUtils.getLinkParameters(link.parameters());
        if (linkParameters.size() > 0) {
            linkObject.setParameters(linkParameters);
        }
        return Optional.of(linkObject);
    }

    public static Map<String, Object> getLinkParameters(LinkParameter[] linkParameter) {
        HashMap<String, Object> linkParametersMap = new HashMap<String, Object>();
        if (linkParameter == null) {
            return linkParametersMap;
        }
        for (LinkParameter parameter : linkParameter) {
            linkParametersMap.put(parameter.name(), parameter.expression());
        }
        return linkParametersMap;
    }

    public static Optional<Map<String, Header>> getHeaders(org.eclipse.microprofile.openapi.annotations.headers.Header[] annotationHeaders) {
        if (annotationHeaders == null) {
            return Optional.empty();
        }
        HashMap headers = new HashMap();
        for (org.eclipse.microprofile.openapi.annotations.headers.Header header : annotationHeaders) {
            AnnotationsUtils.getHeader(header).ifPresent(headerResult -> headers.put(AnnotationsUtils.getNameOfReferenceableItem(header), headerResult));
        }
        if (headers.size() == 0) {
            return Optional.empty();
        }
        return Optional.of(headers);
    }

    public static Optional<Header> getHeader(org.eclipse.microprofile.openapi.annotations.headers.Header header) {
        if (header == null) {
            return Optional.empty();
        }
        HeaderImpl headerObject = new HeaderImpl();
        boolean isEmpty = true;
        if (StringUtils.isNotBlank((CharSequence)header.ref())) {
            headerObject.setRef(header.ref());
            isEmpty = false;
        } else {
            headerObject.setStyle(Header.Style.SIMPLE);
        }
        if (StringUtils.isNotBlank((CharSequence)header.description())) {
            headerObject.setDescription(header.description());
            isEmpty = false;
        }
        if (header.deprecated()) {
            headerObject.setDeprecated(Boolean.valueOf(header.deprecated()));
        }
        if (header.required()) {
            headerObject.setRequired(Boolean.valueOf(header.required()));
            isEmpty = false;
        }
        if (header.allowEmptyValue()) {
            headerObject.setAllowEmptyValue(Boolean.valueOf(header.allowEmptyValue()));
            isEmpty = false;
        }
        if (header.schema() != null && header.schema().implementation().equals(Void.class)) {
            AnnotationsUtils.getSchemaFromAnnotation(header.schema(), null).ifPresent(arg_0 -> AnnotationsUtils.lambda$getHeader$4((Header)headerObject, arg_0));
        }
        if (isEmpty) {
            return Optional.empty();
        }
        return Optional.of(headerObject);
    }

    public static void addEncodingToMediaType(MediaType mediaType, Encoding encoding) {
        Optional<Map<String, Header>> optHeaders;
        if (encoding == null) {
            return;
        }
        EncodingImpl encodingObject = new EncodingImpl();
        boolean isEmpty = true;
        if (StringUtils.isNotBlank((CharSequence)encoding.contentType())) {
            encodingObject.setContentType(encoding.contentType());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank((CharSequence)encoding.style())) {
            encodingObject.setStyle(Encoding.Style.valueOf((String)encoding.style().toUpperCase()));
            isEmpty = false;
        }
        if (encoding.explode()) {
            encodingObject.setExplode(Boolean.valueOf(encoding.explode()));
            isEmpty = false;
        }
        if (encoding.allowReserved()) {
            encodingObject.setAllowReserved(Boolean.valueOf(encoding.allowReserved()));
            isEmpty = false;
        }
        if (encoding.headers() != null && (optHeaders = AnnotationsUtils.getHeaders(encoding.headers())).isPresent()) {
            encodingObject.headers(optHeaders.get());
            isEmpty = false;
        }
        if (!isEmpty) {
            mediaType.addEncoding(encoding.name(), (org.eclipse.microprofile.openapi.models.media.Encoding)encodingObject);
        }
    }

    public static Type getSchemaType(Schema schema) {
        if (schema == null) {
            return String.class;
        }
        String schemaType = schema.type().toString();
        Class schemaImplementation = schema.implementation();
        if (!schemaImplementation.equals(Void.class)) {
            return schemaImplementation;
        }
        if (StringUtils.isBlank((CharSequence)schemaType)) {
            return String.class;
        }
        switch (schemaType) {
            case "number": {
                return BigDecimal.class;
            }
            case "integer": {
                return Long.class;
            }
            case "boolean": {
                return Boolean.class;
            }
        }
        return String.class;
    }

    @FFDCIgnore(value={NoSuchMethodException.class, SecurityException.class})
    public static Optional<Content> getContent(org.eclipse.microprofile.openapi.annotations.media.Content[] annotationContents, String[] classTypes, String[] methodTypes, org.eclipse.microprofile.openapi.models.media.Schema schema) {
        Encoding[] encodings;
        ExampleObject[] examples;
        if (annotationContents == null || annotationContents.length == 0) {
            return Optional.empty();
        }
        ContentImpl content = new ContentImpl();
        org.eclipse.microprofile.openapi.annotations.media.Content annotationContent = annotationContents[0];
        MediaTypeImpl mediaType = new MediaTypeImpl();
        mediaType.setSchema(schema);
        for (ExampleObject example : examples = annotationContent.examples()) {
            AnnotationsUtils.getExample(example).ifPresent(arg_0 -> AnnotationsUtils.lambda$getContent$5((MediaType)mediaType, example, arg_0));
        }
        Method getExampleMethod = null;
        try {
            getExampleMethod = annotationContent.getClass().getMethod("example", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (getExampleMethod != null) {
            try {
                String example = (String)getExampleMethod.invoke((Object)annotationContent, new Object[0]);
                if (example != null && !example.isEmpty()) {
                    mediaType.example((Object)example);
                }
            }
            catch (IllegalAccessException example) {
                FFDCFilter.processException((Throwable)example, (String)"com.ibm.ws.microprofile.openapi.impl.core.util.AnnotationsUtils", (String)"857", null, (Object[])new Object[]{annotationContents, classTypes, methodTypes, schema});
            }
            catch (IllegalArgumentException example) {
                FFDCFilter.processException((Throwable)example, (String)"com.ibm.ws.microprofile.openapi.impl.core.util.AnnotationsUtils", (String)"858", null, (Object[])new Object[]{annotationContents, classTypes, methodTypes, schema});
            }
            catch (InvocationTargetException example) {
                FFDCFilter.processException((Throwable)example, (String)"com.ibm.ws.microprofile.openapi.impl.core.util.AnnotationsUtils", (String)"859", null, (Object[])new Object[]{annotationContents, classTypes, methodTypes, schema});
            }
        }
        for (Encoding encoding : encodings = annotationContent.encoding()) {
            AnnotationsUtils.addEncodingToMediaType((MediaType)mediaType, encoding);
        }
        if (StringUtils.isNotBlank((CharSequence)annotationContent.mediaType())) {
            content.addMediaType(annotationContent.mediaType(), (MediaType)mediaType);
        } else if (mediaType.getSchema() != null) {
            AnnotationsUtils.applyTypes(classTypes, methodTypes, (Content)content, (MediaType)mediaType);
        }
        if (content.size() == 0) {
            return Optional.empty();
        }
        return Optional.of(content);
    }

    public static Optional<APIResponses> getApiResponses(APIResponse[] responses, Produces classProduces, Produces methodProduces, Components components, boolean useResponseCodeAsKey) {
        if (responses == null) {
            return Optional.empty();
        }
        APIResponsesImpl apiResponsesObject = new APIResponsesImpl();
        for (APIResponse response : responses) {
            APIResponseImpl apiResponseObject = new APIResponseImpl();
            if (StringUtils.isNotBlank((CharSequence)response.ref())) {
                apiResponseObject.setRef(response.ref());
            }
            if (StringUtils.isNotBlank((CharSequence)response.description())) {
                apiResponseObject.setDescription(response.description());
            }
            OperationParser.getContent(response.content(), classProduces == null ? new String[]{} : classProduces.value(), methodProduces == null ? new String[]{} : methodProduces.value(), components).ifPresent(arg_0 -> ((org.eclipse.microprofile.openapi.models.responses.APIResponse)apiResponseObject).content(arg_0));
            AnnotationsUtils.getHeaders(response.headers()).ifPresent(arg_0 -> ((org.eclipse.microprofile.openapi.models.responses.APIResponse)apiResponseObject).headers(arg_0));
            Map<String, org.eclipse.microprofile.openapi.models.links.Link> links = AnnotationsUtils.getLinks(response.links());
            if (links.size() > 0) {
                apiResponseObject.setLinks(links);
            }
            if (useResponseCodeAsKey) {
                if (StringUtils.isNotBlank((CharSequence)response.responseCode())) {
                    apiResponsesObject.addApiResponse(response.responseCode(), (org.eclipse.microprofile.openapi.models.responses.APIResponse)apiResponseObject);
                    continue;
                }
                apiResponsesObject.defaultValue((org.eclipse.microprofile.openapi.models.responses.APIResponse)apiResponseObject);
                continue;
            }
            apiResponsesObject.addApiResponse(response.name(), (org.eclipse.microprofile.openapi.models.responses.APIResponse)apiResponseObject);
        }
        if (apiResponsesObject.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(apiResponsesObject);
    }

    public static void applyTypes(String[] classTypes, String[] methodTypes, Content content, MediaType mediaType) {
        if (methodTypes != null && methodTypes.length > 0) {
            for (String value : methodTypes) {
                content.addMediaType(value, mediaType);
            }
        } else if (classTypes != null && classTypes.length > 0) {
            for (String value : classTypes) {
                content.addMediaType(value, mediaType);
            }
        } else {
            content.addMediaType("*/*", mediaType);
        }
    }

    public static Schema getSchemaAnnotation(Annotated a) {
        if (a == null) {
            return null;
        }
        return (Schema)a.getAnnotation(Schema.class);
    }

    public static Schema getSchemaAnnotation(Class<?> cls) {
        if (cls == null) {
            return null;
        }
        return cls.getAnnotation(Schema.class);
    }

    public static boolean overrideSchemaFromAnnotation(org.eclipse.microprofile.openapi.models.media.Schema schema, Schema annSchema) {
        boolean overriden = false;
        if (annSchema.deprecated()) {
            schema.setDeprecated(Boolean.valueOf(true));
            overriden = true;
        }
        if (annSchema.exclusiveMaximum()) {
            schema.setExclusiveMaximum(Boolean.valueOf(annSchema.exclusiveMaximum()));
            overriden = true;
        }
        if (annSchema.exclusiveMinimum()) {
            schema.setExclusiveMinimum(Boolean.valueOf(annSchema.exclusiveMinimum()));
            overriden = true;
        }
        if (annSchema.nullable()) {
            schema.setNullable(Boolean.valueOf(annSchema.nullable()));
            overriden = true;
        }
        if (annSchema.readOnly()) {
            schema.setReadOnly(Boolean.valueOf(annSchema.readOnly()));
            overriden = true;
        }
        if (annSchema.uniqueItems()) {
            schema.setUniqueItems(Boolean.valueOf(annSchema.uniqueItems()));
            overriden = true;
        }
        if (annSchema.writeOnly()) {
            schema.setWriteOnly(Boolean.valueOf(annSchema.writeOnly()));
            overriden = true;
        }
        if (StringUtils.isNotBlank((CharSequence)annSchema.defaultValue())) {
            schema.setDefaultValue((Object)annSchema.defaultValue());
            overriden = true;
        }
        if (StringUtils.isNotBlank((CharSequence)annSchema.description())) {
            schema.setDescription(annSchema.description());
            overriden = true;
        }
        if (StringUtils.isNotBlank((CharSequence)annSchema.example())) {
            schema.setExample((Object)annSchema.example());
            overriden = true;
        }
        if (StringUtils.isNotBlank((CharSequence)annSchema.format())) {
            schema.setFormat(annSchema.format());
            overriden = true;
        }
        if (StringUtils.isNotBlank((CharSequence)annSchema.maximum())) {
            try {
                schema.setMaximum(new BigDecimal(annSchema.maximum()));
            }
            catch (NumberFormatException numberFormatException) {
                FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.microprofile.openapi.impl.core.util.AnnotationsUtils", (String)"1000", null, (Object[])new Object[]{schema, annSchema});
            }
            overriden = true;
        }
        if (StringUtils.isNotBlank((CharSequence)annSchema.minimum())) {
            try {
                schema.setMinimum(new BigDecimal(annSchema.minimum()));
            }
            catch (NumberFormatException numberFormatException) {
                FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.microprofile.openapi.impl.core.util.AnnotationsUtils", (String)"1007", null, (Object[])new Object[]{schema, annSchema});
            }
            overriden = true;
        }
        if (StringUtils.isNotBlank((CharSequence)annSchema.pattern())) {
            schema.setPattern(annSchema.pattern());
            overriden = true;
        }
        if (StringUtils.isNotBlank((CharSequence)annSchema.title())) {
            schema.setTitle(annSchema.title());
            overriden = true;
        }
        if (annSchema.maxItems() != Integer.MIN_VALUE) {
            schema.setMaxItems(Integer.valueOf(annSchema.maxItems()));
            overriden = true;
        }
        if (annSchema.minItems() != Integer.MAX_VALUE) {
            schema.setMaxItems(Integer.valueOf(annSchema.minItems()));
            overriden = true;
        }
        if (annSchema.maxProperties() != 0) {
            schema.setMaxProperties(Integer.valueOf(annSchema.maxProperties()));
            overriden = true;
        }
        if (annSchema.minProperties() != 0) {
            schema.setMinProperties(Integer.valueOf(annSchema.minProperties()));
            overriden = true;
        }
        return overriden;
    }

    private static /* synthetic */ void lambda$getContent$5(MediaType mediaType, ExampleObject example, Example exampleObject) {
        mediaType.addExample(AnnotationsUtils.getNameOfReferenceableItem(example), exampleObject);
    }

    private static /* synthetic */ void lambda$getHeader$4(Header headerObject, org.eclipse.microprofile.openapi.models.media.Schema schema) {
        if (schema.getType() != null) {
            headerObject.setSchema(schema);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.microprofile.openapi.impl.core.util.AnnotationsUtils", AnnotationsUtils.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");
    }
}

