/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.metrics30.internal.writer;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.microprofile.metrics.exceptions.EmptyRegistryException;
import com.ibm.ws.microprofile.metrics.exceptions.NoSuchMetricException;
import com.ibm.ws.microprofile.metrics.exceptions.NoSuchRegistryException;
import com.ibm.ws.microprofile.metrics23.writer.PrometheusMetricWriter23;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.metrics30.internal.helper.PrometheusBuilder30;
import io.openliberty.microprofile.metrics30.internal.helper.Util30;
import io.openliberty.microprofile.metrics30.internal.writer.OutputWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricType;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class PrometheusMetricWriter30
extends PrometheusMetricWriter23
implements OutputWriter {
    private static final TraceComponent tc = Tr.register(PrometheusMetricWriter30.class, (String)"METRICS", (String)"io.openliberty.microprofile.metrics.internal.resources.Metrics");
    static final long serialVersionUID = 5466558605302839084L;

    public PrometheusMetricWriter30(Writer writer, Locale locale) {
        super(writer, locale);
    }

    @Override
    protected void writeMetricsAsPrometheus(StringBuilder builder, String registryName) throws NoSuchRegistryException, EmptyRegistryException {
        this.writeMetricMapAsPrometheus(builder, registryName, Util30.getMetricsAsMap(registryName), Util30.getMetricsMetadataAsMap(registryName));
    }

    @Override
    protected void writeMetricsAsPrometheus(StringBuilder builder, String registryName, String metricName) throws NoSuchRegistryException, NoSuchMetricException, EmptyRegistryException {
        this.writeMetricMapAsPrometheus(builder, registryName, Util30.getMetricsAsMap(registryName, metricName), Util30.getMetricsMetadataAsMap(registryName));
    }

    @Override
    protected void writeMetricMapAsPrometheus(StringBuilder builder, String registryName, Map<MetricID, Metric> metricMap, Map<String, Metadata> metricMetadataMap) {
        for (Map.Entry<String, Metadata> metadataEntry : metricMetadataMap.entrySet()) {
            String metricName = metadataEntry.getKey();
            String metricNamePrometheus = registryName + "_" + metricName;
            Metadata metricMetadata = metadataEntry.getValue();
            HashMap<MetricID, Metric> currentMetricMap = new HashMap<MetricID, Metric>();
            for (Map.Entry<MetricID, Metric> metricEntry : metricMap.entrySet()) {
                if (!metricEntry.getKey().getName().equals(metricName)) continue;
                currentMetricMap.put(metricEntry.getKey(), metricEntry.getValue());
            }
            if (currentMetricMap.isEmpty()) continue;
            String description = !metricMetadata.description().isPresent() || ((String)metricMetadata.description().get()).trim().isEmpty() ? "" : Tr.formatMessage((TraceComponent)tc, (Locale)this.locale, (String)((String)metricMetadata.description().get()), (Object[])new Object[0]);
            String unit = metricMetadata.getUnit();
            Map.Entry<String, Double> conversionAppendEntry = this.resolveConversionFactorXappendUnitEntry(unit);
            double conversionFactor = conversionAppendEntry.getValue();
            String appendUnit = conversionAppendEntry.getKey();
            if (metricMetadata.getTypeRaw().equals((Object)MetricType.COUNTER)) {
                PrometheusBuilder30.buildCounter30(builder, metricNamePrometheus, description, currentMetricMap);
                continue;
            }
            if (metricMetadata.getTypeRaw().equals((Object)MetricType.CONCURRENT_GAUGE)) {
                PrometheusBuilder30.buildConcurrentGauge30(builder, metricNamePrometheus, description, currentMetricMap);
                continue;
            }
            if (metricMetadata.getTypeRaw().equals((Object)MetricType.GAUGE)) {
                PrometheusBuilder30.buildGauge30(builder, metricNamePrometheus, description, currentMetricMap, conversionFactor, appendUnit);
                continue;
            }
            if (metricMetadata.getTypeRaw().equals((Object)MetricType.TIMER)) {
                PrometheusBuilder30.buildTimer30(builder, metricNamePrometheus, description, currentMetricMap);
                continue;
            }
            if (metricMetadata.getTypeRaw().equals((Object)MetricType.HISTOGRAM)) {
                PrometheusBuilder30.buildHistogram30(builder, metricNamePrometheus, description, currentMetricMap, conversionFactor, appendUnit);
                continue;
            }
            if (metricMetadata.getTypeRaw().equals((Object)MetricType.METERED)) {
                PrometheusBuilder30.buildMeter30(builder, metricNamePrometheus, description, currentMetricMap);
                continue;
            }
            if (metricMetadata.getTypeRaw().equals((Object)MetricType.SIMPLE_TIMER)) {
                PrometheusBuilder30.buildSimpleTimer30(builder, metricNamePrometheus, description, currentMetricMap);
                continue;
            }
            Tr.event((TraceComponent)tc, (String)("Metadata " + metricMetadata.toString() + " does not have an appropriate Metric Type"), (Object[])new Object[0]);
        }
    }
}

