/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.metrics30.internal.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.microprofile.metrics.impl.Clock;
import com.ibm.ws.microprofile.metrics.impl.ExponentiallyDecayingReservoir;
import com.ibm.ws.microprofile.metrics.impl.HistogramImpl;
import com.ibm.ws.microprofile.metrics.impl.MeterImpl;
import com.ibm.ws.microprofile.metrics.impl.Reservoir;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.time.Duration;
import java.util.concurrent.Callable;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.Snapshot;
import org.eclipse.microprofile.metrics.Timer;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class Timer30Impl
implements Timer {
    protected Duration elapsedTime;
    protected final Meter meter;
    protected final Histogram histogram;
    protected final Clock clock;
    static final long serialVersionUID = -3067607173136128026L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public Timer30Impl() {
        this(new ExponentiallyDecayingReservoir());
    }

    public Timer30Impl(Reservoir reservoir) {
        this(reservoir, Clock.defaultClock());
    }

    protected Timer30Impl(Reservoir reservoir, Clock clock) {
        this.meter = new MeterImpl(clock);
        this.clock = clock;
        this.histogram = new HistogramImpl(reservoir);
        this.elapsedTime = Duration.ZERO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Duration duration) {
        Timer30Impl timer30Impl = this;
        synchronized (timer30Impl) {
            if (duration.toNanos() >= 0L) {
                this.histogram.update(duration.toNanos());
                this.meter.mark();
                this.elapsedTime = this.elapsedTime.plus(duration);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T time(Callable<T> event) throws Exception {
        long startTime = this.clock.getTick();
        try {
            T t = event.call();
            return t;
        }
        finally {
            this.update(Duration.ofNanos(this.clock.getTick() - startTime));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void time(Runnable event) {
        long startTime = this.clock.getTick();
        try {
            event.run();
        }
        finally {
            this.update(Duration.ofNanos(this.clock.getTick() - startTime));
        }
    }

    public Timer.Context time() {
        return new Context(this, this.clock);
    }

    public long getCount() {
        return this.histogram.getCount();
    }

    public double getFifteenMinuteRate() {
        return this.meter.getFifteenMinuteRate();
    }

    public double getFiveMinuteRate() {
        return this.meter.getFiveMinuteRate();
    }

    public double getMeanRate() {
        return this.meter.getMeanRate();
    }

    public double getOneMinuteRate() {
        return this.meter.getOneMinuteRate();
    }

    public Snapshot getSnapshot() {
        return this.histogram.getSnapshot();
    }

    public Duration getElapsedTime() {
        return this.elapsedTime;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.metrics30.internal.impl.Timer30Impl", Timer30Impl.class, (String)"METRICS", (String)"io.openliberty.microprofile.metrics.internal.resources.Metrics");
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class Context
    implements Timer.Context {
        protected final Timer30Impl timer;
        protected final Clock clock;
        protected final long startTime;
        static final long serialVersionUID = -378945786802539143L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public Context(Timer30Impl timer, Clock clock) {
            this.timer = timer;
            this.clock = clock;
            this.startTime = clock.getTick();
        }

        public long stop() {
            long elapsed = this.clock.getTick() - this.startTime;
            this.timer.update(Duration.ofNanos(elapsed));
            return elapsed;
        }

        public void close() {
            this.stop();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.metrics30.internal.impl.Timer30Impl$Context", Context.class, (String)"METRICS", (String)"io.openliberty.microprofile.metrics.internal.resources.Metrics");
        }
    }
}

