/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util.dopriv;

import com.ibm.ws.util.ThreadContextAccessor;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class SetContextClassLoaderPrivileged
implements PrivilegedAction {
    private ClassLoader oldClassLoader;
    private ClassLoader newClassLoader;
    public boolean wasChanged;
    private final ThreadContextAccessor threadContextAccessor;

    public SetContextClassLoaderPrivileged(ThreadContextAccessor threadContextAccessor) {
        this.threadContextAccessor = threadContextAccessor;
    }

    public SetContextClassLoaderPrivileged(ThreadContextAccessor threadContextAccessor, ClassLoader newCL) {
        this(threadContextAccessor);
        this.newClassLoader = newCL;
    }

    public ClassLoader execute(ClassLoader cl) {
        this.newClassLoader = cl;
        cl = this.threadContextAccessor.isPrivileged() ? (ClassLoader)this.run() : (ClassLoader)AccessController.doPrivileged(this);
        this.newClassLoader = null;
        this.oldClassLoader = null;
        return cl;
    }

    public Object run() {
        Thread currentThread = Thread.currentThread();
        this.oldClassLoader = this.threadContextAccessor.getContextClassLoader(currentThread);
        if (this.newClassLoader == this.oldClassLoader) {
            this.wasChanged = false;
        } else if (this.newClassLoader == null && this.oldClassLoader != null || this.newClassLoader != null && (this.oldClassLoader == null || !this.newClassLoader.equals(this.oldClassLoader))) {
            this.threadContextAccessor.setContextClassLoader(currentThread, this.newClassLoader);
            this.wasChanged = true;
        } else {
            this.wasChanged = false;
        }
        return this.oldClassLoader;
    }
}

