/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util;

public class FastStack<T> {
    private T[] stack;
    private int topOfStack;
    private int currentCapacity;

    public FastStack() {
        this(11);
    }

    public FastStack(int initialCapacity) {
        this.stack = this.createArray(initialCapacity);
        this.topOfStack = -1;
        this.currentCapacity = this.stack.length;
    }

    private T[] createArray(int size) {
        return new Object[size];
    }

    public T peek() {
        if (this.topOfStack >= 0) {
            return this.stack[this.topOfStack];
        }
        return null;
    }

    public T push(T o) {
        this.ensureCapacity(this.topOfStack + 1);
        this.stack[++this.topOfStack] = o;
        return this.stack[this.topOfStack];
    }

    public T pop() {
        if (this.topOfStack >= 0) {
            T result = this.stack[this.topOfStack];
            this.stack[this.topOfStack--] = null;
            return result;
        }
        return null;
    }

    public void reset() {
        while (this.topOfStack >= 0) {
            this.stack[this.topOfStack--] = null;
        }
    }

    private void ensureCapacity(int newCapacity) {
        if (newCapacity >= this.currentCapacity) {
            T[] newStack = this.createArray(this.currentCapacity + 2 * this.currentCapacity);
            System.arraycopy(this.stack, 0, newStack, 0, this.stack.length);
            this.stack = newStack;
            this.currentCapacity = this.stack.length;
        }
    }

    public int getTopOfStackIndex() {
        return this.topOfStack;
    }
}

