/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.impl;

import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.ConsumerRebalanceListener;
import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.TopicPartition;
import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.impl.TopicPartitionImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConsumerRebalanceListenerImpl
implements org.apache.kafka.clients.consumer.ConsumerRebalanceListener {
    private static final String CLAZZ = ConsumerRebalanceListenerImpl.class.getName();
    private static final Logger LOGGER = Logger.getLogger(CLAZZ);
    private final ConsumerRebalanceListener listener;

    public ConsumerRebalanceListenerImpl(ConsumerRebalanceListener listener) {
        this.listener = listener;
    }

    public void onPartitionsAssigned(Collection<org.apache.kafka.common.TopicPartition> delegatePartitions) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.logp(Level.FINEST, CLAZZ, "onPartitionsAssigned", "TopicPartitions: {0}", delegatePartitions);
        }
        Collection<TopicPartition> partitions = this.wrap(delegatePartitions);
        this.listener.onPartitionsAssigned(partitions);
    }

    public void onPartitionsRevoked(Collection<org.apache.kafka.common.TopicPartition> delegatePartitions) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.logp(Level.FINEST, CLAZZ, "onPartitionsRevoked", "TopicPartitions: {0}", delegatePartitions);
        }
        Collection<TopicPartition> partitions = this.wrap(delegatePartitions);
        this.listener.onPartitionsRevoked(partitions);
    }

    private Collection<TopicPartition> wrap(Collection<org.apache.kafka.common.TopicPartition> delegatePartitions) {
        ArrayList<TopicPartition> partitions = new ArrayList<TopicPartition>();
        for (org.apache.kafka.common.TopicPartition delegatePartition : delegatePartitions) {
            TopicPartitionImpl partition = new TopicPartitionImpl(delegatePartition);
            partitions.add(partition);
        }
        return partitions;
    }
}

