/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.internal.hpel;

import com.ibm.ejs.ras.hpel.HpelHelper;
import com.ibm.websphere.logging.WsLevel;
import com.ibm.ws.logging.hpel.LogRepositoryWriter;
import com.ibm.ws.logging.hpel.handlers.LogRecordHandler;
import com.ibm.ws.logging.hpel.impl.LogRepositoryBaseImpl;
import com.ibm.ws.logging.hpel.impl.LogRepositoryManagerImpl;
import com.ibm.ws.logging.hpel.impl.LogRepositoryWriterCBuffImpl;
import com.ibm.ws.logging.hpel.impl.LogRepositoryWriterImpl;
import com.ibm.ws.logging.internal.hpel.HpelBaseTraceService;
import com.ibm.ws.logging.internal.hpel.HpelTraceServiceConfig;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

public class HpelTraceServiceWriter {
    private volatile NoCloseLogRecordHandler hpelLog = null;
    private final HpelBaseTraceService service;
    private HpelTraceServiceConfig.LogState currentLogState = null;
    private HpelTraceServiceConfig.TraceState currentTraceState = null;
    private final ReentrantReadWriteLock handlerLock = new ReentrantReadWriteLock();

    HpelTraceServiceWriter(HpelBaseTraceService service) {
        this.service = service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(HpelTraceServiceConfig config) {
        this.handlerLock.writeLock().lock();
        try {
            LogRepositoryWriter traceWriter;
            LogRepositoryWriterImpl writer;
            LogRepositoryManagerImpl traceManager;
            boolean isNewTrace;
            LogRepositoryWriterImpl logWriter;
            LogRepositoryManagerImpl logManager;
            boolean isNewLog;
            String pid = HpelHelper.getProcessId();
            if (this.hpelLog == null) {
                this.hpelLog = new NoCloseLogRecordHandler();
            } else if (config.ivLog.equals(this.currentLogState) && config.ivTrace.equals(this.currentTraceState)) {
                return;
            }
            LogRepositoryWriterImpl oldLogWriter = null;
            LogRepositoryManagerImpl oldLogManager = null;
            if (this.currentLogState != null && (oldLogWriter = (LogRepositoryWriterImpl)this.hpelLog.getLogWriter()) != null) {
                oldLogManager = (LogRepositoryManagerImpl)oldLogWriter.getLogRepositoryManager();
            }
            LogRepositoryWriterImpl oldTraceWriter = null;
            LogRepositoryManagerImpl oldTraceManager = null;
            if (this.currentTraceState != null && (oldTraceWriter = this.currentTraceState.ivMemoryBufferSize > 0 ? (LogRepositoryWriterImpl)((LogRepositoryWriterCBuffImpl)this.hpelLog.getTraceWriter()).getWriter() : (LogRepositoryWriterImpl)this.hpelLog.getTraceWriter()) != null) {
                oldTraceManager = (LogRepositoryManagerImpl)oldTraceWriter.getLogRepositoryManager();
            }
            if (this.currentLogState == null || !this.currentLogState.ivDataDirectory.equals(config.ivLog.ivDataDirectory)) {
                isNewLog = true;
                logManager = new LogRepositoryManagerImpl(config.ivLog.getLocation(), pid, config.ivServerName, true);
                logWriter = new LogRepositoryWriterImpl(logManager);
            } else {
                isNewLog = false;
                logManager = oldLogManager;
                logWriter = oldLogWriter;
            }
            if (this.currentTraceState == null || !this.currentTraceState.ivDataDirectory.equals(config.ivTrace.ivDataDirectory)) {
                isNewTrace = true;
                traceManager = new LogRepositoryManagerImpl(config.ivTrace.getLocation(), pid, config.ivServerName, true);
                writer = new LogRepositoryWriterImpl(traceManager);
            } else {
                isNewTrace = false;
                traceManager = oldTraceManager;
                writer = oldTraceWriter;
            }
            if (isNewLog || this.currentLogState == null || this.currentLogState.ivPurgeMaxSize != config.ivLog.ivPurgeMaxSize || this.currentLogState.ivPurgeMinTime != config.ivLog.ivPurgeMinTime) {
                logManager.configure(config.ivLog.getPurgeMaxSize(), config.ivLog.getPurgeMinTime());
            }
            logWriter.setBufferingEnabled(config.ivLog.ivBufferingEnabled);
            logWriter.setOutOfSpaceAction(config.ivLog.ivOutOfSpaceAction.ordinal());
            if (isNewLog || this.currentLogState == null || this.currentLogState.ivFileSwitchTime != config.ivLog.ivFileSwitchTime) {
                if (this.currentLogState != null) {
                    logWriter.disableFileSwitch();
                }
                if (config.ivLog.ivFileSwitchTime >= 0) {
                    logWriter.enableFileSwitch(config.ivLog.ivFileSwitchTime);
                }
            }
            if (isNewTrace || this.currentTraceState == null || this.currentTraceState.ivPurgeMaxSize != config.ivTrace.ivPurgeMaxSize || this.currentTraceState.ivPurgeMinTime != config.ivTrace.ivPurgeMinTime) {
                traceManager.configure(config.ivTrace.getPurgeMaxSize(), config.ivTrace.getPurgeMinTime());
            }
            writer.setBufferingEnabled(config.ivTrace.ivBufferingEnabled);
            writer.setOutOfSpaceAction(config.ivTrace.ivOutOfSpaceAction.ordinal());
            if (isNewTrace || this.currentTraceState == null || this.currentTraceState.ivFileSwitchTime != config.ivTrace.ivFileSwitchTime) {
                if (this.currentTraceState != null) {
                    writer.disableFileSwitch();
                }
                if (config.ivTrace.ivFileSwitchTime >= 0) {
                    writer.enableFileSwitch(config.ivTrace.ivFileSwitchTime);
                }
            }
            if (config.ivTrace.ivMemoryBufferSize > 0) {
                traceWriter = !isNewTrace && this.currentTraceState != null && this.currentTraceState.ivMemoryBufferSize > 0 ? this.hpelLog.getTraceWriter() : new LogRepositoryWriterCBuffImpl(writer);
                ((LogRepositoryWriterCBuffImpl)traceWriter).setMaxSize(config.ivTrace.getMemoryBufferSize());
            } else {
                traceWriter = writer;
            }
            if (oldLogWriter != null && oldLogManager != null && oldLogManager != logWriter.getLogRepositoryManager()) {
                oldLogWriter.stop();
                oldLogManager.stop();
            }
            if (oldTraceWriter != null && oldTraceManager != null && oldTraceManager != writer.getLogRepositoryManager()) {
                oldTraceWriter.stop();
                oldTraceManager.stop();
            }
            this.currentLogState = config.ivLog.clone();
            if (this.hpelLog.getLogWriter() != logWriter) {
                this.hpelLog.setLogWriter(logWriter);
            }
            this.currentTraceState = config.ivTrace.clone();
            if (this.hpelLog.getTraceWriter() != traceWriter) {
                this.hpelLog.setTraceWriter(traceWriter);
            }
        }
        finally {
            this.handlerLock.writeLock().unlock();
        }
    }

    public void stop() {
        this.handlerLock.writeLock().lock();
        try {
            if (this.hpelLog != null) {
                this.hpelLog.stop();
                this.hpelLog = null;
            }
            this.currentLogState = null;
            this.currentTraceState = null;
        }
        finally {
            this.handlerLock.writeLock().unlock();
        }
    }

    public void repositoryPublish(LogRecord record) {
        Handler handler = this.getHandler();
        if (handler != null) {
            handler.publish(record);
        }
    }

    public Handler getHandler() {
        return this.hpelLog;
    }

    private class NoCloseLogRecordHandler
    extends LogRecordHandler {
        public NoCloseLogRecordHandler() {
            super(WsLevel.DETAIL.intValue(), LogRepositoryBaseImpl.KNOWN_FORMATTERS[0]);
        }

        @Override
        public void publish(LogRecord logRecord) {
            boolean doPublish = HpelTraceServiceWriter.this.service == null || HpelTraceServiceWriter.this.service.notifyConsole(logRecord);
            HpelTraceServiceWriter.this.handlerLock.readLock().lock();
            try {
                if (doPublish && HpelTraceServiceWriter.this.hpelLog != null) {
                    super.publish(logRecord);
                }
            }
            finally {
                HpelTraceServiceWriter.this.handlerLock.readLock().unlock();
            }
        }

        @Override
        public void close() {
        }
    }
}

