/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.hpel.impl;

import com.ibm.ejs.ras.hpel.HpelHelper;
import com.ibm.ejs.ras.hpel.Messages;
import com.ibm.websphere.logging.hpel.reader.RepositoryLogRecord;
import com.ibm.websphere.logging.hpel.reader.RepositoryPointer;
import com.ibm.ws.logging.hpel.impl.HpelMessageConverter;
import com.ibm.ws.logging.internal.WsLogRecord;
import com.ibm.ws.logging.object.hpel.HpelLogRecordFactory;
import com.ibm.ws.logging.object.hpel.LogRecordStack;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class LogRecordWrapper
implements RepositoryLogRecord {
    private static final long serialVersionUID = 1770501124954999137L;
    private final String messageID;
    private final String rawMessage;
    private final long millis;
    private final Level level;
    private final int threadID;
    private final long sequence;
    private final String localizedMessage;
    private final String messageLocale;
    private final String loggerName;
    private final String resourceBundleName;
    private final String sourceClassName;
    private final String sourceMethodName;
    private final Object[] parameters;
    private final int localizable;
    private final byte[] rawData;
    private final String stackTrace;
    private final Map<String, String> extensions;

    public LogRecordWrapper(LogRecord record) {
        if (record == null) {
            throw new IllegalArgumentException("Wrapper's base record cannot be null");
        }
        this.millis = record.getMillis();
        this.level = record.getLevel();
        this.extensions = LogRecordStack.getExtensions();
        this.threadID = HpelHelper.getActiveThreadId(record);
        this.sequence = record.getSequenceNumber();
        this.rawMessage = record.getMessage();
        this.loggerName = record.getLoggerName();
        this.resourceBundleName = record.getResourceBundleName();
        this.sourceClassName = record.getSourceClassName();
        this.sourceMethodName = record.getSourceMethodName();
        this.stackTrace = record.getThrown() != null ? HpelHelper.throwableToString(record.getThrown()) : null;
        this.parameters = record.getParameters();
        WsLogRecord wsLogRecord = HpelLogRecordFactory.getWsLogRecordIfConvertible(record);
        if (wsLogRecord != null) {
            Locale locale;
            this.localizable = wsLogRecord.getLocalizable();
            if (wsLogRecord.getMessageLocale() != null) {
                this.messageLocale = wsLogRecord.getMessageLocale();
                String[] items = this.messageLocale.split("_");
                locale = items.length == 0 ? Locale.getDefault() : (items.length == 1 ? new Locale(items[0]) : (items.length == 2 ? new Locale(items[0], items[1]) : new Locale(items[0], items[1], items[2])));
            } else {
                locale = Locale.getDefault();
                this.messageLocale = locale.toString();
            }
            if (this.localizable == 2) {
                String formatted = wsLogRecord.getFormattedMessage();
                this.localizedMessage = this.rawMessage == null || !this.rawMessage.equals(formatted) ? formatted : null;
            } else {
                this.localizedMessage = LogRecordWrapper.getLocalized(record, locale);
            }
            this.rawData = wsLogRecord.getRawData();
            this.extensions.putAll(wsLogRecord.getExtensions());
            if (wsLogRecord.getReporterOrSourceThreadName() != null) {
                this.extensions.put("thread", wsLogRecord.getReporterOrSourceThreadName());
            }
        } else {
            this.localizable = 0;
            Locale locale = Locale.getDefault();
            this.messageLocale = locale.toString();
            this.localizedMessage = LogRecordWrapper.getLocalized(record, locale);
            this.rawData = null;
        }
        this.messageID = HpelMessageConverter.getMessageId(this.localizedMessage == null ? this.rawMessage : this.localizedMessage);
    }

    private static String getLocalized(LogRecord r, Locale locale) {
        String messageKey;
        String defaultMessage;
        String localizedMessage = null;
        ResourceBundle resourceBundle = r.getResourceBundle();
        String resourceBundleName = r.getResourceBundleName();
        if (resourceBundleName != null && (defaultMessage = r.getMessage()) != null && defaultMessage.equals(localizedMessage = Messages.getStringFromBundle(resourceBundle, resourceBundleName, messageKey = defaultMessage.replace(' ', '.'), locale, defaultMessage))) {
            localizedMessage = null;
        }
        return localizedMessage;
    }

    @Override
    public String getExtension(String name) {
        return this.extensions.get(name);
    }

    @Override
    public Map<String, String> getExtensions() {
        return this.extensions;
    }

    @Override
    public String getFormattedMessage() {
        String result;
        String string = result = this.localizedMessage == null ? this.rawMessage : this.localizedMessage;
        if (this.parameters != null) {
            try {
                return MessageFormat.format(result, this.parameters);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public int getLocalizable() {
        return this.localizable;
    }

    @Override
    public String getLocalizedMessage() {
        return this.localizedMessage;
    }

    @Override
    public String getLoggerName() {
        return this.loggerName;
    }

    @Override
    public String getMessageID() {
        return this.messageID;
    }

    @Override
    public String getMessageLocale() {
        return this.messageLocale;
    }

    @Override
    public Object[] getParameters() {
        return this.parameters;
    }

    @Override
    public byte[] getRawData() {
        return this.rawData;
    }

    @Override
    public String getRawMessage() {
        return this.rawMessage;
    }

    @Override
    public String getResourceBundleName() {
        return this.resourceBundleName;
    }

    @Override
    public long getSequence() {
        return this.sequence;
    }

    @Override
    public String getSourceClassName() {
        return this.sourceClassName;
    }

    @Override
    public String getSourceMethodName() {
        return this.sourceMethodName;
    }

    @Override
    public String getStackTrace() {
        return this.stackTrace;
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    @Override
    public long getMillis() {
        return this.millis;
    }

    @Override
    public RepositoryPointer getRepositoryPointer() {
        throw new UnsupportedOperationException("Repository Pointer property is not applicable to this wrapper implementation.");
    }

    @Override
    public int getThreadID() {
        return this.threadID;
    }
}

