/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.hpel.config;

import com.ibm.ws.logging.internal.hpel.HpelTraceServiceConfig;
import com.ibm.wsspi.logprovider.LogProviderConfig;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class HpelConfigurator {
    static final AtomicReference<HpelTraceServiceConfig> loggingConfig = new AtomicReference<Object>(null);

    public static synchronized void init(HpelTraceServiceConfig config) {
        if (config == null) {
            throw new NullPointerException("LogProviderConfig must not be null");
        }
        loggingConfig.compareAndSet(null, config);
    }

    public static synchronized void updateLog(Map<String, Object> newConfig) {
        if (newConfig == null) {
            throw new NullPointerException("Updated config must not be null");
        }
        HpelTraceServiceConfig config = loggingConfig.get();
        if (config != null) {
            config.updateLog(newConfig);
            config.getTrDelegate().update((LogProviderConfig)config);
        }
    }

    public static synchronized void updateTrace(Map<String, Object> newConfig) {
        if (newConfig == null) {
            throw new NullPointerException("Updated config must not be null");
        }
        HpelTraceServiceConfig config = loggingConfig.get();
        if (config != null) {
            config.updateTrace(newConfig);
            config.getTrDelegate().update((LogProviderConfig)config);
        }
    }
}

