/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.parsers.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.feature.internal.subsystem.SubsystemFeatureDefinitionImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class EsaSubsystemFeatureDefinitionImpl
extends SubsystemFeatureDefinitionImpl {
    private final ZipFile esa;
    static final long serialVersionUID = 3534749460013356346L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static EsaSubsystemFeatureDefinitionImpl constructInstance(File esa) throws ZipException, IOException {
        ZipFile zip = new ZipFile(esa);
        Enumeration<? extends ZipEntry> zipEntries = zip.entries();
        ZipEntry subsystemEntry = null;
        while (zipEntries.hasMoreElements()) {
            ZipEntry nextEntry = zipEntries.nextElement();
            if (!"OSGI-INF/SUBSYSTEM.MF".equalsIgnoreCase(nextEntry.getName())) continue;
            subsystemEntry = nextEntry;
        }
        return new EsaSubsystemFeatureDefinitionImpl(zip.getInputStream(subsystemEntry), zip);
    }

    private EsaSubsystemFeatureDefinitionImpl(InputStream manifestInputStream, ZipFile esa) throws IOException {
        super(null, manifestInputStream);
        this.esa = esa;
    }

    protected ResourceBundle getResourceBundle(Locale locale) {
        ZipEntry[] entries;
        String localizationLocation = this.getHeader("Subsystem-Localization");
        if (localizationLocation == null) {
            return null;
        }
        for (ZipEntry entry : entries = new ZipEntry[]{this.esa.getEntry(localizationLocation + "_" + locale.toString() + ".properties"), this.esa.getEntry(localizationLocation + "_" + locale.getLanguage() + ".properties"), this.esa.getEntry(localizationLocation + ".properties")}) {
            if (entry == null) continue;
            try {
                return new PropertyResourceBundle(new InputStreamReader(this.esa.getInputStream(entry)));
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.repository.parsers.internal.EsaSubsystemFeatureDefinitionImpl", (String)"86", (Object)((Object)this), (Object[])new Object[]{locale});
            }
        }
        return null;
    }

    public String getIbmShortName() {
        String shortName = super.getIbmShortName();
        if (shortName == null) {
            shortName = this.getHeader("IBM-ShortName");
        }
        return shortName;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.repository.parsers.internal.EsaSubsystemFeatureDefinitionImpl", EsaSubsystemFeatureDefinitionImpl.class, null, null);
    }
}

