/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.webcontainer.util;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.servlet.response.IResponse;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.srt.WriteBeyondContentLengthException;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.channelfw.ChannelFrameworkFactory;
import com.ibm.wsspi.webcontainer.util.IOutputStreamObserver;
import com.ibm.wsspi.webcontainer.util.WSServletOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class ByteBufferOutputStream
extends WSServletOutputStream {
    private static final TraceComponent tc = Tr.register(ByteBufferOutputStream.class, (String)"webcontainer", (String)"com.ibm.ws.webcontainer.resources.LShimMessages");
    private List<WsByteBuffer> bbList = new ArrayList<WsByteBuffer>();
    private WsByteBuffer current = null;
    private boolean _hasWritten = false;
    private int bufferSize = 8192;
    protected int count;
    protected int total;
    protected int limit = -1;
    private IOutputStreamObserver obs;
    private IOException except;
    private boolean committed = false;
    private boolean byteBuffersRetrieved;
    private IResponse response;
    private static TraceNLS nls = TraceNLS.getTraceNLS(ByteBufferOutputStream.class, (String)"com.ibm.ws.webcontainer.resources.Messages");

    public List<WsByteBuffer> getByteBufferList() {
        this.byteBuffersRetrieved = true;
        return this.bbList;
    }

    @Override
    public void reset() {
        this.current = null;
        this._hasWritten = false;
        this.byteBuffersRetrieved = false;
        this.limit = -1;
        this.total = 0;
        if (!this.byteBuffersRetrieved) {
            ListIterator<WsByteBuffer> it = this.bbList.listIterator();
            while (it.hasNext()) {
                WsByteBuffer next = it.next();
                next.release();
                it.remove();
            }
        }
    }

    public void write(int ch) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("write --> " + ch + ", limit->" + this.limit), (Object[])new Object[0]);
        }
        if (this.limit > -1 && this.total >= this.limit) {
            throw new WriteBeyondContentLengthException();
        }
        if (!this._hasWritten && this.obs != null) {
            this._hasWritten = true;
            this.obs.alertFirstWrite();
        }
        this.checkList();
        this.current.put((byte)ch);
        ++this.total;
    }

    public void write(byte[] buf, int offset, int len) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("write len --> " + len + ", limit->" + this.limit), (Object[])new Object[0]);
        }
        if (len < 0) {
            if (tc.isErrorEnabled()) {
                Tr.error((TraceComponent)tc, (String)"Illegal.Argument.Trying.to.write.chars", (Object[])new Object[0]);
            }
            throw new IllegalArgumentException();
        }
        if (!this._hasWritten && this.obs != null) {
            this._hasWritten = true;
            this.obs.alertFirstWrite();
        }
        if (this.limit > -1 && this.total + len > this.limit) {
            len = this.limit - this.total;
            this.except = new WriteBeyondContentLengthException();
        }
        int toWrite = 0;
        int amountWritten = 0;
        int remaining = 0;
        while (amountWritten != len) {
            this.checkList();
            toWrite = len - amountWritten;
            remaining = this.current.remaining();
            if (toWrite <= remaining) {
                this.current.put(buf, offset + amountWritten, toWrite);
                amountWritten += toWrite;
                continue;
            }
            this.current.put(buf, offset + amountWritten, remaining);
            amountWritten += remaining;
        }
        this.count += len;
        this.total += len;
        this.check();
    }

    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    private void checkList() {
        if (this.current == null) {
            this.current = this.getNewByteBuffer();
            this.bbList.add(this.current);
        } else {
            if (this.current.hasRemaining()) {
                return;
            }
            this.current.flip();
            this.current = this.getNewByteBuffer();
            this.bbList.add(this.current);
        }
    }

    private WsByteBuffer getNewByteBuffer() {
        return ChannelFrameworkFactory.getBufferManager().allocateDirect(this.bufferSize);
    }

    public void writeTo(OutputStream os) {
        try {
            for (WsByteBuffer bb : this.bbList) {
                byte[] b = new byte[bb.limit()];
                bb.get(b);
                os.write(b);
            }
        }
        catch (IOException ioe) {
            FFDCFilter.processException((Throwable)ioe, (String)(this.getClass().getName() + ".writeTo"), (String)"247");
        }
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream arrayOS = new ByteArrayOutputStream();
        this.writeTo(arrayOS);
        return arrayOS.toByteArray();
    }

    @Override
    public void clearBuffer() {
        if (this.isCommitted()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"clearBuffer(): illegal state--> stream is committed ", (Object[])new Object[0]);
            }
            throw new IllegalStateException("clearBuffer(): illegal state--> stream is committed ");
        }
        ListIterator<WsByteBuffer> it = this.bbList.listIterator();
        while (it.hasNext()) {
            WsByteBuffer next = it.next();
            next.release();
            it.remove();
        }
        this.total = 0;
        this.count = 0;
        this._hasWritten = false;
    }

    @Override
    public void flushBuffer() throws IOException {
        if (this.current != null && this.current.position() != 0) {
            this.current.flip();
        }
        this.commit();
    }

    @Override
    public int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public void init(OutputStream out, int bufferSize) {
        this.bufferSize = bufferSize;
    }

    @Override
    public boolean isCommitted() {
        if (!this.committed) {
            this.committed = this.total >= this.bufferSize;
        }
        return this.committed;
    }

    @Override
    public void setBufferSize(int size) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setBufferSize --> " + size), (Object[])new Object[0]);
        }
        if (this.total > 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("setBufferSize(): illegal state--> already wrote " + this.total + " bytes"), (Object[])new Object[0]);
            }
            throw new IllegalStateException(nls.getString("Cannot.set.buffer.size.after.data", "Can't set buffer size after data has been written to stream"));
        }
        this.clearBuffer();
    }

    @Override
    public void setLimit(int contentLength) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setLimit(): contentLength->" + contentLength), (Object[])new Object[0]);
        }
        this.limit = contentLength;
    }

    @Override
    public void setObserver(IOutputStreamObserver obs) {
        this.obs = obs;
    }

    @Override
    public void setResponse(IResponse response) {
        this.response = response;
    }

    public void flush() throws IOException {
        this.commit();
    }

    private void commit() {
        this.committed = true;
    }

    protected void check() throws IOException {
        if (this.except != null) {
            this.flush();
            throw this.except;
        }
    }

    @Override
    public int getTotal() {
        return this.total;
    }

    @Override
    public void addObserver(IOutputStreamObserver obs) {
    }
}

