/*
 * Decompiled with CFR 0.152.
 */
package javax.el;

import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.el.MethodNotFoundException;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;

public class BeanELResolver
extends ELResolver {
    private static final int CACHE_SIZE = System.getSecurityManager() == null ? Integer.parseInt(System.getProperty("org.apache.el.BeanELResolver.CACHE_SIZE", "1000")) : AccessController.doPrivileged(new PrivilegedAction<Integer>(){

        @Override
        public Integer run() {
            return Integer.valueOf(System.getProperty(BeanELResolver.CACHE_SIZE_PROP, "1000"));
        }
    });
    private static final String CACHE_SIZE_PROP = "org.apache.el.BeanELResolver.CACHE_SIZE";
    private final boolean readOnly;
    private final ConcurrentCache<String, BeanProperties> cache = new ConcurrentCache(CACHE_SIZE);

    public BeanELResolver() {
        this.readOnly = false;
    }

    public BeanELResolver(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public Object getValue(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null || property == null) {
            return null;
        }
        context.setPropertyResolved(true);
        Method m = this.property(context, base, property).read(context);
        try {
            return m.invoke(base, (Object[])null);
        }
        catch (IllegalAccessException e) {
            throw new ELException(e);
        }
        catch (InvocationTargetException e) {
            throw new ELException(BeanELResolver.message(context, "propertyReadError", new Object[]{base.getClass().getName(), property.toString()}), e.getCause());
        }
        catch (Exception e) {
            throw new ELException(e);
        }
    }

    @Override
    public Class<?> getType(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null || property == null) {
            return null;
        }
        context.setPropertyResolved(true);
        return this.property(context, base, property).getPropertyType();
    }

    @Override
    public void setValue(ELContext context, Object base, Object property, Object value) throws NullPointerException, PropertyNotFoundException, PropertyNotWritableException, ELException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null || property == null) {
            return;
        }
        context.setPropertyResolved(true);
        if (this.readOnly) {
            throw new PropertyNotWritableException(BeanELResolver.message(context, "resolverNotWriteable", new Object[]{base.getClass().getName()}));
        }
        if (this.property(context, base, property).isReadOnly()) {
            throw new PropertyNotWritableException(BeanELResolver.message(context, "propertyNotWritable", new Object[]{base.getClass().getName(), property}));
        }
        Method m = this.property(context, base, property).write(context);
        try {
            m.invoke(base, value);
        }
        catch (IllegalAccessException e) {
            throw new ELException(e);
        }
        catch (InvocationTargetException e) {
            throw new ELException(BeanELResolver.message(context, "propertyWriteError", new Object[]{base.getClass().getName(), property.toString()}), e.getCause());
        }
        catch (Exception e) {
            throw new ELException(e);
        }
    }

    @Override
    public boolean isReadOnly(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null || property == null) {
            return false;
        }
        context.setPropertyResolved(true);
        return this.readOnly || this.property(context, base, property).isReadOnly();
    }

    @Override
    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null) {
            return null;
        }
        try {
            BeanInfo info = Introspector.getBeanInfo(base.getClass());
            PropertyDescriptor[] pds = info.getPropertyDescriptors();
            for (int i = 0; i < pds.length; ++i) {
                pds[i].setValue("resolvableAtDesignTime", Boolean.TRUE);
                pds[i].setValue("type", pds[i].getPropertyType());
            }
            return Arrays.asList((FeatureDescriptor[])pds).iterator();
        }
        catch (IntrospectionException introspectionException) {
            return null;
        }
    }

    @Override
    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base != null) {
            return Object.class;
        }
        return null;
    }

    private final BeanProperty property(ELContext ctx, Object base, Object property) {
        Class<?> type = base.getClass();
        String prop = property.toString();
        BeanProperties props = this.cache.get(type.getName());
        if (props == null || type != props.getType()) {
            props = new BeanProperties(type);
            this.cache.put(new String(type.getName()), props);
        }
        return props.get(ctx, prop);
    }

    private static final Method getMethod(Class<?> type, Method m) {
        if (m == null || Modifier.isPublic(type.getModifiers())) {
            return m;
        }
        Class<?>[] inf = type.getInterfaces();
        Method mp = null;
        for (int i = 0; i < inf.length; ++i) {
            try {
                mp = inf[i].getMethod(m.getName(), m.getParameterTypes());
                mp = BeanELResolver.getMethod(mp.getDeclaringClass(), mp);
                if (mp == null) continue;
                return mp;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        Class<?> sup = type.getSuperclass();
        if (sup != null) {
            try {
                mp = sup.getMethod(m.getName(), m.getParameterTypes());
                mp = BeanELResolver.getMethod(mp.getDeclaringClass(), mp);
                if (mp != null) {
                    return mp;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Object invoke(ELContext context, Object base, Object method, Class<?>[] paramTypes, Object[] params) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null || method == null) {
            return null;
        }
        ExpressionFactory factory = ExpressionFactory.newInstance();
        String methodName = (String)factory.coerceToType(method, String.class);
        Method matchingMethod = null;
        Class<?> clazz = base.getClass();
        if (paramTypes != null) {
            try {
                matchingMethod = clazz.getMethod(methodName, paramTypes);
            }
            catch (NoSuchMethodException e) {
                throw new MethodNotFoundException(e);
            }
        } else {
            Method[] methods;
            int paramCount = 0;
            if (params != null) {
                paramCount = params.length;
            }
            for (Method m : methods = clazz.getMethods()) {
                if (methodName.equals(m.getName()) && m.getParameterTypes().length == paramCount) {
                    matchingMethod = m;
                    break;
                }
                if (!m.isVarArgs()) continue;
                matchingMethod = m;
            }
            if (matchingMethod == null) {
                throw new MethodNotFoundException("Unable to find method [" + methodName + "] with [" + paramCount + "] parameters");
            }
        }
        Class<?>[] parameterTypes = matchingMethod.getParameterTypes();
        Object[] parameters = null;
        if (parameterTypes.length > 0) {
            parameters = new Object[parameterTypes.length];
            int paramCount = params.length;
            if (matchingMethod.isVarArgs()) {
                int varArgIndex = parameterTypes.length - 1;
                for (int i = 0; i < varArgIndex - 1; ++i) {
                    parameters[i] = factory.coerceToType(params[i], parameterTypes[i]);
                }
                Class<?> varArgClass = parameterTypes[varArgIndex].getComponentType();
                for (int i = varArgIndex; i < paramCount; ++i) {
                    Object varargs = Array.newInstance(parameterTypes[paramCount], paramCount - varArgIndex);
                    Array.set(varargs, i, factory.coerceToType(params[i], varArgClass));
                    parameters[varArgIndex] = varargs;
                }
            } else {
                parameters = new Object[parameterTypes.length];
                for (int i = 0; i < parameterTypes.length; ++i) {
                    parameters[i] = factory.coerceToType(params[i], parameterTypes[i]);
                }
            }
        }
        matchingMethod = BeanELResolver.getMethod(clazz, matchingMethod);
        Object result = null;
        try {
            result = matchingMethod.invoke(base, parameters);
        }
        catch (IllegalArgumentException e) {
            throw new ELException(e);
        }
        catch (IllegalAccessException e) {
            throw new ELException(e);
        }
        catch (InvocationTargetException e) {
            throw new ELException(e.getCause());
        }
        context.setPropertyResolved(true);
        return result;
    }

    private static final class ConcurrentCache<K, V> {
        private final int size;
        private final Map<K, V> eden;
        private final Map<K, V> longterm;

        public ConcurrentCache(int size) {
            this.size = size;
            this.eden = new ConcurrentHashMap(size);
            this.longterm = new WeakHashMap(size);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public V get(K key) {
            V value = this.eden.get(key);
            if (value == null) {
                Map<K, V> map = this.longterm;
                synchronized (map) {
                    value = this.longterm.get(key);
                }
                if (value != null) {
                    this.eden.put(key, value);
                }
            }
            return value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(K key, V value) {
            if (this.eden.size() >= this.size) {
                Map<K, V> map = this.longterm;
                synchronized (map) {
                    this.longterm.putAll(this.eden);
                }
                this.eden.clear();
            }
            this.eden.put(key, value);
        }
    }

    protected static final class BeanProperty {
        private final Class<?> type;
        private final Class<?> owner;
        private final PropertyDescriptor descriptor;
        private Method read;
        private Method write;

        public BeanProperty(Class<?> owner, PropertyDescriptor descriptor) {
            this.owner = owner;
            this.descriptor = descriptor;
            this.type = descriptor.getPropertyType();
        }

        public Class getPropertyType() {
            return this.type;
        }

        public boolean isReadOnly() {
            return this.write == null && null == (this.write = BeanELResolver.getMethod(this.owner, this.descriptor.getWriteMethod()));
        }

        public Method getWriteMethod() {
            return this.write(null);
        }

        public Method getReadMethod() {
            return this.read(null);
        }

        private Method write(ELContext ctx) {
            if (this.write == null) {
                this.write = BeanELResolver.getMethod(this.owner, this.descriptor.getWriteMethod());
                if (this.write == null) {
                    throw new PropertyNotFoundException(ELResolver.message(ctx, "propertyNotWritable", new Object[]{this.type.getName(), this.descriptor.getName()}));
                }
            }
            return this.write;
        }

        private Method read(ELContext ctx) {
            if (this.read == null) {
                this.read = BeanELResolver.getMethod(this.owner, this.descriptor.getReadMethod());
                if (this.read == null) {
                    throw new PropertyNotFoundException(ELResolver.message(ctx, "propertyNotReadable", new Object[]{this.type.getName(), this.descriptor.getName()}));
                }
            }
            return this.read;
        }
    }

    protected static final class BeanProperties {
        private final Map<String, BeanProperty> properties;
        private final Class<?> type;

        public BeanProperties(Class<?> type) throws ELException {
            this.type = type;
            this.properties = new HashMap<String, BeanProperty>();
            try {
                PropertyDescriptor[] pds;
                BeanInfo info = Introspector.getBeanInfo(this.type);
                for (PropertyDescriptor pd : pds = info.getPropertyDescriptors()) {
                    this.properties.put(pd.getName(), new BeanProperty(type, pd));
                }
                if (System.getSecurityManager() != null) {
                    this.populateFromInterfaces(type);
                }
            }
            catch (IntrospectionException ie) {
                throw new ELException(ie);
            }
        }

        private void populateFromInterfaces(Class<?> aClass) throws IntrospectionException {
            Class<?> superclass;
            Class<?>[] interfaces = aClass.getInterfaces();
            if (interfaces.length > 0) {
                for (Class<?> ifs : interfaces) {
                    PropertyDescriptor[] pds;
                    BeanInfo info = Introspector.getBeanInfo(ifs);
                    for (PropertyDescriptor pd : pds = info.getPropertyDescriptors()) {
                        if (this.properties.containsKey(pd.getName())) continue;
                        this.properties.put(pd.getName(), new BeanProperty(this.type, pd));
                    }
                }
            }
            if ((superclass = aClass.getSuperclass()) != null) {
                this.populateFromInterfaces(superclass);
            }
        }

        private BeanProperty get(ELContext ctx, String name) {
            BeanProperty property = this.properties.get(name);
            if (property == null) {
                throw new PropertyNotFoundException(ELResolver.message(ctx, "propertyNotFound", new Object[]{this.type.getName(), name}));
            }
            return property;
        }

        public BeanProperty getBeanProperty(String name) {
            return this.get(null, name);
        }

        private Class<?> getType() {
            return this.type;
        }
    }
}

