/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class NodeleteSynchronizedMap
implements Map {
    Map global;
    ThreadLocal local = new ThreadLocal(){

        public Object initialValue() {
            return NodeleteSynchronizedMap.this.initialValue();
        }
    };

    public NodeleteSynchronizedMap() {
        this.global = Collections.synchronizedMap(this.initialValue());
    }

    private Map localMap() {
        return (Map)this.local.get();
    }

    @Override
    public int size() {
        return this.global.size();
    }

    @Override
    public boolean isEmpty() {
        return this.global.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        Map local = this.localMap();
        if (local.containsKey(key)) {
            return true;
        }
        if (this.global.containsKey(key)) {
            local.put(key, this.global.get(key));
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object val) {
        Map local = this.localMap();
        if (local.containsValue(val)) {
            return true;
        }
        return this.global.containsValue(val);
    }

    public Object get(Object key) {
        Map local = this.localMap();
        Object val = local.get(key);
        if (val != null) {
            return val;
        }
        if (local.containsKey(key)) {
            return null;
        }
        val = this.global.get(key);
        if (val != null) {
            local.put(key, val);
        }
        return val;
    }

    @Override
    public boolean equals(Object other) {
        return this.global.equals(other);
    }

    @Override
    public int hashCode() {
        return this.global.hashCode();
    }

    public Set keySet() {
        return this.global.keySet();
    }

    public Collection values() {
        return this.global.values();
    }

    public Set entrySet() {
        return this.global.entrySet();
    }

    public Object put(Object key, Object val) {
        return this.global.put(key, val);
    }

    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map other) {
        this.global.putAll(other);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Map initialValue() {
        return new HashMap();
    }
}

