/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.impl;

import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.rmi.CORBA.Util;
import org.apache.yoko.rmi.impl.ObjectReader;
import org.apache.yoko.rmi.impl.ObjectWriter;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.portable.ValueOutputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

public final class CorbaObjectWriter
extends ObjectWriter {
    static Logger logger = Logger.getLogger(CorbaObjectWriter.class.getName());
    final OutputStream out;

    CorbaObjectWriter(org.omg.CORBA.portable.OutputStream out, Serializable obj) throws IOException {
        super(obj);
        this.out = (OutputStream)out;
    }

    @Override
    public void write(int val) throws IOException {
        this.beforeWriteData();
        this.out.write_octet((byte)val);
    }

    @Override
    public void write(byte[] val) throws IOException {
        this.beforeWriteData();
        this.write(val, 0, val.length);
    }

    @Override
    public void write(byte[] arr, int off, int len) throws IOException {
        this.beforeWriteData();
        this.out.write_octet_array(arr, off, len);
    }

    @Override
    public void writeBoolean(boolean val) throws IOException {
        this.beforeWriteData();
        this.out.write_boolean(val);
    }

    @Override
    public void writeByte(int val) throws IOException {
        this.beforeWriteData();
        this.out.write_octet((byte)val);
    }

    @Override
    public void writeShort(int val) throws IOException {
        this.beforeWriteData();
        this.out.write_short((short)val);
    }

    @Override
    public void writeChar(int val) throws IOException {
        this.beforeWriteData();
        this.out.write_wchar((char)val);
    }

    @Override
    public void writeInt(int val) throws IOException {
        this.beforeWriteData();
        this.out.write_long(val);
    }

    @Override
    public void writeLong(long val) throws IOException {
        this.beforeWriteData();
        this.out.write_longlong(val);
    }

    @Override
    public void writeFloat(float val) throws IOException {
        this.beforeWriteData();
        this.out.write_float(val);
    }

    @Override
    public void writeDouble(double val) throws IOException {
        this.beforeWriteData();
        this.out.write_double(val);
    }

    @Override
    public void writeBytes(String val) throws IOException {
        for (int i = 0; i < val.length(); ++i) {
            this.writeByte(val.charAt(i));
        }
    }

    @Override
    public void writeChars(String val) throws IOException {
        for (int i = 0; i < val.length(); ++i) {
            this.writeChar(val.charAt(i));
        }
    }

    @Override
    public void writeUTF(String val) throws IOException {
        this.beforeWriteData();
        this.out.write_wstring(val);
    }

    @Override
    public void writeObjectOverride(Object obj) throws IOException {
        this.beforeWriteData();
        try {
            Util.writeAbstractObject((org.omg.CORBA.portable.OutputStream)this.out, (Object)obj);
        }
        catch (Error err) {
            logger.log(Level.FINE, "exception in writeObjectOverride", err);
            throw err;
        }
    }

    @Override
    public void writeValueObject(Object obj) throws IOException {
        this.beforeWriteData();
        try {
            this.out.write_value((Serializable)obj);
        }
        catch (Error err) {
            logger.log(Level.FINE, "exception in writeValueObject", err);
            throw err;
        }
    }

    @Override
    public void writeCorbaObject(Object obj) throws IOException {
        this.beforeWriteData();
        Util.writeRemoteObject((org.omg.CORBA.portable.OutputStream)this.out, (Object)obj);
    }

    @Override
    public void writeRemoteObject(Object obj) throws IOException {
        this.beforeWriteData();
        Util.writeRemoteObject((org.omg.CORBA.portable.OutputStream)this.out, (Object)obj);
    }

    @Override
    public void writeAny(Object obj) throws IOException {
        this.beforeWriteData();
        Util.writeAny((org.omg.CORBA.portable.OutputStream)this.out, (Object)obj);
    }

    @Override
    public ObjectReader getObjectReader(Object newObject) {
        throw new INTERNAL("cannot do this");
    }

    @Override
    protected void _startValue(String repID) throws IOException {
        ValueOutputStream vout = (ValueOutputStream)this.out;
        vout.start_value(repID);
    }

    @Override
    protected void _endValue() throws IOException {
        ValueOutputStream vout = (ValueOutputStream)this.out;
        vout.end_value();
    }

    @Override
    protected void _nullValue() throws IOException {
        this.out.write_long(0);
    }
}

