/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.impl;

import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.rmi.CORBA.ClassDesc;
import org.apache.yoko.rmi.impl.ClassBaseDescriptor;
import org.apache.yoko.rmi.impl.TypeRepository;
import org.apache.yoko.util.cmsf.RepIds;
import org.omg.CORBA.MARSHAL;

class ClassDescDescriptor
extends ClassBaseDescriptor {
    private static final Logger logger = Logger.getLogger(ClassDescDescriptor.class.getName());

    ClassDescDescriptor(TypeRepository repository) {
        super(ClassDesc.class, repository);
    }

    @Override
    public Serializable readResolve(Serializable value) {
        final ClassDesc desc = (ClassDesc)value;
        Class result = (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

            @Override
            public Class<?> run() {
                String className = "<unknown>";
                try {
                    String repid = (String)ClassDescDescriptor.this.getRepidField().get(desc);
                    String codebase = (String)ClassDescDescriptor.this.getCobebaseField().get(desc);
                    Class result = RepIds.query((String)repid).codebase(codebase).toClass();
                    if (null != result) {
                        return result;
                    }
                    throw new MARSHAL(String.format("Cannot load class \"%s\"", className));
                }
                catch (IllegalAccessException ex) {
                    throw (MARSHAL)new MARSHAL("no such field: " + ex).initCause((Throwable)ex);
                }
            }
        });
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(String.format("readResolve %s => %s", value, result));
        }
        return result;
    }
}

