/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.internal.asset;

import com.ibm.ws.install.InstallException;
import com.ibm.ws.install.internal.ArchiveUtils;
import com.ibm.ws.install.internal.InstallLogUtils;
import com.ibm.ws.install.internal.InstallUtils;
import com.ibm.ws.install.internal.asset.InstallAsset;
import com.ibm.ws.repository.resources.RepositoryResource;
import com.ibm.ws.repository.resources.SampleResource;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.jar.JarFile;

public class JarAsset
extends InstallAsset {
    public static final String JAR_EXT = ".jar";
    protected JarFile jar = null;
    protected String shortName = null;
    private SampleResource sampleResource = null;

    public JarAsset(File assetFile, boolean temporary) throws InstallException {
        super(assetFile, temporary);
        try {
            this.jar = new JarFile(assetFile);
        }
        catch (IOException e) {
            throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_UNABLE_READ_FILE", this.getAsset().getAbsoluteFile(), e.getMessage()), e, 21);
        }
    }

    public JarAsset(String id, File assetFile, boolean isTemporary) throws InstallException {
        super(id, assetFile, isTemporary);
        if (assetFile != null) {
            try {
                this.jar = new JarFile(assetFile);
            }
            catch (IOException e) {
                throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_UNABLE_READ_FILE", this.getAsset().getAbsoluteFile(), e.getMessage()), e, 21);
            }
        }
    }

    public JarAsset(String id, String shortName, File assetFile, boolean isTemporary) throws InstallException {
        this(id, assetFile, isTemporary);
        this.shortName = shortName;
    }

    public JarAsset(SampleResource sampleResource) throws InstallException {
        this(sampleResource.getName(), null, true);
        this.shortName = sampleResource.getShortName();
        this.sampleResource = sampleResource;
    }

    @Override
    public void delete() {
        InstallUtils.close(this.jar);
        super.delete();
    }

    public JarFile getJar() {
        return this.jar;
    }

    public String getJarPath() {
        return this.getAsset().getAbsolutePath();
    }

    public String getShortName() {
        return this.shortName;
    }

    protected ArchiveUtils.ArchiveContentType getArchiveContentType(Map<String, String> manifestAttrs) {
        String archiveContentType = manifestAttrs.get("Archive-Content-Type");
        if (ArchiveUtils.ArchiveContentType.INSTALL.isContentType(archiveContentType)) {
            return ArchiveUtils.ArchiveContentType.INSTALL;
        }
        if (ArchiveUtils.ArchiveContentType.SAMPLE.isContentType(archiveContentType)) {
            return ArchiveUtils.ArchiveContentType.SAMPLE;
        }
        if (ArchiveUtils.ArchiveContentType.ADDON.isContentType(archiveContentType)) {
            return ArchiveUtils.ArchiveContentType.ADDON;
        }
        if (ArchiveUtils.ArchiveContentType.OPENSOURCE.isContentType(archiveContentType)) {
            return ArchiveUtils.ArchiveContentType.OPENSOURCE;
        }
        return null;
    }

    @Override
    public String toString() {
        return this.shortName == null ? this.name : this.shortName;
    }

    @Override
    public RepositoryResource getRepositoryResource() {
        return this.sampleResource;
    }

    @Override
    public void download(File installTempDir) throws InstallException {
        if (this.sampleResource == null) {
            return;
        }
        this.asset = this.download(installTempDir, (RepositoryResource)this.sampleResource);
        if (this.asset != null) {
            try {
                this.jar = new JarFile(this.asset);
            }
            catch (IOException e) {
                throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_UNABLE_READ_FILE", this.getAsset().getAbsoluteFile(), e.getMessage()), e, 21);
            }
        }
    }

    @Override
    public void cleanup() {
        if (this.sampleResource == null) {
            return;
        }
        this.delete();
        this.jar = null;
        this.asset = null;
    }
}

