/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.internal;

import com.ibm.ws.install.InstallException;
import com.ibm.ws.install.internal.ArtifactDownloaderUtils;
import com.ibm.ws.install.internal.ExceptionUtils;
import com.ibm.ws.install.internal.InstallLogUtils;
import com.ibm.ws.install.internal.MavenRepository;
import com.ibm.ws.install.internal.ProgressBar;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class ArtifactDownloader {
    private final int PROGRESS_CHUNK = 500000;
    private final int BUFFER_SIZE = 10000;
    private final String appName = "artifactDownloader";
    private final String appVersion = "1.0.0";
    private final List<File> downloadedFiles = new ArrayList<File>();
    private final Logger logger = InstallLogUtils.getInstallLogger();
    private final ProgressBar progressBar = ProgressBar.getInstance();
    private static Map<String, Object> envMap = null;

    public void synthesizeAndDownloadFeatures(List<String> mavenCoords, String dLocation, MavenRepository repository) throws InstallException {
        List<String> missingFeatures;
        this.info(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_CONTACTING_MAVEN_REPO", new Object[0]));
        this.checkValidProxy();
        this.configureProxyAuthentication();
        this.configureAuthentication(repository);
        this.downloadedFiles.clear();
        String repo = this.FormatUrlSuffix(repository.getRepositoryUrl());
        List<String> featureURLs = ArtifactDownloaderUtils.acquireFeatureURLs(mavenCoords, repo);
        dLocation = this.FormatPathSuffix(dLocation);
        try {
            int responseCode = ArtifactDownloaderUtils.exists(featureURLs.get(0), envMap);
            if (responseCode != 404) {
                ArtifactDownloaderUtils.checkResponseCode(responseCode, repo);
            }
        }
        catch (IOException e) {
            this.fine(e.getMessage());
            throw ExceptionUtils.createByKey("ERROR_FAILED_TO_CONNECT_MAVEN", new Object[0]);
        }
        this.updateProgress(this.progressBar.getMethodIncrement("establishConnection"));
        this.info(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_MAVEN_REPO_CONNECTION_SUCCESSFUL", new Object[0]));
        try {
            missingFeatures = ArtifactDownloaderUtils.getMissingFiles(featureURLs, envMap);
        }
        catch (IOException e) {
            throw new InstallException(e.getMessage());
        }
        if (!missingFeatures.isEmpty()) {
            ArrayList<String> missingFeatureList = new ArrayList<String>();
            for (String f : missingFeatures) {
                if (f.endsWith(".esa")) {
                    missingFeatureList.add(ArtifactDownloaderUtils.getFileNameFromURL(f) + ".esa");
                    continue;
                }
                if (!f.endsWith(".pom")) continue;
                missingFeatureList.add(ArtifactDownloaderUtils.getFileNameFromURL(f) + ".pom");
            }
            this.fine("The remote repository is missing the following artifacts: " + ((Object)missingFeatureList).toString());
            throw ExceptionUtils.createByKey("ERROR_FAILED_TO_DOWNLOAD_ASSETS_FROM_REPO", "required", "feature(s)", repo);
        }
        double individualSize = this.progressBar.getMethodIncrement("downloadArtifacts") / (double)mavenCoords.size();
        this.progressBar.updateMethodMap("downloadArtifact", individualSize);
        this.logger.info(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getMessage("MSG_BEGINNING_DOWNLOAD_FEATURES", new Object[0]));
        for (String coords : mavenCoords) {
            this.synthesizeAndDownload(coords, "esa", dLocation, repository, false);
            this.synthesizeAndDownload(coords, "pom", dLocation, repository, false);
            this.updateProgress(individualSize);
            this.progressBar.updateMethodMap("downloadArtifacts", this.progressBar.getMethodIncrement("downloadArtifacts") - individualSize);
            this.progressBar.manuallyUpdate();
            this.fine("Finished downloading artifact: " + coords);
        }
    }

    private String FormatPathSuffix(String path) {
        String result = path;
        if (!path.endsWith(File.separator)) {
            result = result + File.separator;
        }
        return result;
    }

    private String FormatUrlSuffix(String url) {
        String result = url;
        if (!url.endsWith("/")) {
            result = result + "/";
        }
        return result;
    }

    public void synthesizeAndDownload(String mavenCoords, String filetype, String dLocation, MavenRepository repository, boolean individualDownload) throws InstallException {
        this.configureProxyAuthentication();
        this.configureAuthentication(repository);
        String repo = this.FormatUrlSuffix(repository.getRepositoryUrl());
        dLocation = this.FormatPathSuffix(dLocation);
        String groupId = ArtifactDownloaderUtils.getGroupId(mavenCoords).replace(".", "/") + "/";
        String artifactId = ArtifactDownloaderUtils.getartifactId(mavenCoords);
        String version = ArtifactDownloaderUtils.getVersion(mavenCoords);
        new File(dLocation + groupId + artifactId + "/" + version + "/").mkdirs();
        String filename = ArtifactDownloaderUtils.getfilename(mavenCoords, filetype);
        String urlLocation = ArtifactDownloaderUtils.getUrlLocation(repo, groupId, artifactId, version, filename);
        if (individualDownload) {
            this.checkValidProxy();
            try {
                int repoResponseCode = ArtifactDownloaderUtils.exists(urlLocation, envMap);
                if (repoResponseCode != 404) {
                    ArtifactDownloaderUtils.checkResponseCode(repoResponseCode, repo);
                }
            }
            catch (Exception e) {
                this.fine(e.getMessage());
                throw ExceptionUtils.createByKey("ERROR_FAILED_TO_CONNECT_MAVEN", new Object[0]);
            }
        }
        String[] checksumFormats = new String[]{"SHA256", "MD5", "SHA1"};
        try {
            if (individualDownload && ArtifactDownloaderUtils.fileIsMissing(urlLocation, envMap)) {
                throw ExceptionUtils.createByKey("ERROR_FAILED_TO_DOWNLOAD_ASSETS_FROM_REPO", ArtifactDownloaderUtils.getFileNameFromURL(urlLocation), filetype + " file", repo);
            }
            this.download(urlLocation, dLocation, groupId, artifactId, version, filename, checksumFormats, repository);
        }
        catch (IOException e) {
            throw new InstallException(e.getMessage());
        }
    }

    private void download(String urlLocation, String dLocation, String groupId, String artifactId, String version, String filename, String[] checksumFormats, MavenRepository mavenRepository) throws IOException, InstallException {
        try {
            URI uriLoc = new URI(urlLocation);
            File fileLoc = new File(ArtifactDownloaderUtils.getFileLocation(dLocation, groupId, artifactId, version, filename));
            this.downloadInternal(uriLoc, fileLoc, mavenRepository);
            this.downloadedFiles.add(fileLoc);
            boolean someChecksumExists = false;
            boolean checksumFail = false;
            boolean checksumSuccess = false;
            for (String checksumFormat : checksumFormats) {
                if (checksumSuccess) continue;
                if (this.checksumIsAvailable(urlLocation, checksumFormat)) {
                    someChecksumExists = true;
                    if (this.isIncorrectChecksum(fileLoc.getAbsolutePath(), urlLocation, checksumFormat)) {
                        this.fine("Failed to validate " + checksumFormat + " checksum for file: " + filename);
                        checksumFail = true;
                        continue;
                    }
                    checksumSuccess = true;
                    this.fine("Successfully validated " + checksumFormat + " checksum for file: " + filename);
                    continue;
                }
                this.fine("Failed to find " + checksumFormat + " checksum for file: " + filename);
            }
            if (someChecksumExists) {
                if (checksumFail) {
                    ArtifactDownloaderUtils.deleteFiles(this.downloadedFiles, dLocation, groupId, artifactId, version, filename);
                    this.downloadedFiles.clear();
                    throw ExceptionUtils.createByKey("ERROR_CHECKSUM_FAILED_MAVEN", filename);
                }
            } else {
                this.fine("No checksums found for file in remote repository");
            }
        }
        catch (URISyntaxException e) {
            throw new InstallException(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            throw new InstallException(e.getMessage());
        }
    }

    private boolean checksumIsAvailable(String urlLocation, String checksumFormat) {
        boolean result = true;
        try {
            ArtifactDownloaderUtils.getMasterChecksum(urlLocation, checksumFormat);
        }
        catch (IOException e) {
            result = false;
        }
        return result;
    }

    private boolean isIncorrectChecksum(String localFile, String urlLocation, String checksumFormat) throws NoSuchAlgorithmException {
        String checksumOrigin;
        String checksumLocal;
        boolean result = false;
        try {
            checksumLocal = ArtifactDownloaderUtils.getChecksum(localFile, checksumFormat);
        }
        catch (IOException e) {
            return true;
        }
        try {
            checksumOrigin = ArtifactDownloaderUtils.getMasterChecksum(urlLocation, checksumFormat);
        }
        catch (IOException e) {
            return true;
        }
        if (!checksumLocal.equals(checksumOrigin)) {
            result = true;
        }
        return result;
    }

    private void configureProxyAuthentication() {
        if (envMap.get("https.proxyUser") != null) {
            Authenticator.setDefault(new SystemPropertiesProxyAuthenticator());
        }
    }

    private void configureAuthentication(final MavenRepository repository) {
        if (repository.getUserId() != null && repository.getPassword() != null && envMap.get("https.proxyUser") == null) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(repository.getUserId(), repository.getPassword().toCharArray());
                }
            });
        }
    }

    protected boolean testConnection(MavenRepository repository, List<String> mavenCoords) {
        this.configureProxyAuthentication();
        this.configureAuthentication(repository);
        List<String> featureURLs = ArtifactDownloaderUtils.acquireFeatureURLs(mavenCoords, repository.getRepositoryUrl());
        try {
            int responseCode = ArtifactDownloaderUtils.exists(featureURLs.get(0), envMap);
            this.logger.fine("Response code: " + responseCode);
            if (responseCode != 404) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    protected boolean testConnection(MavenRepository repository) {
        this.configureProxyAuthentication();
        this.configureAuthentication(repository);
        try {
            int responseCode = ArtifactDownloaderUtils.exists(repository.getRepositoryUrl(), envMap);
            this.logger.fine("Response code: " + responseCode);
            if (responseCode != 404) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadInternal(URI address, File destination, MavenRepository repository) throws IOException, InstallException {
        OutputStream out = null;
        InputStream in = null;
        try {
            int numRead;
            URLConnection conn;
            Proxy proxy;
            URL url = address.toURL();
            try {
                out = new BufferedOutputStream(new FileOutputStream(destination));
            }
            catch (FileNotFoundException e) {
                throw ExceptionUtils.createByKey("ERROR_FAILED_TO_DOWNLOAD_FEATURE", ArtifactDownloaderUtils.getFileNameFromURL(address.toString()), destination.toString());
            }
            if (envMap.get("https.proxyUser") != null) {
                proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress((String)envMap.get("https.proxyHost"), Integer.parseInt((String)envMap.get("https.proxyPort"))));
                conn = url.openConnection(proxy);
            } else if (envMap.get("http.proxyUser") != null) {
                proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress((String)envMap.get("http.proxyHost"), Integer.parseInt((String)envMap.get("http.proxyPort"))));
                conn = url.openConnection(proxy);
            } else {
                conn = url.openConnection();
            }
            this.addBasicAuthentication(address, conn, repository);
            String userAgentValue = this.calculateUserAgent();
            conn.setRequestProperty("User-Agent", userAgentValue);
            conn.connect();
            in = conn.getInputStream();
            byte[] buffer = new byte[10000];
            long progressCounter = 0L;
            while ((numRead = in.read(buffer)) != -1) {
                if ((progressCounter += (long)numRead) / 500000L > 0L) {
                    progressCounter -= 500000L;
                }
                out.write(buffer, 0, numRead);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    private String calculateUserAgent() {
        String javaVendor = System.getProperty("java.vendor");
        String javaVersion = System.getProperty("java.version");
        String javaVendorVersion = System.getProperty("java.vm.version");
        String osName = System.getProperty("os.name");
        String osVersion = System.getProperty("os.version");
        String osArch = System.getProperty("os.arch");
        return String.format("%s/%s (%s;%s;%s) (%s;%s;%s)", "artifactDownloader", "1.0.0", osName, osVersion, osArch, javaVendor, javaVersion, javaVendorVersion);
    }

    private void addBasicAuthentication(URI address, URLConnection conn, MavenRepository repository) throws IOException {
        String userInfo = this.calculateUserInfo(address, repository);
        if (userInfo == null) {
            return;
        }
        conn.setRequestProperty("Authorization", "Basic " + this.base64Encode(userInfo));
    }

    private String base64Encode(String userInfo) {
        try {
            return Base64.getEncoder().encodeToString(userInfo.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException encodingException) {
            throw new RuntimeException("Failed to get bytes for user info using UTF-8.", encodingException);
        }
    }

    private String calculateUserInfo(URI uri, MavenRepository repository) {
        if (repository.getUserId() != null && repository.getPassword() != null) {
            return repository.getUserId() + ":" + repository.getPassword();
        }
        return uri.getUserInfo();
    }

    public List<File> getDownloadedEsas() {
        ArrayList<File> esaFiles = new ArrayList<File>();
        for (File f : this.downloadedFiles) {
            if (!f.getName().endsWith(".esa")) continue;
            esaFiles.add(f);
        }
        return esaFiles;
    }

    public List<File> getDownloadedPoms() {
        ArrayList<File> pomFiles = new ArrayList<File>();
        for (File f : this.downloadedFiles) {
            if (!f.getName().endsWith(".pom")) continue;
            pomFiles.add(f);
        }
        return pomFiles;
    }

    public List<File> getDownloadedFiles() {
        return this.downloadedFiles;
    }

    public void checkValidProxy() throws InstallException {
        String proxyPort = (String)envMap.get("https.proxyPort");
        if (envMap.get("https.proxyUser") != null) {
            int proxyPortnum = Integer.parseInt(proxyPort);
            if (((String)envMap.get("https.proxyHost")).isEmpty()) {
                throw ExceptionUtils.createByKey("ERROR_TOOL_PROXY_HOST_MISSING", new Object[0]);
            }
            if (proxyPortnum < 0 || proxyPortnum > 65535) {
                throw ExceptionUtils.createByKey("ERROR_TOOL_INVALID_PROXY_PORT", proxyPort);
            }
            if (((String)envMap.get("https.proxyPassword")).isEmpty() || envMap.get("https.proxyPassword") == null) {
                throw ExceptionUtils.createByKey("ERROR_TOOL_PROXY_PWD_MISSING", new Object[0]);
            }
        }
    }

    private void updateProgress(double increment) {
        this.progressBar.updateProgress(increment);
    }

    public void setEnvMap(Map<String, Object> envMap) {
        ArtifactDownloader.envMap = envMap;
    }

    public Map<String, Object> getEnvMap() {
        return envMap;
    }

    private void info(String msg) {
        this.logger.info(msg);
    }

    private void fine(String msg) {
        this.logger.fine(msg);
    }

    private void severe(String msg) {
        this.logger.severe(msg);
    }

    private static class SystemPropertiesProxyAuthenticator
    extends Authenticator {
        private SystemPropertiesProxyAuthenticator() {
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication((String)envMap.get("https.proxyUser"), ((String)envMap.get("https.proxyPassword")).toCharArray());
        }
    }
}

