/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.grpc.internal.monitor;

import io.grpc.ForwardingServerCall;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.Status;
import io.openliberty.grpc.internal.monitor.GrpcMethod;
import io.openliberty.grpc.internal.monitor.GrpcServerStatsMonitor;
import java.time.Clock;
import java.time.Instant;

public class GrpcMonitoringServerCall<R, S>
extends ForwardingServerCall.SimpleForwardingServerCall<R, S> {
    private final Clock clock;
    private final GrpcMethod grpcMethod;
    private final GrpcServerStatsMonitor serverMetrics;
    private final Instant startInstant;

    GrpcMonitoringServerCall(ServerCall<R, S> delegate, Clock clock, GrpcMethod grpcMethod, GrpcServerStatsMonitor serverMetrics) {
        super(delegate);
        this.clock = clock;
        this.grpcMethod = grpcMethod;
        this.serverMetrics = serverMetrics;
        this.startInstant = clock.instant();
        this.reportStartMetrics();
    }

    public void close(Status status, Metadata responseHeaders) {
        this.reportEndMetrics(status);
        super.close(status, responseHeaders);
    }

    public void sendMessage(S message) {
        if (this.grpcMethod.clientSendsOneMessage()) {
            this.serverMetrics.recordMsgSent();
        }
        super.sendMessage(message);
    }

    private void reportStartMetrics() {
        this.serverMetrics.recordCallStarted();
    }

    private void reportEndMetrics(Status status) {
        long latencyMs = this.clock.millis() - this.startInstant.toEpochMilli();
        this.serverMetrics.recordLatency(latencyMs);
        this.serverMetrics.recordServerHandled();
    }
}

