/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.common.enums;

import com.ibm.ws.repository.common.enums.ResourceTypeLabel;

public enum ResourceType {
    PRODUCTSAMPLE(ResourceTypeLabel.PRODUCTSAMPLE, "com.ibm.websphere.ProductSample", "samples"),
    OPENSOURCE(ResourceTypeLabel.OPENSOURCE, "com.ibm.websphere.OpenSource", "opensource"),
    INSTALL(ResourceTypeLabel.INSTALL, "com.ibm.websphere.Install", "runtimes"),
    ADDON(ResourceTypeLabel.ADDON, "com.ibm.websphere.Addon", "addons"),
    FEATURE(ResourceTypeLabel.FEATURE, "com.ibm.websphere.Feature", "features"),
    IFIX(ResourceTypeLabel.IFIX, "com.ibm.websphere.Ifix", "ifixes"),
    ADMINSCRIPT(ResourceTypeLabel.ADMINSCRIPT, "com.ibm.websphere.AdminScript", "scripts"),
    CONFIGSNIPPET(ResourceTypeLabel.CONFIGSNIPPET, "com.ibm.websphere.ConfigSnippet", "snippets"),
    TOOL(ResourceTypeLabel.TOOL, "com.ibm.websphere.Tool", "tools");

    private final ResourceTypeLabel _typeLabel;
    private final String _type;
    private final String _nameForUrl;

    private ResourceType(ResourceTypeLabel label, String type, String nameForUrl) {
        this._typeLabel = label;
        this._type = type;
        this._nameForUrl = nameForUrl;
    }

    public ResourceTypeLabel getTypeLabel() {
        return this._typeLabel;
    }

    public String getURLForType() {
        return this._nameForUrl;
    }

    public String getValue() {
        return this._type;
    }

    public static ResourceType forValue(String value) {
        for (ResourceType ty : ResourceType.values()) {
            if (!ty.getValue().equals(value)) continue;
            return ty;
        }
        return null;
    }
}

