/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.rar.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.app.manager.AppMessageHelper;
import com.ibm.ws.app.manager.module.DeployedAppInfo;
import com.ibm.ws.app.manager.module.DeployedAppInfoFactory;
import com.ibm.ws.app.manager.rar.internal.RARDeployedAppInfo;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.threading.FutureMonitor;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.application.handler.ApplicationHandler;
import com.ibm.wsspi.application.handler.ApplicationInformation;
import com.ibm.wsspi.application.handler.ApplicationMonitoringInformation;
import com.ibm.wsspi.application.handler.DefaultApplicationMonitoringInformation;
import com.ibm.wsspi.application.lifecycle.ApplicationStartBarrier;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="_tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={ApplicationHandler.class}, property={"service.vendor=IBM", "type:String=rar"})
public class RARApplicationHandlerImpl
extends AppMessageHelper
implements ApplicationHandler<DeployedAppInfo> {
    private static final TraceComponent _tc = Tr.register(RARApplicationHandlerImpl.class, (String[])new String[]{"WAS.j2c", "applications", "app.manager"}, (String)"com.ibm.ws.app.manager.rar.internal.resources.Messages", (String)"com.ibm.ws.app.manager.rar.internal.RARApplicationHandlerImpl");
    private static final Map<String, String> MESSAGES = new HashMap<String, String>();
    private FutureMonitor futureMonitor;
    private DeployedAppInfoFactory deployedAppFactory;
    static final long serialVersionUID = 946480714296852020L;

    @Reference
    protected void setFutureMonitor(FutureMonitor fm) {
        this.futureMonitor = fm;
    }

    @Reference(target="(type=rar)")
    protected void setDeployedAppFactory(DeployedAppInfoFactory factory) {
        this.deployedAppFactory = factory;
    }

    public ApplicationMonitoringInformation setUpApplicationMonitoring(ApplicationInformation<DeployedAppInfo> applicationInformation) {
        return new DefaultApplicationMonitoringInformation(null, true);
    }

    /*
     * WARNING - void declaration
     */
    public Future<Boolean> install(ApplicationInformation<DeployedAppInfo> applicationInformation) {
        RARDeployedAppInfo deployedApp;
        Future result = this.futureMonitor.createFuture(Boolean.class);
        try {
            deployedApp = (RARDeployedAppInfo)this.deployedAppFactory.createDeployedAppInfo(applicationInformation);
        }
        catch (UnableToAdaptException unableToAdaptException) {
            void ex;
            FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.app.manager.rar.internal.RARApplicationHandlerImpl", (String)"93", (Object)((Object)this), (Object[])new Object[]{applicationInformation});
            this.futureMonitor.setResult(result, (Throwable)ex);
            return result;
        }
        if (!deployedApp.deployApp(result)) {
            this.futureMonitor.setResult(result, (Object)false);
            return result;
        }
        return result;
    }

    public Future<Boolean> uninstall(ApplicationInformation<DeployedAppInfo> applicationInformation) {
        RARDeployedAppInfo deployedApp = (RARDeployedAppInfo)((Object)applicationInformation.getHandlerInfo());
        if (deployedApp == null) {
            return this.futureMonitor.createFutureWithResult((Object)false);
        }
        boolean success = deployedApp.uninstallApp();
        return this.futureMonitor.createFutureWithResult((Object)success);
    }

    @Trivial
    public void audit(String key, Object ... params) {
        String newKey = MESSAGES.get(key);
        if (newKey == null) {
            super.audit(key, params);
        } else {
            Tr.audit((TraceComponent)_tc, (String)newKey, (Object[])params);
        }
    }

    @Trivial
    public void error(String key, Object ... params) {
        String newKey = MESSAGES.get(key);
        if (newKey == null) {
            super.error(key, params);
        } else {
            Tr.error((TraceComponent)_tc, (String)newKey, (Object[])params);
        }
    }

    @Trivial
    public void info(String key, Object ... params) {
        String newKey = MESSAGES.get(key);
        if (newKey == null) {
            super.info(key, params);
        } else {
            Tr.info((TraceComponent)_tc, (String)newKey, (Object[])params);
        }
    }

    @Trivial
    public void warning(String key, Object ... params) {
        String newKey = MESSAGES.get(key);
        if (newKey == null) {
            super.warning(key, params);
        } else {
            Tr.warning((TraceComponent)_tc, (String)newKey, (Object[])params);
        }
    }

    @Reference
    private void setApplicationStartBarrier(ApplicationStartBarrier applicationStartBarrier) {
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        MESSAGES.put("APPLICATION_START_SUCCESSFUL", "J2CA7001.adapter.install.successful");
        MESSAGES.put("APPLICATION_START_FAILED", "J2CA7002.adapter.install.failed");
        MESSAGES.put("APPLICATION_UPDATE_SUCCESSFUL", "J2CA7001.adapter.install.successful");
        MESSAGES.put("APPLICATION_UPDATE_FAILED", "J2CA7002.adapter.install.failed");
        MESSAGES.put("CANNOT_CREATE_DIRECTORY", "J2CA7006.cannot.create.directory");
        MESSAGES.put("APPLICATION_STOPPED", "J2CA7009.adapter.uninstalled");
        MESSAGES.put("APPLICATION_STOP_FAILED", "J2CA7010.adapter.uninstall.failed");
        MESSAGES.put("APPLICATION_NOT_STARTED", "J2CA7012.adapter.not.installed");
        MESSAGES.put("DUPLICATE_APPLICATION_NAME", "J2CA7013.duplicate.adapter.name");
        MESSAGES.put("APPLICATION_NOT_FOUND", "J2CA7014.adapter.not.found");
        MESSAGES.put("STARTING_APPLICATION", "J2CA7018.installing.adapter");
        MESSAGES.put("APPLICATION_NOT_UPDATED", "J2CA7020.adapter.not.updated");
        MESSAGES.put("APPLICATION_AT_LOCATION_NOT_VALID", "J2CA7021.adapter.at.location.not.valid");
        MESSAGES.put("APPLICATION_SLOW_STARTUP", "J2CA7022.adapter.slow.install");
        MESSAGES.put("MONITOR_APP_STOP_FAIL", "J2CA7053.monitor.adapter.uninstall.fail");
        MESSAGES.put("MONITOR_APP_START_FAIL", "J2CA7056.monitor.adapter.install.fail");
        MESSAGES.put("INVALID_DELETE_OF_APPLICATION", "J2CA7059.invalid.delete.of.adapter");
        MESSAGES.put("APPLICATION_MONITORING_FAIL", "J2CA7060.adapter.monitoring.fail");
    }
}

