/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.data;

import com.ibm.ws.logging.data.GenericData;
import com.ibm.ws.logging.data.NameAliases;
import java.util.Map;

public class AuditData
extends GenericData {
    public static final String[] NAMES_JSON = new String[]{"ibm_datetime", "ibm_sequence", "ibm_threadId", "host", "ibm_userDir", "ibm_serverName", "type"};
    private static final String[] NAMES_LC = new String[]{"datetime", "sequence", "threadId", "hostName", "wlpUserDir", "serverName", "type"};
    private static NameAliases jsonLoggingNameAliases = new NameAliases(NAMES_JSON);
    private static NameAliases logstashNameAliases = new NameAliases(NAMES_LC);
    private static NameAliases[] nameAliases = new NameAliases[]{jsonLoggingNameAliases, logstashNameAliases};

    public static void newJsonLoggingNameAliases(Map<String, String> newAliases) {
        jsonLoggingNameAliases.newAliases(newAliases);
    }

    public static void resetJsonLoggingNameAliases() {
        jsonLoggingNameAliases.resetAliases();
    }

    public AuditData() {
        super(14);
    }

    public static String getDatetimeKey(int format) {
        return AuditData.nameAliases[format].aliases[0];
    }

    public static String getSequenceKey(int format) {
        return AuditData.nameAliases[format].aliases[1];
    }

    public static String getThreadIDKey(int format) {
        return AuditData.nameAliases[format].aliases[2];
    }

    public static String getHostKey(int format) {
        return AuditData.nameAliases[format].aliases[3];
    }

    public static String getUserDirKey(int format) {
        return AuditData.nameAliases[format].aliases[4];
    }

    public static String getServerNameKey(int format) {
        return AuditData.nameAliases[format].aliases[5];
    }

    public static String getTypeKey(int format) {
        return AuditData.nameAliases[format].aliases[6];
    }
}

