/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.annocache.util.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.annocache.util.internal.UtilImpl_PoolParameters;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class UtilImpl_PoolExecutor
extends ThreadPoolExecutor {
    private static final String CLASS_NAME = UtilImpl_PoolExecutor.class.getSimpleName();
    private static final Logger logger = Logger.getLogger("com.ibm.ws.annocache.util");
    public static final int NON_BLOCKING_COUNT = 0;
    protected final Semaphore completionSemaphore;
    static final long serialVersionUID = -5999038863230139703L;

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static UtilImpl_PoolExecutor createBlockingExecutor(int completionCount) {
        return UtilImpl_PoolExecutor.createExecutor(UtilImpl_PoolParameters.createDefaultParameters(), completionCount);
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static UtilImpl_PoolExecutor createBlockingExecutor(int coreSize, int maxSize, int completionCount) {
        return UtilImpl_PoolExecutor.createExecutor(UtilImpl_PoolParameters.createDefaultParameters(), coreSize, maxSize, completionCount);
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static UtilImpl_PoolExecutor createNonBlockingExecutor() {
        return UtilImpl_PoolExecutor.createExecutor(UtilImpl_PoolParameters.createDefaultParameters(), 0);
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static UtilImpl_PoolExecutor createNonBlockingExecutor(int coreSize, int maxSize) {
        return UtilImpl_PoolExecutor.createExecutor(UtilImpl_PoolParameters.createDefaultParameters(), coreSize, maxSize, 0);
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static UtilImpl_PoolExecutor createExecutor(UtilImpl_PoolParameters parameters, int completionCount) {
        return new UtilImpl_PoolExecutor(parameters.coreSize, parameters.maxSize, parameters.keepAliveTime, parameters.keepAliveUnit, UtilImpl_PoolExecutor.createRunnableQueue(), completionCount);
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static UtilImpl_PoolExecutor createExecutor(UtilImpl_PoolParameters parameters, int coreSize, int maxSize, int completionCount) {
        return new UtilImpl_PoolExecutor(coreSize, maxSize, parameters.keepAliveTime, parameters.keepAliveUnit, UtilImpl_PoolExecutor.createRunnableQueue(), completionCount);
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static BlockingQueue<Runnable> createRunnableQueue() {
        return new LinkedBlockingQueue<Runnable>();
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static RejectedExecutionHandler createRejectionHandler() {
        return new RejectedExecutionHandler(){
            private final String INNER_CLASS_NAME = UtilImpl_PoolExecutor.access$000() + "$RejectedExecutionHandler";
            static final long serialVersionUID = 9220909252833770848L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                String methodName = "rejectedExecution";
                logger.logp(Level.WARNING, this.INNER_CLASS_NAME, methodName, "Executor [ {0} ] failed to schedule [ {1} ]", new Object[]{executor, r});
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.util.internal.UtilImpl_PoolExecutor$1", 1.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
            }
        };
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public UtilImpl_PoolExecutor(int corePoolSize, int maxPoolSize, long keepAliveTime, TimeUnit keepAliveUnit, BlockingQueue<Runnable> runnableQueue, int completionCount) {
        super(corePoolSize, maxPoolSize, keepAliveTime, keepAliveUnit, runnableQueue);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.util.internal.UtilImpl_PoolExecutor", "<init>", new Object[]{corePoolSize, maxPoolSize, keepAliveTime, keepAliveUnit, runnableQueue, completionCount});
        }
        this.completionSemaphore = completionCount > 0 ? new Semaphore(-(completionCount - 1)) : null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.util.internal.UtilImpl_PoolExecutor", "<init>", this);
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void execute(Runnable r) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.util.internal.UtilImpl_PoolExecutor", "execute", new Object[]{r});
        }
        super.execute(r);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.util.internal.UtilImpl_PoolExecutor", "execute");
        }
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Semaphore getCompletionSemaphore() {
        return this.completionSemaphore;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void completeExecution() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.util.internal.UtilImpl_PoolExecutor", "completeExecution", new Object[0]);
        }
        Semaphore useCompletionSemaphore = this.getCompletionSemaphore();
        if (useCompletionSemaphore == null) {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.exiting("com.ibm.ws.annocache.util.internal.UtilImpl_PoolExecutor", "completeExecution");
            }
            return;
        }
        useCompletionSemaphore.release();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.util.internal.UtilImpl_PoolExecutor", "completeExecution");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void waitForCompletion() throws InterruptedException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.util.internal.UtilImpl_PoolExecutor", "waitForCompletion", new Object[0]);
        }
        Semaphore useCompletionSemaphore = this.getCompletionSemaphore();
        if (useCompletionSemaphore == null) {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.exiting("com.ibm.ws.annocache.util.internal.UtilImpl_PoolExecutor", "waitForCompletion");
            }
            return;
        }
        useCompletionSemaphore.acquire();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.util.internal.UtilImpl_PoolExecutor", "waitForCompletion");
        }
    }

    static /* synthetic */ String access$000() {
        return CLASS_NAME;
    }
}

