/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.annocache.targets.cache.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.annocache.targets.cache.TargetCache_ParseError;
import com.ibm.ws.annocache.targets.cache.TargetCache_Readable;
import com.ibm.ws.annocache.targets.cache.TargetCache_Reader;
import com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataApp;
import com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataBase;
import com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataCon;
import com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary;
import com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer;
import com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_WriterBinary;
import com.ibm.ws.annocache.targets.internal.TargetsTableClassesMultiImpl;
import com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl;
import com.ibm.ws.annocache.targets.internal.TargetsTableImpl;
import com.ibm.ws.annocache.util.internal.UtilImpl_InternMap;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.annocache.classsource.ClassSource_Aggregate;
import com.ibm.wsspi.annocache.util.Util_Consumer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class TargetCacheImpl_DataMod
extends TargetCacheImpl_DataBase {
    private static final String CLASS_NAME;
    public static final boolean DO_READ_STRINGS = true;
    public static final boolean DO_READ_FULL = true;
    private final TargetCacheImpl_DataApp app;
    private final boolean isLightweight;
    private final boolean useBinaryFormat;
    protected final File containersFile;
    private final ConsLock consLock;
    private final Map<String, TargetCacheImpl_DataCon> cons;
    private TargetCacheImpl_DataCon seedCon;
    private TargetCacheImpl_DataCon partialCon;
    private TargetCacheImpl_DataCon excludedCon;
    private TargetCacheImpl_DataCon externalCon;
    private static final String[] RESULT_NAMES;
    private final File unresolvedRefsFile;
    protected final File resolvedRefsFile;
    protected final File classesFile;
    static final long serialVersionUID = -6619623607369566725L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public TargetCacheImpl_DataMod(TargetCacheImpl_DataApp app, String modName, String e_modName, File modDir, boolean isLightweight) {
        super(app.getFactory(), modName, e_modName, modDir);
        this.app = app;
        this.isLightweight = isLightweight;
        this.useBinaryFormat = this.getCacheOptions().getUseBinaryFormat();
        this.consLock = new ConsLock();
        this.cons = new HashMap<String, TargetCacheImpl_DataCon>();
        this.containersFile = this.getDataFile("containers");
        this.seedCon = null;
        this.partialCon = null;
        this.excludedCon = null;
        this.externalCon = null;
        this.classesFile = this.getDataFile("classes");
        this.unresolvedRefsFile = this.getDataFile("unresolved");
        this.resolvedRefsFile = this.getDataFile("resolved");
    }

    @Trivial
    public TargetCacheImpl_DataApp getApp() {
        return this.app;
    }

    @Trivial
    public boolean getIsLightweight() {
        return this.isLightweight;
    }

    @Override
    public File getDataFile(String relativePath) {
        if (this.getIsLightweight()) {
            return null;
        }
        return super.getDataFile(relativePath);
    }

    @Trivial
    public boolean getUseBinaryFormat() {
        return this.useBinaryFormat;
    }

    public File getContainersFile() {
        return this.containersFile;
    }

    public boolean hasContainersTable() {
        return this.exists(this.getContainersFile());
    }

    public boolean readContainerTable(final TargetsTableContainersImpl containerTable) {
        boolean didRead;
        long readStart = System.nanoTime();
        File useContainersFile = this.getContainersFile();
        if (this.getUseBinaryFormat()) {
            Util_Consumer<TargetCacheImpl_ReaderBinary, IOException> readAction = new Util_Consumer<TargetCacheImpl_ReaderBinary, IOException>(){
                static final long serialVersionUID = -480229182065463636L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public void accept(TargetCacheImpl_ReaderBinary reader) throws IOException {
                    reader.readEntire(containerTable);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataMod$1", 1.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
                }
            };
            didRead = this.readBinary(useContainersFile, true, true, readAction);
        } else {
            didRead = super.read(useContainersFile, containerTable);
        }
        long readDuration = this.addReadTime(readStart, "Containers");
        return didRead;
    }

    public void writeContainersTable(final TargetsTableContainersImpl containerTable) {
        Util_Consumer<TargetCacheImpl_WriterBinary, IOException> writeActionBinary;
        Util_Consumer<TargetCacheImpl_Writer, IOException> writeAction;
        if (this.getUseBinaryFormat()) {
            writeAction = null;
            writeActionBinary = new Util_Consumer<TargetCacheImpl_WriterBinary, IOException>(){
                static final long serialVersionUID = 4487122744583236375L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public void accept(TargetCacheImpl_WriterBinary writer) throws IOException {
                    writer.writeEntire(containerTable);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataMod$2", 2.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
                }
            };
        } else {
            writeAction = new Util_Consumer<TargetCacheImpl_Writer, IOException>(){
                static final long serialVersionUID = -1448307573513472374L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public void accept(TargetCacheImpl_Writer writer) throws IOException {
                    writer.write(containerTable);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataMod$3", 3.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
                }
            };
            writeActionBinary = null;
        }
        this.scheduleWrite("Containers", this.getContainersFile(), true, writeAction, writeActionBinary);
    }

    @Trivial
    protected Map<String, TargetCacheImpl_DataCon> getCons() {
        return this.cons;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TargetCacheImpl_DataCon getSourceConForcing(boolean isNamed, String conPath) {
        TargetCacheImpl_DataCon con;
        ConsLock consLock = this.consLock;
        synchronized (consLock) {
            Map<String, TargetCacheImpl_DataCon> useCons = this.getCons();
            con = useCons.get(conPath);
            if (con == null) {
                con = this.getApp().getSourceConForcing(isNamed, conPath);
                useCons.put(conPath, con);
            }
        }
        return con;
    }

    public long getContainerReadTime() {
        long containerReadTime = 0L;
        for (TargetCacheImpl_DataCon con : this.getCons().values()) {
            containerReadTime += con.getReadTime();
        }
        return containerReadTime;
    }

    public long getContainerWriteTime() {
        long containerWriteTime = 0L;
        for (TargetCacheImpl_DataCon con : this.getCons().values()) {
            containerWriteTime += con.getWriteTime();
        }
        return containerWriteTime;
    }

    @Trivial
    public TargetCacheImpl_DataCon createResultConData(String resultConName) {
        String e_resultConName = this.encode(resultConName);
        File e_resultConFile = this.e_getConFile(e_resultConName);
        return this.createConData(this, resultConName, e_resultConName, e_resultConFile, false);
    }

    @Trivial
    public static String getResultName(ClassSource_Aggregate.ScanPolicy scanPolicy) {
        return RESULT_NAMES[scanPolicy.ordinal()];
    }

    public TargetCacheImpl_DataCon getResultCon(ClassSource_Aggregate.ScanPolicy scanPolicy) {
        String resultConName = TargetCacheImpl_DataMod.getResultName(scanPolicy);
        if (scanPolicy == ClassSource_Aggregate.ScanPolicy.SEED) {
            if (this.seedCon == null) {
                this.seedCon = this.createResultConData(resultConName);
            }
            return this.seedCon;
        }
        if (scanPolicy == ClassSource_Aggregate.ScanPolicy.PARTIAL) {
            if (this.partialCon == null) {
                this.partialCon = this.createResultConData(resultConName);
            }
            return this.partialCon;
        }
        if (scanPolicy == ClassSource_Aggregate.ScanPolicy.EXCLUDED) {
            if (this.excludedCon == null) {
                this.excludedCon = this.createResultConData(resultConName);
            }
            return this.excludedCon;
        }
        if (scanPolicy == ClassSource_Aggregate.ScanPolicy.EXTERNAL) {
            if (this.externalCon == null) {
                this.externalCon = this.createResultConData(resultConName);
            }
            return this.externalCon;
        }
        throw new IllegalArgumentException("Unknown policy [ " + (Object)((Object)scanPolicy) + " ]");
    }

    public void writeResultCon(ClassSource_Aggregate.ScanPolicy scanPolicy, TargetsTableImpl resultData) {
        TargetCacheImpl_DataCon resultCon = this.getResultCon(scanPolicy);
        resultCon.writeStamp(this, resultData);
        resultCon.writeData(this, resultData);
    }

    public File getUnresolvedRefsFile() {
        return this.unresolvedRefsFile;
    }

    public boolean hasUnresolvedRefs() {
        return this.exists(this.getUnresolvedRefsFile());
    }

    public List<TargetCache_ParseError> basicReadUnresolvedRefs(UtilImpl_InternMap classNameInternMap, Set<String> i_unresolvedClassNames) throws FileNotFoundException, IOException {
        return this.createReader(this.getUnresolvedRefsFile()).readUnresolvedRefs(classNameInternMap, i_unresolvedClassNames);
    }

    public boolean readUnresolvedRefs(final UtilImpl_InternMap classNameInternMap, final Set<String> i_unresolvedClassNames) {
        boolean didRead;
        long readStart = System.nanoTime();
        File refsFile = this.getUnresolvedRefsFile();
        if (this.getUseBinaryFormat()) {
            Util_Consumer<TargetCacheImpl_ReaderBinary, IOException> readAction = new Util_Consumer<TargetCacheImpl_ReaderBinary, IOException>(){
                static final long serialVersionUID = 5128817535372638072L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public void accept(TargetCacheImpl_ReaderBinary reader) throws IOException {
                    reader.readEntireUnresolvedRefs(i_unresolvedClassNames, classNameInternMap);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataMod$4", 4.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
                }
            };
            didRead = this.readBinary(refsFile, false, true, readAction);
        } else {
            TargetCache_Readable refsReadable = new TargetCache_Readable(){
                static final long serialVersionUID = -9153927755435305608L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public List<TargetCache_ParseError> readUsing(TargetCache_Reader reader) throws IOException {
                    return TargetCacheImpl_DataMod.this.basicReadUnresolvedRefs(classNameInternMap, i_unresolvedClassNames);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataMod$5", 5.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
                }
            };
            didRead = super.read(refsFile, refsReadable);
        }
        long readDuration = this.addReadTime(readStart, "Unresolved Refs");
        return didRead;
    }

    public void writeUnresolvedRefs(Set<String> unresolvedClassNames) {
        Util_Consumer<TargetCacheImpl_WriterBinary, IOException> writeActionBinary;
        Util_Consumer<TargetCacheImpl_Writer, IOException> writeAction;
        if (!this.shouldWrite("Unresolved class references")) {
            return;
        }
        final Collection<String> useClassNames = this.isWriteSynchronous() ? unresolvedClassNames : new ArrayList<String>(unresolvedClassNames);
        if (this.getUseBinaryFormat()) {
            writeAction = null;
            writeActionBinary = new Util_Consumer<TargetCacheImpl_WriterBinary, IOException>(){
                static final long serialVersionUID = 3531693687455169619L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public void accept(TargetCacheImpl_WriterBinary writer) throws IOException {
                    writer.writeUnresolvedRefsEntire(useClassNames);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataMod$6", 6.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
                }
            };
        } else {
            writeAction = new Util_Consumer<TargetCacheImpl_Writer, IOException>(){
                static final long serialVersionUID = 1437606070843927938L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public void accept(TargetCacheImpl_Writer writer) throws IOException {
                    writer.writeUnresolvedRefs(useClassNames);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataMod$7", 7.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
                }
            };
            writeActionBinary = null;
        }
        this.scheduleWrite("Unresolved classes", this.getUnresolvedRefsFile(), true, writeAction, writeActionBinary);
    }

    public File getResolvedRefsFile() {
        return this.resolvedRefsFile;
    }

    public boolean hasResolvedRefs() {
        return this.exists(this.getResolvedRefsFile());
    }

    public List<TargetCache_ParseError> basicReadResolvedRefs(UtilImpl_InternMap classNameInternMap, Set<String> i_resolvedClassNames) throws FileNotFoundException, IOException {
        return this.createReader(this.getResolvedRefsFile()).readResolvedRefs(classNameInternMap, i_resolvedClassNames);
    }

    public boolean readResolvedRefs(final UtilImpl_InternMap classNameInternMap, final Set<String> i_resolvedClassNames) {
        boolean didRead;
        long readStart = System.nanoTime();
        File refsFile = this.getResolvedRefsFile();
        if (this.getUseBinaryFormat()) {
            Util_Consumer<TargetCacheImpl_ReaderBinary, IOException> readAction = new Util_Consumer<TargetCacheImpl_ReaderBinary, IOException>(){
                static final long serialVersionUID = 2216085755050265359L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public void accept(TargetCacheImpl_ReaderBinary reader) throws IOException {
                    reader.readEntireResolvedRefs(i_resolvedClassNames, classNameInternMap);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataMod$8", 8.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
                }
            };
            didRead = this.readBinary(refsFile, false, true, readAction);
        } else {
            TargetCache_Readable refsReadable = new TargetCache_Readable(){
                static final long serialVersionUID = -8927461326875719383L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public List<TargetCache_ParseError> readUsing(TargetCache_Reader reader) throws IOException {
                    return TargetCacheImpl_DataMod.this.basicReadResolvedRefs(classNameInternMap, i_resolvedClassNames);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataMod$9", 9.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
                }
            };
            didRead = super.read(refsFile, refsReadable);
        }
        long readDuration = this.addReadTime(readStart, "Resolved Refs");
        return didRead;
    }

    public void writeResolvedRefs(Set<String> resolvedClassNames) {
        Util_Consumer<TargetCacheImpl_WriterBinary, IOException> writeActionBinary;
        Util_Consumer<TargetCacheImpl_Writer, IOException> writeAction;
        if (!this.shouldWrite("Resolved class references")) {
            return;
        }
        final Collection<String> useClassNames = this.isWriteSynchronous() ? resolvedClassNames : new ArrayList<String>(resolvedClassNames);
        if (this.getUseBinaryFormat()) {
            writeAction = null;
            writeActionBinary = new Util_Consumer<TargetCacheImpl_WriterBinary, IOException>(){
                static final long serialVersionUID = 3974451529456295743L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public void accept(TargetCacheImpl_WriterBinary writer) throws IOException {
                    writer.writeResolvedRefsEntire(useClassNames);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataMod$10", 10.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
                }
            };
        } else {
            writeAction = new Util_Consumer<TargetCacheImpl_Writer, IOException>(){
                static final long serialVersionUID = 5487873451308709363L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public void accept(TargetCacheImpl_Writer writer) throws IOException {
                    writer.writeResolvedRefs(useClassNames);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataMod$11", 11.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
                }
            };
            writeActionBinary = null;
        }
        this.scheduleWrite("Resolved Classes", this.getResolvedRefsFile(), true, writeAction, writeActionBinary);
    }

    public File getClassesFile() {
        return this.classesFile;
    }

    public boolean hasClasses() {
        return this.exists(this.getClassesFile());
    }

    public boolean readClasses(final TargetsTableClassesMultiImpl classesTable) {
        boolean didRead;
        long readStart = System.nanoTime();
        File useClassesFile = this.getClassesFile();
        if (this.getUseBinaryFormat()) {
            Util_Consumer<TargetCacheImpl_ReaderBinary, IOException> readAction = new Util_Consumer<TargetCacheImpl_ReaderBinary, IOException>(){
                static final long serialVersionUID = 756461903727764869L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public void accept(TargetCacheImpl_ReaderBinary reader) throws IOException {
                    reader.readEntire(classesTable);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataMod$12", 12.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
                }
            };
            didRead = this.readBinary(useClassesFile, true, true, readAction);
        } else {
            didRead = this.read(useClassesFile, classesTable);
        }
        long readDuration = this.addReadTime(readStart, "Classes");
        return didRead;
    }

    public void writeClasses(final TargetsTableClassesMultiImpl classesTable) {
        Util_Consumer<TargetCacheImpl_WriterBinary, IOException> writeActionBinary;
        Util_Consumer<TargetCacheImpl_Writer, IOException> writeAction;
        if (!this.shouldWrite("Classes table")) {
            return;
        }
        if (this.getUseBinaryFormat()) {
            writeAction = null;
            writeActionBinary = new Util_Consumer<TargetCacheImpl_WriterBinary, IOException>(){
                static final long serialVersionUID = -1585480193386161711L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void accept(TargetCacheImpl_WriterBinary writer) throws IOException {
                    TargetsTableClassesMultiImpl targetsTableClassesMultiImpl = classesTable;
                    synchronized (targetsTableClassesMultiImpl) {
                        writer.writeEntire(classesTable);
                    }
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataMod$13", 13.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
                }
            };
        } else {
            writeAction = new Util_Consumer<TargetCacheImpl_Writer, IOException>(){
                static final long serialVersionUID = 8398532278316718470L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void accept(TargetCacheImpl_Writer writer) throws IOException {
                    TargetsTableClassesMultiImpl targetsTableClassesMultiImpl = classesTable;
                    synchronized (targetsTableClassesMultiImpl) {
                        writer.write(classesTable);
                    }
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataMod$14", 14.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
                }
            };
            writeActionBinary = null;
        }
        this.scheduleWrite("Classes", this.getClassesFile(), true, writeAction, writeActionBinary);
    }

    public boolean shouldAppRead(String inputDescription) {
        return this.getApp().shouldWrite(inputDescription);
    }

    @Override
    public boolean shouldRead(String inputDescription) {
        if (!this.isNamed() || this.getIsLightweight()) {
            return false;
        }
        if (!this.shouldAppRead(inputDescription)) {
            return false;
        }
        return super.shouldRead(inputDescription);
    }

    public boolean shouldAppWrite(String outputDescription) {
        return this.getApp().shouldWrite(outputDescription);
    }

    @Override
    public boolean shouldWrite(String outputDescription) {
        if (!this.isNamed() || this.getIsLightweight()) {
            return false;
        }
        if (!this.shouldAppWrite(outputDescription)) {
            return false;
        }
        return super.shouldWrite(outputDescription);
    }

    @Trivial
    protected boolean isWriteSynchronous() {
        return this.getApp().isWriteSynchronous();
    }

    @Trivial
    protected void scheduleWrite(String description, File outputFile, boolean doTruncate, Util_Consumer<TargetCacheImpl_Writer, IOException> writeAction, Util_Consumer<TargetCacheImpl_WriterBinary, IOException> writeActionBinary) {
        this.getApp().scheduleWrite(this, description, outputFile, doTruncate, writeAction, writeActionBinary);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataMod", TargetCacheImpl_DataMod.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
        CLASS_NAME = TargetCacheImpl_DataMod.class.getSimpleName();
        RESULT_NAMES = new String[ClassSource_Aggregate.ScanPolicy.values().length];
        TargetCacheImpl_DataMod.RESULT_NAMES[ClassSource_Aggregate.ScanPolicy.SEED.ordinal()] = "seed";
        TargetCacheImpl_DataMod.RESULT_NAMES[ClassSource_Aggregate.ScanPolicy.PARTIAL.ordinal()] = "partial";
        TargetCacheImpl_DataMod.RESULT_NAMES[ClassSource_Aggregate.ScanPolicy.EXCLUDED.ordinal()] = "excluded";
        TargetCacheImpl_DataMod.RESULT_NAMES[ClassSource_Aggregate.ScanPolicy.EXTERNAL.ordinal()] = "external";
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class ConsLock {
        static final long serialVersionUID = -2679920381336844487L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private ConsLock() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataMod$ConsLock", ConsLock.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
        }
    }
}

