/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi20.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.openapi20.utils.Constants;
import io.openliberty.microprofile.openapi20.utils.OpenAPIModelWalker;
import io.openliberty.microprofile.openapi20.validation.OASValidationResult;
import io.openliberty.microprofile.openapi20.validation.TypeValidator;
import io.openliberty.microprofile.openapi20.validation.ValidationHelper;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.Components;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ComponentsValidator
extends TypeValidator<Components> {
    private static final TraceComponent tc = Tr.register(ComponentsValidator.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.validation.ValidationMessages");
    private static final ComponentsValidator INSTANCE = new ComponentsValidator();
    static final long serialVersionUID = -6586492137153514420L;

    public static ComponentsValidator getInstance() {
        return INSTANCE;
    }

    @Override
    public void validate(ValidationHelper helper, OpenAPIModelWalker.Context context, String key, Components t) {
        if (t != null) {
            HashMap<String, Map> components = new HashMap<String, Map>();
            if (t.getCallbacks() != null && !t.getCallbacks().isEmpty()) {
                components.put("callbacks", t.getCallbacks());
            }
            if (t.getExamples() != null && !t.getExamples().isEmpty()) {
                components.put("examples", t.getExamples());
            }
            if (t.getHeaders() != null && !t.getHeaders().isEmpty()) {
                components.put("headers", t.getHeaders());
            }
            if (t.getLinks() != null && !t.getLinks().isEmpty()) {
                components.put("links", t.getLinks());
            }
            if (t.getParameters() != null && !t.getParameters().isEmpty()) {
                components.put("parameters", t.getParameters());
            }
            if (t.getRequestBodies() != null && !t.getRequestBodies().isEmpty()) {
                components.put("requestBodies", t.getRequestBodies());
            }
            if (t.getResponses() != null && !t.getResponses().isEmpty()) {
                components.put("responses", t.getResponses());
            }
            if (t.getSchemas() != null && !t.getSchemas().isEmpty()) {
                components.put("schemas", t.getSchemas());
            }
            if (t.getSecuritySchemes() != null && !t.getSecuritySchemes().isEmpty()) {
                components.put("securitySchemes", t.getSecuritySchemes());
            }
            if (!components.isEmpty()) {
                for (String mapName : components.keySet()) {
                    Map component = (Map)components.get(mapName);
                    boolean mapContainsInvalidKey = false;
                    for (String k : component.keySet()) {
                        if (k != null) {
                            String message;
                            if (!Constants.REGEX_COMPONENT_KEY_PATTERN.matcher(k).matches()) {
                                message = Tr.formatMessage((TraceComponent)tc, (String)"keyNotARegex", (Object[])new Object[]{k});
                                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(mapName), message));
                            }
                            if (component.get(k) != null) continue;
                            message = Tr.formatMessage((TraceComponent)tc, (String)"nullValueInMap", (Object[])new Object[]{k});
                            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(mapName), message));
                            continue;
                        }
                        mapContainsInvalidKey = true;
                    }
                    if (!mapContainsInvalidKey) continue;
                    String message = Tr.formatMessage((TraceComponent)tc, (String)"nullOrEmptyKeyInMap", (Object[])new Object[0]);
                    helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(mapName), message));
                }
            }
        }
    }

    private ComponentsValidator() {
    }
}

