/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.client;

import com.ibm.websphere.ras.ProtectedString;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jaxws.metadata.ConfigProperties;
import com.ibm.ws.jaxws.metadata.PortComponentRefInfo;
import com.ibm.ws.jaxws.metadata.WebServiceRefInfo;
import com.ibm.ws.jaxws.security.JaxWsSecurityConfigurationService;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transport.http.HTTPConduitConfigurer;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class LibertyCustomizeBindingOutInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final TraceComponent tc = Tr.register(LibertyCustomizeBindingOutInterceptor.class, null, null);
    private static final String HTTPS_SCHEMA = "https";
    private final JaxWsSecurityConfigurationService securityConfigService;
    private final Set<ConfigProperties> configPropertiesSet;
    protected final WebServiceRefInfo wsrInfo;
    static final long serialVersionUID = -8413784201154951120L;

    public LibertyCustomizeBindingOutInterceptor(WebServiceRefInfo wsrInfo, JaxWsSecurityConfigurationService securityConfigService, Set<ConfigProperties> configPropertiesSet) {
        super("prepare-send");
        this.wsrInfo = wsrInfo;
        this.securityConfigService = securityConfigService;
        this.configPropertiesSet = configPropertiesSet;
    }

    public void handleMessage(@Sensitive Message message) throws Fault {
        if (this.wsrInfo != null) {
            this.customizePortAddress(message);
            this.customizeClientProperties(message);
        }
        this.customizeClientSecurity(message);
    }

    public static boolean isEmpty(String str) {
        if (str == null || str.isEmpty()) {
            return true;
        }
        int len = str.length();
        for (int x = 0; x < len; ++x) {
            if (str.charAt(x) <= ' ') continue;
            return false;
        }
        return true;
    }

    public static final String trim(String value) {
        String result = null;
        if (null != value) {
            result = value.trim();
        }
        return result;
    }

    public static QName buildQName(String namespace, String localName) {
        String namespaceURI = namespace;
        if (!LibertyCustomizeBindingOutInterceptor.isEmpty(namespace) && !namespace.trim().endsWith("/")) {
            namespaceURI = namespaceURI + "/";
        }
        return new QName(namespaceURI, localName);
    }

    protected void customizeClientSecurity(Message message) {
        QName portName = this.getPortQName(message);
        if (null == this.securityConfigService) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The JaxWsSecurityConfigurationService is unavailable", (Object[])new Object[0]);
            }
            return;
        }
        boolean isSecured = false;
        String address = (String)message.get((Object)Message.ENDPOINT_ADDRESS);
        boolean bl = isSecured = address == null ? false : address.startsWith(HTTPS_SCHEMA);
        if (null == this.wsrInfo) {
            if (isSecured) {
                this.securityConfigService.configClientSSL(message.getExchange().getConduit(message), null, null);
            }
            return;
        }
        PortComponentRefInfo portRefInfo = this.wsrInfo.getPortComponentRefInfo(portName);
        if (null == portRefInfo) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Could not find the port component: " + portName + " for WebServiceRef: " + this.wsrInfo.getJndiName()), (Object[])new Object[0]);
            }
            if (isSecured) {
                this.securityConfigService.configClientSSL(message.getExchange().getConduit(message), null, null);
            }
        } else {
            String userName = portRefInfo.getUserName();
            ProtectedString password = portRefInfo.getPassword();
            this.securityConfigService.configBasicAuth(message.getExchange().getConduit(message), userName, password);
            if (isSecured) {
                this.securityConfigService.configClientSSL(message.getExchange().getConduit(message), portRefInfo.getSSLRef(), portRefInfo.getKeyAlias());
            }
        }
    }

    protected void customizeClientProperties(Message message) {
        if (null == this.configPropertiesSet) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"There are no client properties.", (Object[])new Object[0]);
            }
            return;
        }
        Bus bus = message.getExchange().getBus();
        if (null == bus) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The bus is null", (Object[])new Object[0]);
            }
            return;
        }
        for (ConfigProperties configProps : this.configPropertiesSet) {
            if (!"org.apache.cxf.http.conduits".equals(configProps.getFactoryPid())) continue;
            this.customizeHttpConduitProperties(message, bus, configProps);
        }
    }

    protected void customizePortAddress(Message message) {
        QName portQName;
        String address = null;
        PortComponentRefInfo portInfo = null;
        if (null != this.wsrInfo && null != (portQName = this.getPortQName(message))) {
            portInfo = this.wsrInfo.getPortComponentRefInfo(portQName);
            String string = address = null != portInfo && null != portInfo.getAddress() ? portInfo.getAddress() : this.wsrInfo.getDefaultPortAddress();
        }
        if (null != address) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("The endpoint address is overriden by " + address), (Object[])new Object[0]);
            }
            message.put((Object)Message.ENDPOINT_ADDRESS, address);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void customizeHttpConduitProperties(Message message, Bus bus, ConfigProperties configProps) {
        Conduit conduit = message.getExchange().getConduit(message);
        HTTPConduitConfigurer conduitConfigurer = (HTTPConduitConfigurer)bus.getExtension(HTTPConduitConfigurer.class);
        if (conduitConfigurer != null && conduit instanceof HTTPConduit) {
            HTTPConduit httpConduit = (HTTPConduit)conduit;
            String address = (String)message.get((Object)Message.ENDPOINT_ADDRESS);
            if (conduitConfigurer instanceof ManagedServiceFactory) {
                String portQNameStr = this.getPortQName(message).toString();
                try {
                    ((ManagedServiceFactory)conduitConfigurer).updated(portQNameStr, configProps.getProperties());
                    conduitConfigurer.configure(portQNameStr, address, httpConduit);
                }
                catch (ConfigurationException configurationException) {
                    void e;
                    FFDCFilter.processException((Throwable)configurationException, (String)"com.ibm.ws.jaxws.client.LibertyCustomizeBindingOutInterceptor", (String)"258", (Object)((Object)this), (Object[])new Object[]{message, bus, configProps});
                    throw new Fault((Throwable)e);
                }
            }
        }
    }

    private QName getPortQName(Message message) {
        Object wsdlPort = message.getExchange().get((Object)"javax.xml.ws.wsdl.port");
        String namespace = "";
        String localName = "";
        if (null != wsdlPort && wsdlPort instanceof QName) {
            namespace = ((QName)wsdlPort).getNamespaceURI();
            localName = ((QName)wsdlPort).getLocalPart();
            return LibertyCustomizeBindingOutInterceptor.buildQName(namespace, localName);
        }
        return null;
    }
}

