/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.resolver;

import graphql.TypeResolutionEnvironment;
import graphql.schema.GraphQLObjectType;
import graphql.schema.TypeResolver;
import io.smallrye.graphql.SmallRyeGraphQLServerMessages;
import io.smallrye.graphql.execution.resolver.InterfaceOutputRegistry;
import io.smallrye.graphql.schema.model.InterfaceType;

public class InterfaceResolver
implements TypeResolver {
    private final InterfaceType interfaceType;

    public InterfaceResolver(InterfaceType interfaceType) {
        this.interfaceType = interfaceType;
    }

    public GraphQLObjectType getType(TypeResolutionEnvironment tre) {
        String concreteClassName = tre.getObject().getClass().getName();
        GraphQLObjectType graphQLObjectType = InterfaceOutputRegistry.getGraphQLObjectType(this.interfaceType.getClassName(), concreteClassName);
        if (graphQLObjectType != null) {
            return graphQLObjectType;
        }
        throw SmallRyeGraphQLServerMessages.msg.concreteClassNotFoundForInterface(concreteClassName, this.interfaceType.getClassName());
    }
}

