/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.typesafe.impl.json;

import io.smallrye.graphql.client.typesafe.api.GraphQlClientException;
import io.smallrye.graphql.client.typesafe.impl.CollectionUtils;
import io.smallrye.graphql.client.typesafe.impl.json.GraphQlClientValueException;
import io.smallrye.graphql.client.typesafe.impl.json.IndexedLocationBuilder;
import io.smallrye.graphql.client.typesafe.impl.json.JsonReader;
import io.smallrye.graphql.client.typesafe.impl.json.Location;
import io.smallrye.graphql.client.typesafe.impl.json.Reader;
import io.smallrye.graphql.client.typesafe.impl.reflection.TypeInfo;
import java.util.List;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.json.JsonArray;
import javax.json.JsonValue;

class JsonArrayReader
extends Reader<JsonArray> {
    private Class<?> collectionType;
    private TypeInfo itemType;

    JsonArrayReader(TypeInfo type, Location location, JsonArray value) {
        super(type, location, value);
    }

    @Override
    Object read() {
        GraphQlClientValueException.check(this.location, this.value, this.type.isCollection());
        IndexedLocationBuilder locationBuilder = new IndexedLocationBuilder(this.location);
        return ((JsonArray)this.value).stream().map(item -> this.readItem(locationBuilder, (JsonValue)item)).collect(this.collector());
    }

    private Object readItem(IndexedLocationBuilder locationBuilder, JsonValue itemValue) {
        Location itemLocation = locationBuilder.nextLocation();
        TypeInfo itemType = this.getItemType();
        if (itemValue.getValueType() == JsonValue.ValueType.NULL && itemType.isNonNull()) {
            throw new GraphQlClientException("invalid null " + itemLocation);
        }
        return JsonReader.readJson(itemLocation, itemType, itemValue);
    }

    private Collector<Object, ?, ?> collector() {
        if (this.getCollectionType().isArray()) {
            Class<?> rawItemType = this.getItemType().getRawType();
            return CollectionUtils.toArray(rawItemType);
        }
        if (Set.class.isAssignableFrom(this.getCollectionType())) {
            return Collectors.toSet();
        }
        assert (List.class.isAssignableFrom(this.getCollectionType()));
        return Collectors.toList();
    }

    private Class<?> getCollectionType() {
        if (this.collectionType == null) {
            this.collectionType = this.type.getRawType();
        }
        return this.collectionType;
    }

    private TypeInfo getItemType() {
        if (this.itemType == null) {
            this.itemType = this.type.getItemType();
        }
        return this.itemType;
    }
}

