/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OCI.IIOP;

import org.apache.yoko.orb.CORBA.OutputStream;
import org.apache.yoko.orb.OB.CorbalocProtocol;
import org.apache.yoko.orb.OB.MinorCodes;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.LocalObject;
import org.omg.IIOP.ProfileBody_1_0;
import org.omg.IIOP.ProfileBody_1_0Helper;
import org.omg.IIOP.ProfileBody_1_1;
import org.omg.IIOP.ProfileBody_1_1Helper;
import org.omg.IIOP.Version;
import org.omg.IOP.TaggedComponent;
import org.omg.IOP.TaggedProfile;

public class CorbalocProtocol_impl
extends LocalObject
implements CorbalocProtocol {
    @Override
    public String name() {
        return "iiop";
    }

    @Override
    public TaggedProfile parse_address(String addr, byte[] key) {
        byte minor;
        byte major;
        int start = 0;
        int at = addr.indexOf(64);
        if (at == -1) {
            major = 1;
            minor = 0;
        } else {
            int dot = 0;
            boolean seenDot = false;
            boolean ok = true;
            for (int pos = 0; pos < at && ok; ++pos) {
                char ch = addr.charAt(pos);
                if (ch == '.') {
                    if (seenDot || pos == 0 || pos == at - 1) {
                        ok = false;
                    }
                    seenDot = true;
                    dot = pos;
                    continue;
                }
                if (Character.isDigit(ch)) continue;
                ok = false;
            }
            if (!ok || !seenDot) {
                throw new BAD_PARAM(MinorCodes.describeBadParam(1330446344) + ": iiop version must be of the form `X.Y'", 1330446344, CompletionStatus.COMPLETED_NO);
            }
            int nMajor = 0;
            int nMinor = 0;
            try {
                nMajor = Integer.parseInt(addr.substring(0, dot));
                nMinor = Integer.parseInt(addr.substring(dot + 1, at));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (nMajor != 1 || nMinor > 255) {
                throw new BAD_PARAM(MinorCodes.describeBadParam(1330446344) + ": iiop version is invalid or unsupported", 1330446344, CompletionStatus.COMPLETED_NO);
            }
            if (nMinor > 2) {
                nMinor = 2;
            }
            major = (byte)nMajor;
            minor = (byte)nMinor;
            start = at + 1;
        }
        if (start == addr.length() || addr.charAt(start) == ':') {
            throw new BAD_PARAM(MinorCodes.describeBadParam(1330446344) + ": iiop hostname must be specified", 1330446344, CompletionStatus.COMPLETED_NO);
        }
        int colon = addr.indexOf(58, start);
        String host = colon == -1 ? addr.substring(start) : addr.substring(start, colon);
        int port = 2809;
        if (colon != -1 && colon < addr.length()) {
            String str = addr.substring(colon + 1);
            try {
                port = Integer.parseInt(str);
            }
            catch (NumberFormatException ex) {
                throw new BAD_PARAM(MinorCodes.describeBadParam(1330446344) + ": iiop port is invalid", 1330446344, CompletionStatus.COMPLETED_NO);
            }
            if (port < 1 || port > 65535) {
                throw new BAD_PARAM(MinorCodes.describeBadParam(1330446344) + ": iiop port must be between 1 and 65535", 1330446344, CompletionStatus.COMPLETED_NO);
            }
        }
        TaggedProfile profile = new TaggedProfile();
        profile.tag = 0;
        if (major == 1 && minor == 0) {
            ProfileBody_1_0 body = new ProfileBody_1_0();
            body.iiop_version = new Version(major, minor);
            body.host = host;
            body.port = port >= 32768 ? (short)(port - 65535 - 1) : (short)port;
            body.object_key = key;
            try (OutputStream out = new OutputStream();){
                out._OB_writeEndian();
                ProfileBody_1_0Helper.write((org.omg.CORBA.portable.OutputStream)out, (ProfileBody_1_0)body);
                profile.profile_data = out.copyWrittenBytes();
            }
        }
        ProfileBody_1_1 body = new ProfileBody_1_1();
        body.iiop_version = new Version(major, minor);
        body.host = host;
        body.port = port >= 32768 ? (short)(port - 65535 - 1) : (short)port;
        body.object_key = key;
        body.components = new TaggedComponent[0];
        try (OutputStream out = new OutputStream();){
            out._OB_writeEndian();
            ProfileBody_1_1Helper.write((org.omg.CORBA.portable.OutputStream)out, (ProfileBody_1_1)body);
            profile.profile_data = out.copyWrittenBytes();
        }
        return profile;
    }

    @Override
    public void destroy() {
    }
}

