/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OBPortableServer;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.yoko.orb.CORBA.Delegate;
import org.apache.yoko.orb.OB.Assert;
import org.apache.yoko.orb.OB.BootManager_impl;
import org.apache.yoko.orb.OB.CollocatedServer;
import org.apache.yoko.orb.OB.InitialServiceManager;
import org.apache.yoko.orb.OB.LocationForward;
import org.apache.yoko.orb.OB.OAInterface;
import org.apache.yoko.orb.OB.ORBInstance;
import org.apache.yoko.orb.OB.ObjectKey;
import org.apache.yoko.orb.OB.ObjectKeyData;
import org.apache.yoko.orb.OB.PIManager;
import org.apache.yoko.orb.OB.RefCountPolicyList;
import org.apache.yoko.orb.OB.ServerManager;
import org.apache.yoko.orb.OBPortableServer.CommunicationsConcurrencyPolicy;
import org.apache.yoko.orb.OBPortableServer.CommunicationsConcurrencyPolicyHelper;
import org.apache.yoko.orb.OBPortableServer.DirectServant;
import org.apache.yoko.orb.OBPortableServer.GIOPVersionPolicy;
import org.apache.yoko.orb.OBPortableServer.GIOPVersionPolicyHelper;
import org.apache.yoko.orb.OBPortableServer.POALocator;
import org.apache.yoko.orb.OBPortableServer.POAManager;
import org.apache.yoko.orb.OBPortableServer.POANameHasher;
import org.apache.yoko.orb.OBPortableServer.POAOAInterface_impl;
import org.apache.yoko.orb.OBPortableServer.POA_impl;
import org.apache.yoko.orb.OCI.Acceptor;
import org.apache.yoko.orb.PortableServer.Current_impl;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyError;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.GIOP.Version;
import org.omg.IOP.IOR;
import org.omg.PortableServer.CurrentPackage.NoContext;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAManagerPackage.State;

public final class POAManager_impl
extends LocalObject
implements POAManager {
    static final Logger logger = Logger.getLogger(POAManager_impl.class.getName());
    private ORBInstance orbInstance_;
    private Hashtable poas_;
    private State state_;
    private Acceptor[] acceptors_;
    private ServerManager serverManager_;
    private String id_;
    String adapterManagerId_;
    private OAInterface oaInterface_;
    private Version version_ = new Version();
    private BootManager_impl bootManagerImpl_;
    private POALocator poaLocator_;
    private String serverId_;

    private boolean isInORBUpcall() {
        boolean inInvocation = false;
        try {
            InitialServiceManager initialServiceManager = this.orbInstance_.getInitialServiceManager();
            Object o = initialServiceManager.resolveInitialReferences("POACurrent");
            Current_impl current = (Current_impl)o;
            inInvocation = current._OB_inUpcall();
            if (inInvocation) {
                try {
                    POA_impl p = (POA_impl)current.get_POA();
                    inInvocation = p._OB_ORBInstance() == this.orbInstance_;
                }
                catch (NoContext noContext) {}
            }
        }
        catch (InvalidName invalidName) {
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return inInvocation;
    }

    private void waitPendingRequests() {
        Enumeration keys = this.poas_.keys();
        while (keys.hasMoreElements()) {
            POA_impl poaImpl = (POA_impl)this.poas_.get(keys.nextElement());
            poaImpl._OB_waitPendingRequests();
        }
    }

    private void etherealizePOAs() {
        try {
            InitialServiceManager initialServiceManager = this.orbInstance_.getInitialServiceManager();
            Object o = initialServiceManager.resolveInitialReferences("RootPOA");
            POA_impl rootPOA = (POA_impl)o;
            rootPOA._OB_etherealize(this);
        }
        catch (InvalidName invalidName) {
            // empty catch block
        }
    }

    public synchronized void activate() throws AdapterInactive {
        logger.fine("Activating POAManager " + this.id_ + " current state is " + this.state_);
        if (this.state_ == State.INACTIVE) {
            throw new AdapterInactive();
        }
        if (this.state_ == State.ACTIVE) {
            logger.fine("POAManager already active, returning");
            return;
        }
        this.state_ = State.ACTIVE;
        this.notifyAll();
        this.serverManager_.activate();
        this.oaInterface_.activate();
        PIManager piManager = this.orbInstance_.getPIManager();
        piManager.adapterManagerStateChange(this.adapterManagerId_, this._OB_getAdapterState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hold_requests(boolean waitCompletion) throws AdapterInactive {
        POAManager_impl pOAManager_impl = this;
        synchronized (pOAManager_impl) {
            if (this.state_ == State.INACTIVE) {
                throw new AdapterInactive();
            }
            if (this.state_ == State.HOLDING) {
                return;
            }
            if (waitCompletion && this.isInORBUpcall()) {
                throw new BAD_INV_ORDER("Invocation in progress", 0, CompletionStatus.COMPLETED_NO);
            }
            this.state_ = State.HOLDING;
            this.notifyAll();
            this.serverManager_.hold();
            this.oaInterface_.activate();
            PIManager piManager = this.orbInstance_.getPIManager();
            piManager.adapterManagerStateChange(this.adapterManagerId_, this._OB_getAdapterState());
        }
        if (waitCompletion) {
            this.waitPendingRequests();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discard_requests(boolean waitCompletion) throws AdapterInactive {
        POAManager_impl pOAManager_impl = this;
        synchronized (pOAManager_impl) {
            if (this.state_ == State.INACTIVE) {
                throw new AdapterInactive();
            }
            if (this.state_ == State.DISCARDING) {
                return;
            }
            if (waitCompletion && this.isInORBUpcall()) {
                throw new BAD_INV_ORDER("Invocation in progress", 0, CompletionStatus.COMPLETED_NO);
            }
            this.state_ = State.DISCARDING;
            this.notifyAll();
            this.oaInterface_.discard();
            this.serverManager_.activate();
            PIManager piManager = this.orbInstance_.getPIManager();
            piManager.adapterManagerStateChange(this.adapterManagerId_, this._OB_getAdapterState());
        }
        if (waitCompletion) {
            this.waitPendingRequests();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate(boolean etherealize, boolean waitCompletion) throws AdapterInactive {
        POAManager_impl pOAManager_impl = this;
        synchronized (pOAManager_impl) {
            if (this.state_ == State.INACTIVE) {
                return;
            }
            if (waitCompletion && this.isInORBUpcall()) {
                throw new BAD_INV_ORDER("Invocation in progress", 0, CompletionStatus.COMPLETED_NO);
            }
            this.serverManager_.destroy();
            this.acceptors_ = null;
            this.state_ = State.INACTIVE;
            this.notifyAll();
            PIManager piManager = this.orbInstance_.getPIManager();
            piManager.adapterManagerStateChange(this.adapterManagerId_, this._OB_getAdapterState());
        }
        if (waitCompletion) {
            this.waitPendingRequests();
        }
        if (etherealize) {
            this.etherealizePOAs();
        }
    }

    public State get_state() {
        return this.state_;
    }

    public String get_id() {
        return this.id_;
    }

    @Override
    public synchronized Acceptor[] get_acceptors() throws AdapterInactive {
        if (this.state_ == State.INACTIVE) {
            throw new AdapterInactive();
        }
        Acceptor[] result = new Acceptor[this.acceptors_.length];
        System.arraycopy(this.acceptors_, 0, result, 0, this.acceptors_.length);
        return result;
    }

    POAManager_impl(ORBInstance orbInstance, POALocator poaLocator, String id, String adapterManagerId, Acceptor[] acceptors, Policy[] policies) throws PolicyError {
        boolean giopPolicyPresent;
        boolean commsPolicyPresent;
        this.orbInstance_ = orbInstance;
        this.poas_ = new Hashtable(63);
        this.state_ = State.HOLDING;
        this.acceptors_ = acceptors;
        this.id_ = id;
        this.adapterManagerId_ = adapterManagerId;
        this.poaLocator_ = poaLocator;
        this.serverId_ = this.orbInstance_.getServerId();
        if (this.serverId_.length() == 0) {
            this.serverId_ = "_RootPOA";
        }
        this.oaInterface_ = new POAOAInterface_impl(this, this.orbInstance_);
        String rootKey = "yoko.orb.poamanager." + this.id_ + ".";
        int rootKeyLen = rootKey.length();
        Properties properties = orbInstance.getProperties();
        String[] props = new String[]{"conc_model", "endpoint", "version"};
        int numProps = props.length;
        CommunicationsConcurrencyPolicy commsPolicy = null;
        GIOPVersionPolicy giopPolicy = null;
        int nPolicies = policies.length;
        if (nPolicies != 0) {
            for (int i = 0; i < nPolicies; ++i) {
                int policyType = policies[i].policy_type();
                if (policyType == 1330577668) {
                    commsPolicy = CommunicationsConcurrencyPolicyHelper.narrow((Object)policies[i]);
                    continue;
                }
                if (policyType == 1330577670) {
                    giopPolicy = GIOPVersionPolicyHelper.narrow((Object)policies[i]);
                    continue;
                }
                throw new PolicyError(2);
            }
        }
        Enumeration<java.lang.Object> keys = properties.keys();
        while (keys.hasMoreElements()) {
            int i;
            String prop;
            String key = (String)keys.nextElement();
            if (key.equals("yoko.orb.oa.thread_pool")) continue;
            if (key.startsWith(rootKey)) {
                prop = key.substring(rootKeyLen);
            } else {
                if (!key.startsWith("yoko.orb.oa.")) continue;
                prop = key.substring("yoko.orb.oa.".length());
            }
            for (i = 0; i < numProps && !prop.equals(props[i]); ++i) {
            }
            if (i < numProps) continue;
            String err = key + ": unknown property";
            logger.warning(err);
        }
        this.version_.major = 1;
        this.version_.minor = (byte)2;
        int concModel = 2;
        if (commsPolicy == null) {
            commsPolicyPresent = false;
        } else {
            commsPolicyPresent = true;
            short value = commsPolicy.value();
            if (value == 0) {
                concModel = 0;
            } else if (value == 1) {
                concModel = 2;
            } else {
                throw new PolicyError(3);
            }
        }
        if (giopPolicy == null) {
            giopPolicyPresent = false;
        } else {
            giopPolicyPresent = true;
            short value = giopPolicy.value();
            if (value == 0) {
                this.version_.major = 1;
                this.version_.minor = 0;
            } else if (value == 1) {
                this.version_.major = 1;
                this.version_.minor = 1;
            } else if (value == 2) {
                this.version_.major = 1;
                this.version_.minor = (byte)2;
            } else {
                throw new PolicyError(3);
            }
        }
        if (!commsPolicyPresent || !giopPolicyPresent) {
            for (int i = 0; i < numProps; ++i) {
                String err;
                String key = props[i];
                String fullkey = rootKey + key;
                String value = properties.getProperty(fullkey);
                if (value == null) {
                    fullkey = "yoko.orb.oa." + key;
                    value = properties.getProperty(fullkey);
                }
                if (value == null) continue;
                if (key.equals("conc_model") && !commsPolicyPresent) {
                    if (value.equals("threaded")) {
                        concModel = 2;
                        continue;
                    }
                    if (value.equals("thread_per_client")) {
                        concModel = 2;
                        continue;
                    }
                    if (value.equals("thread_per_request")) {
                        concModel = 2;
                        continue;
                    }
                    if (value.equals("thread_pool")) {
                        concModel = 2;
                        continue;
                    }
                    err = fullkey + ": unknown value";
                    logger.warning(err);
                    continue;
                }
                if (!key.equals("version") || giopPolicyPresent) continue;
                if (value.equals("1.0")) {
                    this.version_.major = 1;
                    this.version_.minor = 0;
                    continue;
                }
                if (value.equals("1.1")) {
                    this.version_.major = 1;
                    this.version_.minor = 1;
                    continue;
                }
                if (value.equals("1.2")) {
                    this.version_.major = 1;
                    this.version_.minor = (byte)2;
                    continue;
                }
                err = fullkey + ": expected `1.0', `1.1' or `1.2'";
                logger.severe(err);
                throw new INITIALIZE(err);
            }
        }
        this.serverManager_ = new ServerManager(this.orbInstance_, this.acceptors_, this.oaInterface_, concModel);
        this.bootManagerImpl_ = (BootManager_impl)orbInstance.getBootManager();
    }

    synchronized void _OB_addPOA(POA poa, String[] id) {
        POANameHasher idkey = new POANameHasher(id);
        logger.fine("Adding new poa with id " + idkey);
        Assert.ensure(!this.poas_.containsKey(idkey));
        this.poas_.put(idkey, poa);
        this.poaLocator_.add(poa, id);
    }

    synchronized void _OB_removePOA(String[] id) {
        POANameHasher idkey = new POANameHasher(id);
        logger.fine("Removing poa with id " + idkey);
        Assert.ensure(this.poas_.containsKey(idkey));
        this.poas_.remove(idkey);
        this.poaLocator_.remove(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DirectServant _OB_getDirectServant(byte[] key, RefCountPolicyList policies) throws LocationForward, AdapterInactive {
        POAManager_impl pOAManager_impl = this;
        synchronized (pOAManager_impl) {
            if (this.state_ == State.INACTIVE) {
                throw new AdapterInactive();
            }
        }
        ObjectKeyData data = new ObjectKeyData();
        if (ObjectKey.ParseObjectKey(key, data)) {
            POA poa;
            POAManager_impl pOAManager_impl2 = this;
            synchronized (pOAManager_impl2) {
                poa = this._OB_locatePOA(data);
            }
            if (poa != null) {
                POA_impl poaImpl = (POA_impl)poa;
                return poaImpl._OB_getDirectServant(data.oid, policies);
            }
        }
        POAManager_impl pOAManager_impl3 = this;
        synchronized (pOAManager_impl3) {
            IOR ior = this.bootManagerImpl_._OB_locate(key);
            if (ior != null) {
                throw new LocationForward(ior, false);
            }
        }
        throw new OBJECT_NOT_EXIST("No POA for local servant");
    }

    POA _OB_locatePOA(ObjectKeyData data) throws LocationForward {
        POA_impl poaImpl;
        Assert.ensure(this.get_state() != State.INACTIVE);
        logger.fine("Searching for direct servant with key " + data);
        POA poa = null;
        if (data.serverId.equals(this.serverId_)) {
            POANameHasher key = new POANameHasher(data.poaId);
            logger.fine("Searching for direct servant with poa key " + key);
            poa = (POA)this.poas_.get(key);
            if (poa == null && (poa = this.poaLocator_.locate(data)) != null) {
                logger.fine("Attempting to obtain a local reference to an object activated on a differnt POA");
                org.omg.PortableServer.POAManager manager = poa.the_POAManager();
                if (manager != this) {
                    Object obj = poa.create_reference_with_id(data.oid, "");
                    Delegate p = (Delegate)((ObjectImpl)obj)._get_delegate();
                    IOR ior = p._OB_IOR();
                    throw new LocationForward(ior, false);
                }
            }
        }
        if (poa != null && !(poaImpl = (POA_impl)poa)._OB_poaMatches(data, false)) {
            logger.fine("POA located but object key data doesn't match");
            poa = null;
        }
        return poa;
    }

    public CollocatedServer _OB_getCollocatedServer() {
        return this.serverManager_.getCollocatedServer();
    }

    public synchronized void _OB_validateState() {
        while (this.state_ != State.ACTIVE) {
            if (this.state_ == State.INACTIVE || this.state_ == State.DISCARDING) {
                throw new TRANSIENT("POAManager is inactive or discarding requests", 0, CompletionStatus.COMPLETED_NO);
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public Version _OB_getGIOPVersion() {
        return new Version(this.version_.major, this.version_.minor);
    }

    public String _OB_getAdapterManagerId() {
        return this.adapterManagerId_;
    }

    public short _OB_getAdapterState() {
        switch (this.state_.value()) {
            case 3: {
                return 3;
            }
            case 1: {
                return 1;
            }
            case 0: {
                return 0;
            }
            case 2: {
                return 2;
            }
        }
        throw Assert.fail();
    }

    public Acceptor[] _OB_getAcceptors() {
        Acceptor[] result = new Acceptor[this.acceptors_.length];
        System.arraycopy(this.acceptors_, 0, result, 0, this.acceptors_.length);
        return result;
    }

    public ServerManager _OB_getServerManager() {
        return this.serverManager_;
    }

    public OAInterface _OB_getOAInterface() {
        return this.oaInterface_;
    }
}

