/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OB;

import java.util.Vector;
import org.apache.yoko.orb.CORBA.OutputStream;
import org.apache.yoko.orb.OB.Assert;
import org.apache.yoko.orb.OB.Downcall;
import org.apache.yoko.orb.OB.GIOPOutgoingMessage;
import org.apache.yoko.orb.OB.ORBInstance;
import org.apache.yoko.orb.OB.UnsentMessage;
import org.apache.yoko.orb.OB.Util;
import org.apache.yoko.orb.OCI.ProfileInfo;
import org.apache.yoko.orb.OCI.ReadBuffer;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.SystemException;
import org.omg.GIOP.MsgType_1_1;

public class MessageQueue {
    private final Vector<UnsentMessage> unsent_ = new Vector();
    private final Vector<Downcall> pending_ = new Vector();

    public void add(ORBInstance orbInstance, ReadBuffer readBuffer) {
        this.unsent_.addElement(new UnsentMessage(readBuffer));
    }

    public void add(ORBInstance orbInstance, Downcall down) {
        try {
            OutputStream out = down.output();
            int pos = out.getPosition();
            out.setPosition(0);
            ProfileInfo profileInfo = down.profileInfo();
            GIOPOutgoingMessage outgoing = new GIOPOutgoingMessage(orbInstance, out, profileInfo);
            if ("_locate".equals(down.operation())) {
                outgoing.writeMessageHeader(MsgType_1_1.LocateRequest, false, pos - 12);
            } else {
                outgoing.writeMessageHeader(MsgType_1_1.Request, false, pos - 12);
            }
            out.setPosition(pos);
        }
        catch (SystemException ex) {
            Assert.ensure(ex.completed == CompletionStatus.COMPLETED_NO);
            down.setFailureException(ex);
            return;
        }
        this.unsent_.addElement(new UnsentMessage(down));
    }

    public ReadBuffer getFirstUnsentBuffer() {
        return this.unsent_.isEmpty() ? null : this.unsent_.firstElement().getBufferReader();
    }

    public Downcall moveFirstUnsentToPending() {
        if (this.unsent_.isEmpty()) {
            return null;
        }
        UnsentMessage m = this.unsent_.firstElement();
        Downcall down = m.down;
        this.unsent_.removeElementAt(0);
        if (down != null) {
            if (down.responseExpected()) {
                down.setPending();
                this.pending_.addElement(down);
            } else {
                down.setNoException(null);
            }
        }
        return down;
    }

    public Downcall findAndRemovePending(int reqId) {
        for (int i = 0; i < this.pending_.size(); ++i) {
            Downcall d = this.pending_.elementAt(i);
            if (d.requestId() != reqId) continue;
            this.pending_.removeElementAt(i);
            return d;
        }
        return null;
    }

    public void setException(SystemException ex, boolean notCompleted) {
        while (!this.unsent_.isEmpty()) {
            UnsentMessage m = this.unsent_.firstElement();
            if (m.down != null) {
                m.down.setFailureException(ex);
            }
            this.unsent_.removeElementAt(0);
        }
        SystemException except = Util.copySystemException(ex);
        CompletionStatus completionStatus = except.completed = notCompleted ? CompletionStatus.COMPLETED_NO : CompletionStatus.COMPLETED_MAYBE;
        while (!this.pending_.isEmpty()) {
            Downcall down = this.pending_.firstElement();
            down.setFailureException(except);
            this.pending_.removeElementAt(0);
        }
    }

    public boolean hasUnsent() {
        return !this.unsent_.isEmpty();
    }
}

